/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.documentserver.managers.document;

import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.file.util.AppFileUtil;
import com.hotent.office.documentserver.managers.document.DocumentManager;
import com.hotent.office.documentserver.storage.FileStorageMutator;
import com.hotent.office.documentserver.storage.FileStoragePathBuilder;
import com.hotent.office.documentserver.storage.LocalFileStorage;
import com.hotent.office.documentserver.util.file.FileUtility;
import com.hotent.office.documentserver.util.service.ServiceConverter;
import com.hotent.office.model.DefaultFile;
import com.hotent.office.model.OfficeAttachment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
@Primary
public class DefaultDocumentManager
implements DocumentManager {
    @Value(value="${files.storage.folder}")
    private String storageFolder;
    @Value(value="${files.storage}")
    private String filesStorage;
    @Value(value="${url.track}")
    private String trackUrl;
    @Value(value="${url.download}")
    private String downloadUrl;
    @Autowired
    private FileStorageMutator storageMutator;
    @Autowired
    private FileStoragePathBuilder storagePathBuilder;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private ServiceConverter serviceConverter;
    @Autowired
    private LocalFileStorage localFileStorage;

    @Override
    public String getCreateUrl(String fileName, Boolean sample) {
        String fileExt = fileName.substring(fileName.length() - 4);
        String url = this.storagePathBuilder.getServerUrl(true) + "/office/v1/create?fileExt=" + fileExt + "&sample=" + sample;
        return url;
    }

    @Override
    public String getCreateUrl(DefaultFile defaultFile, Boolean sample) {
        String url = this.storagePathBuilder.getServerUrl(true) + "/office/v1/create?fileExt=" + defaultFile.getFileExt() + "&categoryId=" + defaultFile.getCategoryId() + "&templateType=" + defaultFile.getTemplateType() + "&sample=" + sample;
        return url;
    }

    @Override
    public String getCorrectName(String fileName, String filedir) {
        String baseName = this.fileUtility.getFileNameWithoutExtension(fileName);
        String ext = this.fileUtility.getFileExtension(fileName);
        String name = baseName + ext;
        Path path = Paths.get(this.storagePathBuilder.getFileLocation(name, filedir), new String[0]);
        int i = 1;
        while (Files.exists(path, new LinkOption[0])) {
            name = baseName + " (" + i + ")" + ext;
            path = Paths.get(this.storagePathBuilder.getFileLocation(name, filedir), new String[0]);
            ++i;
        }
        return name;
    }

    @Override
    public String getFileUri(String fileId, Boolean forDocumentServer, String filepath, String source) {
        try {
            String serverPath = this.storagePathBuilder.getServerUrl(forDocumentServer);
            String hostAddress = StringUtil.isNotEmpty((String)filepath) ? filepath : this.storagePathBuilder.getStorageLocation();
            String filePath = serverPath + "/download?fileId=" + fileId + "&source=" + source + "&userAddress" + URLEncoder.encode(hostAddress, StandardCharsets.UTF_8.toString());
            return filePath;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    @Override
    public String getHistoryFileUrl(String fileId, Integer version, String file, Boolean forDocumentServer) {
        try {
            String serverPath = this.storagePathBuilder.getServerUrl(forDocumentServer);
            String hostAddress = this.storagePathBuilder.getStorageLocation();
            String filePathDownload = !fileId.contains(InetAddress.getLocalHost().getHostAddress()) ? fileId : fileId.substring(fileId.indexOf(InetAddress.getLocalHost().getHostAddress()) + InetAddress.getLocalHost().getHostAddress().length() + 1);
            String userAddress = forDocumentServer != false ? "&userAddress" + URLEncoder.encode(hostAddress, StandardCharsets.UTF_8.toString()) : "";
            String filePath = serverPath + "/office/v1/downloadhistory?fileId=" + URLEncoder.encode(filePathDownload, StandardCharsets.UTF_8.toString()) + "&ver=" + version + "&file=" + file + userAddress;
            return filePath;
        }
        catch (UnsupportedEncodingException | UnknownHostException e) {
            return "";
        }
    }

    @Override
    public String getHistoryFileUrl(String fileId, String file, Boolean forDocumentServer) {
        try {
            String serverPath = this.storagePathBuilder.getServerUrl(forDocumentServer);
            String hostAddress = this.storagePathBuilder.getStorageLocation();
            String filePathDownload = !fileId.contains(InetAddress.getLocalHost().getHostAddress()) ? fileId : fileId.substring(fileId.indexOf(InetAddress.getLocalHost().getHostAddress()) + InetAddress.getLocalHost().getHostAddress().length() + 1);
            String userAddress = forDocumentServer != false ? "&userAddress" + URLEncoder.encode(hostAddress, StandardCharsets.UTF_8.toString()) : "";
            String filePath = serverPath + "/office/v1/downloadhistory?fileId=" + URLEncoder.encode(filePathDownload, StandardCharsets.UTF_8.toString()) + "&file=" + file + userAddress;
            return filePath;
        }
        catch (UnsupportedEncodingException | UnknownHostException e) {
            return "";
        }
    }

    @Override
    public String getCallback(String fileId, String filepath, String source) {
        String serverPath = this.storagePathBuilder.getServerUrl(true);
        String storageAddress = StringUtil.isNotEmpty((String)filepath) ? filepath : this.storagePathBuilder.getStorageLocation();
        try {
            String query = this.trackUrl + "?fileId=" + URLEncoder.encode(fileId, StandardCharsets.UTF_8.toString()) + "&source=" + URLEncoder.encode(source, StandardCharsets.UTF_8.toString()) + "&token=" + HttpUtil.getUrlToken() + "&userAddress=" + URLEncoder.encode(storageAddress, StandardCharsets.UTF_8.toString());
            return serverPath + query;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    @Override
    public String getDownloadUrl(String fileId, Boolean isServer, String filepath) {
        String serverPath = this.storagePathBuilder.getServerUrl(isServer);
        String storageAddress = StringUtil.isNotEmpty((String)filepath) ? filepath : this.storagePathBuilder.getStorageLocation();
        try {
            String userAddress = isServer != false ? "&userAddress=" + URLEncoder.encode(storageAddress, StandardCharsets.UTF_8.toString()) : "";
            String query = this.downloadUrl + "?fileId=" + URLEncoder.encode(fileId, StandardCharsets.UTF_8.toString()) + userAddress;
            return serverPath + query;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    @Override
    public String getDownloadUrl(String fileId, Boolean isServer, String filepath, String source) {
        String serverPath = this.storagePathBuilder.getServerUrl(isServer);
        String storageAddress = StringUtil.isNotEmpty((String)filepath) ? filepath : this.storagePathBuilder.getStorageLocation();
        try {
            String userAddress = isServer != false ? "&userAddress=" + URLEncoder.encode(storageAddress, StandardCharsets.UTF_8.toString()) : "";
            String query = this.downloadUrl + "?fileId=" + fileId + "&source=" + source + "&token=" + HttpUtil.getUrlToken() + userAddress;
            return serverPath + query;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    @Override
    public ArrayList<Map<String, Object>> getFilesInfo() {
        ArrayList<Map<String, Object>> files = new ArrayList<Map<String, Object>>();
        for (File file : this.storageMutator.getStoredFiles()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("version", this.storagePathBuilder.getFileVersion(file.getName(), false));
            map.put("id", this.localFileStorage.getKey(this.storagePathBuilder.getStorageLocation(), file.getName(), "", ""));
            map.put("contentLength", new BigDecimal(String.valueOf((double)file.length() / 1024.0)).setScale(2, RoundingMode.HALF_UP) + " KB");
            map.put("pureContentLength", file.length());
            map.put("title", file.getName());
            map.put("updated", String.valueOf(new Date(file.lastModified())));
            files.add(map);
        }
        return files;
    }

    @Override
    public ArrayList<Map<String, Object>> getFilesInfo(String fileId) {
        ArrayList<Map<String, Object>> file = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : this.getFilesInfo()) {
            if (!map.get("id").equals(fileId)) continue;
            file.add(map);
            break;
        }
        return file;
    }

    @Override
    public String versionDir(String path, Integer version, boolean historyPath) {
        if (!historyPath) {
            return this.storagePathBuilder.getHistoryDir(this.storagePathBuilder.getFileLocation(path)) + version;
        }
        return path + File.separator + version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String createDemo(String fileExt, String filename, String uid, String source, String filedir, String fileId) {
        String assetsFileName = "new." + fileExt;
        String demoName = (StringUtil.isNotEmpty((String)filename) ? filename + "." : "new.") + fileExt;
        String demoPath = "assets" + File.separator + "new" + File.separator + assetsFileName;
        String fileName = this.getCorrectName(demoName, filedir);
        ClassPathResource classPathResource = new ClassPathResource(demoPath);
        try (InputStream stream = classPathResource.getInputStream();){
            if (stream == null) {
                String string = null;
                return string;
            }
            String fileLocation = this.storagePathBuilder.getFileLocation(fileName, filedir);
            this.storageMutator.createFile(Paths.get(fileLocation, new String[0]), stream);
            this.storageMutator.createMeta(fileId, uid, source, fileExt, fileLocation);
            return fileName;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String createDemo(String fileId, String source, String fileExt, String account) {
        String assetsFileName = "new." + fileExt;
        String demoPath = "assets" + File.separator + "new" + File.separator + assetsFileName;
        String fileName = fileId + "." + fileExt;
        OfficeAttachment attachment = new OfficeAttachment();
        String filePath = "";
        String saveType = AppFileUtil.getSaveType((String)"");
        filePath = "aliyunOss".equals(saveType) ? AppFileUtil.getAliOssFolderPath((String)account) + fileName : AppFileUtil.createFilePath((String)account, (String)fileName);
        attachment.setId(fileId);
        attachment.setFilePath(filePath);
        attachment.setStoreType(AppFileUtil.getSaveType((String)""));
        attachment.setExt(fileExt);
        ClassPathResource classPathResource = new ClassPathResource(demoPath);
        try (InputStream stream = classPathResource.getInputStream();){
            if (stream == null) {
                String string = null;
                return string;
            }
            this.storageMutator.createFile(attachment, stream);
            this.storageMutator.createMeta2(fileId, account, source, fileExt, filePath);
            return attachment.getFilePath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

