/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.documentserver.managers.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hotent.base.util.StringUtil;
import com.hotent.office.documentserver.managers.jwt.JwtManager;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.primeframework.jwt.Signer;
import org.primeframework.jwt.Verifier;
import org.primeframework.jwt.domain.JWT;
import org.primeframework.jwt.hmac.HMACSigner;
import org.primeframework.jwt.hmac.HMACVerifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultJwtManager
implements JwtManager {
    @Value(value="${files.docservice.secret}")
    private String tokenSecret;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private JSONParser parser;

    @Override
    public String createToken(Map<String, Object> payloadClaims) {
        try {
            HMACSigner signer = HMACSigner.newSHA256Signer((String)this.tokenSecret);
            JWT jwt = new JWT();
            for (String key : payloadClaims.keySet()) {
                jwt.addClaim(key, payloadClaims.get(key));
            }
            return JWT.getEncoder().encode(jwt, (Signer)signer);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean tokenEnabled() {
        return this.tokenSecret != null && !this.tokenSecret.isEmpty();
    }

    @Override
    public JWT readToken(String token) {
        try {
            HMACVerifier verifier = HMACVerifier.newVerifier((String)this.tokenSecret);
            return JWT.getDecoder().decode(token, new Verifier[]{verifier});
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public JSONObject parseBody(String payload, String header) {
        JSONObject body;
        try {
            Object obj = this.parser.parse(payload);
            body = (JSONObject)obj;
        }
        catch (Exception ex) {
            throw new RuntimeException("{\"error\":1,\"message\":\"JSON Parsing error\"}");
        }
        if (this.tokenEnabled()) {
            String token = (String)body.get((Object)"token");
            if (token == null && header != null && !StringUtil.isEmpty((String)header)) {
                String string = token = header.startsWith("Bearer ") ? header.substring(7) : header;
            }
            if (StringUtil.isEmpty((String)token)) {
                throw new RuntimeException("{\"error\":1,\"message\":\"JWT expected\"}");
            }
            JWT jwt = this.readToken(token);
            if (jwt == null) {
                throw new RuntimeException("{\"error\":1,\"message\":\"JWT validation failed\"}");
            }
            if (jwt.getObject("payload") != null) {
                try {
                    LinkedHashMap jwtPayload = (LinkedHashMap)jwt.getObject("payload");
                    jwt.claims = jwtPayload;
                }
                catch (Exception ex) {
                    throw new RuntimeException("{\"error\":1,\"message\":\"Wrong payload\"}");
                }
            }
            try {
                Object obj = this.parser.parse(this.objectMapper.writeValueAsString((Object)jwt.claims));
                body = (JSONObject)obj;
            }
            catch (Exception ex) {
                throw new RuntimeException("{\"error\":1,\"message\":\"Parsing error\"}");
            }
        }
        return body;
    }
}

