/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.documentserver.managers.template;

import com.hotent.office.documentserver.managers.document.DocumentManager;
import com.hotent.office.documentserver.managers.template.TemplateManager;
import com.hotent.office.documentserver.models.enums.DocumentType;
import com.hotent.office.documentserver.models.filemodel.Template;
import com.hotent.office.documentserver.storage.FileStoragePathBuilder;
import com.hotent.office.documentserver.util.file.FileUtility;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="sample")
public class SampleTemplateManager
implements TemplateManager {
    @Autowired
    private DocumentManager documentManager;
    @Autowired
    private FileStoragePathBuilder storagePathBuilder;
    @Autowired
    private FileUtility fileUtility;

    @Override
    public List<Template> createTemplates(String fileName) {
        ArrayList<Template> templates = new ArrayList<Template>();
        templates.add(new Template("", "Blank", this.documentManager.getCreateUrl(fileName, (Boolean)false)));
        templates.add(new Template(this.getTemplateImageUrl(fileName), "With sample content", this.documentManager.getCreateUrl(fileName, (Boolean)true)));
        return templates;
    }

    @Override
    public String getTemplateImageUrl(String fileName) {
        DocumentType fileType = this.fileUtility.getDocumentType(fileName);
        String path = this.storagePathBuilder.getServerUrl(true);
        if (fileType.equals((Object)DocumentType.word)) {
            return path + "/css/img/file_docx.svg";
        }
        if (fileType.equals((Object)DocumentType.slide)) {
            return path + "/css/img/file_pptx.svg";
        }
        if (fileType.equals((Object)DocumentType.cell)) {
            return path + "/css/img/file_xlsx.svg";
        }
        return path + "/css/img/file_docx.svg";
    }
}

