/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.documentserver.storage;

import com.hotent.base.attachment.Attachment;
import com.hotent.base.attachment.AttachmentService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.vo.DefaultFileVo;
import com.hotent.file.util.AppFileUtil;
import com.hotent.office.documentserver.storage.FileStorageMutator;
import com.hotent.office.documentserver.storage.FileStoragePathBuilder;
import com.hotent.office.documentserver.util.FileUtil;
import com.hotent.office.documentserver.util.file.FileUtility;
import com.hotent.office.documentserver.util.service.ServiceConverter;
import com.hotent.office.manager.OfficeVersionManager;
import com.hotent.office.services.KeyServieces;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;

@Component
@Primary
public class LocalFileStorage
implements FileStorageMutator,
FileStoragePathBuilder {
    private String storageAddress;
    @Value(value="${files.storage.folder}")
    private String storageFolder;
    @Value(value="${files.docservice.url.example}")
    private String docserviceUrlExample;
    @Value(value="${files.docservice.history.postfix}")
    private String historyPostfix;
    @Value(value="${files.docservice.history.path}")
    private String historyPath;
    @Autowired
    private OfficeVersionManager officeVersionManager;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private HttpServletRequest request;
    @Resource
    private PortalFeignService portalFeignService;
    @Autowired
    private ServiceConverter serviceConverter;
    @Autowired
    private KeyServieces keyServieces;

    @Override
    public void configure(String address) {
        this.storageAddress = address;
        if (this.storageAddress == null) {
            try {
                this.storageAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                this.storageAddress = "unknown_storage";
            }
        }
        this.storageAddress.replaceAll("[^0-9a-zA-Z.=]", "_");
        this.createDirectory(Paths.get(this.getStorageLocation(), new String[0]));
    }

    @Override
    public String getStorageLocation() {
        String serverPath = System.getProperty("user.dir");
        String directory = Paths.get(this.storageAddress, new String[0]).isAbsolute() ? this.storageAddress + File.separator : serverPath + File.separator + this.storageFolder + File.separator + this.storageAddress + File.separator;
        if (!Files.exists(Paths.get(directory, new String[0]), new LinkOption[0])) {
            this.createDirectory(Paths.get(directory, new String[0]));
        }
        return directory;
    }

    @Override
    public String getFileLocation(String fileName) {
        if (fileName.contains(File.separator)) {
            return this.getStorageLocation() + fileName;
        }
        return this.getStorageLocation() + this.fileUtility.getFileName(fileName);
    }

    @Override
    public String getFileLocation(String fileName, String filepath) {
        if (fileName.contains(File.separator)) {
            return (StringUtil.isNotEmpty((String)filepath) ? filepath : this.getStorageLocation()) + File.separator + fileName;
        }
        return (StringUtil.isNotEmpty((String)filepath) ? filepath : this.getStorageLocation()) + File.separator + this.fileUtility.getFileName(fileName);
    }

    @Override
    public void createDirectory(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean createFile(Path path, InputStream stream) {
        this.createDirectory(path.getParent());
        if (Files.exists(path, new LinkOption[0])) {
            return true;
        }
        try {
            File file = Files.createFile(path, new FileAttribute[0]).toFile();
            try (FileOutputStream out = new FileOutputStream(file);){
                int read;
                byte[] bytes = new byte[1024];
                while ((read = stream.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
                out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean deleteFile(String fileName) {
        fileName = URLDecoder.decode(fileName, "UTF-8");
        if (BeanUtils.isEmpty((Object)fileName)) {
            return false;
        }
        String filenameWithoutExt = this.fileUtility.getFileNameWithoutExtension(fileName);
        Path filePath = fileName.contains(File.separator) ? Paths.get(fileName, new String[0]) : Paths.get(this.getFileLocation(fileName), new String[0]);
        Path filePathWithoutExt = fileName.contains(File.separator) ? Paths.get(filenameWithoutExt, new String[0]) : Paths.get(this.getStorageLocation() + filenameWithoutExt, new String[0]);
        boolean fileDeleted = FileSystemUtils.deleteRecursively((File)filePath.toFile());
        boolean fileWithoutExtDeleted = FileSystemUtils.deleteRecursively((File)filePathWithoutExt.toFile());
        return fileDeleted && fileWithoutExtDeleted;
    }

    @Override
    public boolean deleteFileHistory(String fileName) throws IOException {
        if (BeanUtils.isEmpty((Object)(fileName = URLDecoder.decode(fileName, "UTF-8")))) {
            return false;
        }
        Path fileHistoryPath = Paths.get(this.getStorageLocation() + this.getHistoryDirByFileId(fileName, ""), new String[0]);
        Path fileHistoryPathWithoutExt = Paths.get(this.getStorageLocation() + this.getHistoryDirByFileId(this.fileUtility.getFileNameWithoutExtension(fileName), ""), new String[0]);
        boolean historyDeleted = FileSystemUtils.deleteRecursively((File)fileHistoryPath.toFile());
        boolean historyWithoutExtDeleted = FileSystemUtils.deleteRecursively((File)fileHistoryPathWithoutExt.toFile());
        return historyDeleted || historyWithoutExtDeleted;
    }

    @Override
    public String updateFile(String fileName, byte[] bytes) {
        Path path = this.fileUtility.generateFilepath(this.getStorageLocation(), fileName);
        try {
            Files.write(path, bytes, new OpenOption[0]);
            return path.getFileName().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public boolean moveFile(Path source, Path destination) {
        try {
            Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean writeToFile(String pathName, String payload) {
        try (FileWriter fw = new FileWriter(pathName);){
            fw.write(payload);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getForcesavePath(String fileName, Boolean create) {
        String directory = this.getStorageLocation();
        Path path = Paths.get(directory, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return "";
        }
        directory = this.getFileLocation(fileName, this.historyPath) + this.historyPostfix + File.separator;
        path = Paths.get(directory, new String[0]);
        if (!create.booleanValue() && !Files.exists(path, new LinkOption[0])) {
            return "";
        }
        this.createDirectory(path);
        directory = directory + fileName;
        path = Paths.get(directory, new String[0]);
        if (!create.booleanValue() && !Files.exists(path, new LinkOption[0])) {
            return "";
        }
        return directory;
    }

    @Override
    public org.springframework.core.io.Resource loadFileAsResource(String fileName) {
        String fileLocation = this.getForcesavePath(fileName, false);
        if (BeanUtils.isEmpty((Object)fileLocation)) {
            fileLocation = this.getFileLocation(fileName);
        }
        try {
            Path filePath = Paths.get(fileLocation, new String[0]);
            UrlResource resource = new UrlResource(filePath.toUri());
            if (resource.exists()) {
                return resource;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public org.springframework.core.io.Resource loadFileAsResourceHistory(String fileId, String version, String file, String source) throws IOException {
        DefaultFileVo fileInfo = FileUtil.getFileInfo(fileId);
        String historyDir = this.getHistoryDir(fileId, fileInfo.getCreateBy(), fileInfo.getExtensionName());
        String fileLocation = historyDir + File.separator + version + File.separator + file;
        try {
            Path filePath = Paths.get(fileLocation, new String[0]);
            UrlResource resource = new UrlResource(filePath.toUri());
            if (resource.exists()) {
                return resource;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public File[] getStoredFiles() {
        File file = new File(this.getStorageLocation());
        return file.listFiles(pathname -> pathname.isFile());
    }

    @Override
    public void createMeta(String fileId, String uid, String source, String fileExt, String fileLocation) {
    }

    @Override
    public boolean createOrUpdateFile(Path path, InputStream stream) {
        if (!Files.exists(path, new LinkOption[0])) {
            return this.createFile(path, stream);
        }
        try {
            Files.write(path, LocalFileStorage.readAllBytes(stream), new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getServerUrl(Boolean forDocumentServer) {
        if (forDocumentServer.booleanValue() && !this.docserviceUrlExample.equals("")) {
            return this.docserviceUrlExample;
        }
        return this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort() + this.request.getContextPath();
    }

    @Override
    public String getHistoryDir(String path) {
        return path + this.historyPostfix;
    }

    @Override
    public String getHistoryDirByFileId(String fileId, String source) throws IOException {
        DefaultFileVo fileInfo = FileUtil.getFileInfo(fileId);
        String createBy = fileInfo.getCreateBy();
        String ext = fileInfo.getExtensionName();
        return this.historyPath + File.separator + createBy + File.separator + ext + "_" + fileId + this.historyPostfix;
    }

    @Override
    public String getHistoryDir(String fileId, String createBy, String ext) {
        return this.historyPath + File.separator + createBy + File.separator + ext + "_" + fileId + this.historyPostfix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getFileVersion(String historyPath, Boolean ifIndexPage) {
        Path path;
        if (ifIndexPage.booleanValue()) {
            path = Paths.get(this.getStorageLocation() + this.getHistoryDir(historyPath), new String[0]);
        } else {
            path = Paths.get(historyPath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return 1;
            }
        }
        try (Stream<Path> stream = Files.walk(path, 1, new FileVisitOption[0]);){
            int n = stream.filter(file -> Files.isDirectory(file, new LinkOption[0])).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet()).size();
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int bufLen = 1024;
        byte[] buf = new byte[1024];
        IOException exception = null;
        try {
            int readLen;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((readLen = inputStream.read(buf, 0, 1024)) != -1) {
                outputStream.write(buf, 0, readLen);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            exception = e;
            throw e;
        }
        finally {
            if (exception == null) {
                inputStream.close();
            } else {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    exception.addSuppressed(e);
                }
            }
        }
    }

    public String getKey(String dir, String filename, String fileId, String key) {
        long modified = new File(this.getFileLocation(filename, dir)).lastModified();
        String message = (StringUtil.isNotEmpty((String)dir) ? dir : this.getStorageLocation()) + "/" + key + "//" + filename + "/" + new File(this.getFileLocation(filename, dir)).lastModified();
        return this.serviceConverter.generateRevisionId(message);
    }

    @Override
    public void createFile(Attachment attachment, InputStream stream) {
        AttachmentService attachmentService = AppFileUtil.getAttachmentService((String)AppFileUtil.getSaveType((String)""));
        attachmentService.upload(attachment, stream, "");
    }

    @Override
    public void removeFile(Attachment attachment, InputStream stream) {
        AttachmentService attachmentService = AppFileUtil.getAttachmentService((String)attachment.getStoreType());
        attachmentService.remove(attachment, "");
    }

    @Override
    public void updateFile(Attachment newFile, Attachment oldFile, InputStream stream) {
        AttachmentService sourceAttachmentService = AppFileUtil.getAttachmentService((String)oldFile.getStoreType());
        AttachmentService targetAttachmentService = AppFileUtil.getAttachmentService((String)newFile.getStoreType());
        sourceAttachmentService.remove(oldFile, "");
        targetAttachmentService.upload(newFile, stream, "");
    }

    @Override
    public void createMeta2(String fileId, String account, String source, String fileExt, String filePath) {
    }

    @Override
    public void download(Attachment attachment, OutputStream outputStream) {
        AttachmentService attachmentService = AppFileUtil.getAttachmentService((String)attachment.getStoreType());
        attachmentService.download(attachment, outputStream, "");
    }

    public String getStorageAddress() {
        return this.storageAddress;
    }
}

