/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.documentserver.util.file;

import com.hotent.office.documentserver.models.enums.DocumentType;
import com.hotent.office.documentserver.util.file.FileUtility;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="default")
public class DefaultFileUtility
implements FileUtility {
    @Value(value="${filesize-max}")
    private String filesizeMax;
    @Value(value="${files.docservice.viewed-docs}")
    private String docserviceViewedDocs;
    @Value(value="${files.docservice.edited-docs}")
    private String docserviceEditedDocs;
    @Value(value="${files.docservice.convert-docs}")
    private String docserviceConvertDocs;
    @Value(value="${files.docservice.fillforms-docs}")
    private String docserviceFillDocs;
    private List<String> ExtsDocument = Arrays.asList(".doc", ".docx", ".docm", ".dot", ".dotx", ".dotm", ".odt", ".fodt", ".ott", ".rtf", ".txt", ".html", ".htm", ".mht", ".xml", ".pdf", ".djvu", ".fb2", ".epub", ".xps", ".oform");
    private List<String> ExtsSpreadsheet = Arrays.asList(".xls", ".xlsx", ".xlsm", ".xlsb", ".xlt", ".xltx", ".xltm", ".ods", ".fods", ".ots", ".csv");
    private List<String> ExtsPresentation = Arrays.asList(".pps", ".ppsx", ".ppsm", ".ppt", ".pptx", ".pptm", ".pot", ".potx", ".potm", ".odp", ".fodp", ".otp");

    @Override
    public DocumentType getDocumentType(String fileName) {
        String ext = this.getFileExtension(fileName).toLowerCase();
        if (this.ExtsDocument.contains(ext)) {
            return DocumentType.word;
        }
        if (this.ExtsSpreadsheet.contains(ext)) {
            return DocumentType.cell;
        }
        if (this.ExtsPresentation.contains(ext)) {
            return DocumentType.slide;
        }
        return DocumentType.word;
    }

    @Override
    public String getFileName(String url) {
        if (url == null) {
            return "";
        }
        String fileName = url.substring(url.lastIndexOf(47) + 1);
        fileName = fileName.split("\\?")[0];
        return fileName;
    }

    @Override
    public String getFileNameWithoutExtension(String url) {
        String fileName = this.getFileName(url);
        if (fileName == null) {
            return null;
        }
        String fileNameWithoutExt = fileName.substring(0, fileName.lastIndexOf(46));
        return fileNameWithoutExt;
    }

    @Override
    public String getFileExtension(String url) {
        String fileName = this.getFileName(url);
        if (fileName == null) {
            return null;
        }
        String fileExt = fileName.substring(fileName.lastIndexOf("."));
        return fileExt.toLowerCase();
    }

    @Override
    public String getInternalExtension(DocumentType type) {
        if (type.equals((Object)DocumentType.word)) {
            return ".docx";
        }
        if (type.equals((Object)DocumentType.cell)) {
            return ".xlsx";
        }
        if (type.equals((Object)DocumentType.slide)) {
            return ".pptx";
        }
        return ".docx";
    }

    @Override
    public List<String> getFillExts() {
        return Arrays.asList(this.docserviceFillDocs.split("\\|"));
    }

    @Override
    public List<String> getViewedExts() {
        return Arrays.asList(this.docserviceViewedDocs.split("\\|"));
    }

    @Override
    public List<String> getEditedExts() {
        return Arrays.asList(this.docserviceEditedDocs.split("\\|"));
    }

    @Override
    public List<String> getConvertExts() {
        return Arrays.asList(this.docserviceConvertDocs.split("\\|"));
    }

    @Override
    public List<String> getFileExts() {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(this.getViewedExts());
        res.addAll(this.getEditedExts());
        res.addAll(this.getConvertExts());
        res.addAll(this.getFillExts());
        return res;
    }

    @Override
    public Path generateFilepath(String directory, String fullFileName) {
        String fileName = this.getFileNameWithoutExtension(fullFileName);
        String fileExtension = this.getFileExtension(fullFileName);
        Path path = Paths.get(directory + fullFileName, new String[0]);
        int i = 1;
        while (Files.exists(path, new LinkOption[0])) {
            fileName = this.getFileNameWithoutExtension(fullFileName) + "(" + i + ")";
            path = Paths.get(directory + fileName + fileExtension, new String[0]);
            ++i;
        }
        path = Paths.get(directory + fileName + fileExtension, new String[0]);
        return path;
    }

    @Override
    public long getMaxFileSize() {
        long size = Long.parseLong(this.filesizeMax);
        return size > 0L ? size : 0x500000L;
    }
}

