/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.documentserver.util.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hotent.base.util.StringUtil;
import com.hotent.office.documentserver.managers.jwt.JwtManager;
import com.hotent.office.documentserver.util.file.FileUtility;
import com.hotent.office.documentserver.util.service.ServiceConverter;
import com.hotent.office.dto.Convert;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultServiceConverter
implements ServiceConverter {
    @Value(value="${files.docservice.header}")
    private String documentJwtHeader;
    @Value(value="${files.docservice.url.site}")
    private String docServiceUrl;
    @Value(value="${files.docservice.url.converter}")
    private String docServiceUrlConverter;
    @Value(value="${files.docservice.timeout}")
    private String docserviceTimeout;
    private int convertTimeout = 120000;
    @Autowired
    private JwtManager jwtManager;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private JSONParser parser;
    @Autowired
    private ObjectMapper objectMapper;

    @PostConstruct
    public void init() {
        int timeout = Integer.parseInt(this.docserviceTimeout);
        if (timeout > 0) {
            this.convertTimeout = timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postToServer(Convert body, String headerToken) {
        String bodyString = this.objectMapper.writeValueAsString((Object)body);
        URL url = null;
        HttpURLConnection connection = null;
        InputStream response = null;
        String jsonString = null;
        byte[] bodyByte = bodyString.getBytes(StandardCharsets.UTF_8);
        try {
            url = new URL(this.docServiceUrl + this.docServiceUrlConverter);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setFixedLengthStreamingMode(bodyByte.length);
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(this.convertTimeout);
            if (this.jwtManager.tokenEnabled()) {
                connection.setRequestProperty(StringUtil.isEmpty((String)this.documentJwtHeader) ? "Authorization" : this.documentJwtHeader, "Bearer " + headerToken);
            }
            connection.connect();
            try (OutputStream os = connection.getOutputStream();){
                os.write(bodyByte);
                os.flush();
            }
            response = connection.getInputStream();
            jsonString = this.convertStreamToString(response);
            return jsonString;
        }
        finally {
            connection.disconnect();
            return jsonString;
        }
    }

    @Override
    public String getConvertedUri(String documentUri, String fromExtension, String toExtension, String documentRevisionId, String filePass, Boolean isAsync, String lang) {
        fromExtension = fromExtension == null || fromExtension.isEmpty() ? this.fileUtility.getFileExtension(documentUri) : fromExtension;
        String title = this.fileUtility.getFileName(documentUri);
        title = title == null || title.isEmpty() ? UUID.randomUUID().toString() : title;
        documentRevisionId = documentRevisionId == null || documentRevisionId.isEmpty() ? documentUri : documentRevisionId;
        documentRevisionId = this.generateRevisionId(documentRevisionId);
        Convert body = new Convert();
        body.setLang(lang);
        body.setUrl(documentUri);
        body.setOutputtype(toExtension.replace(".", ""));
        body.setFiletype(fromExtension.replace(".", ""));
        body.setTitle(title);
        body.setKey(documentRevisionId);
        body.setFilePass(filePass);
        if (isAsync.booleanValue()) {
            body.setAsync(true);
        }
        String headerToken = "";
        if (this.jwtManager.tokenEnabled()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("region", lang);
            map.put("url", body.getUrl());
            map.put("outputtype", body.getOutputtype());
            map.put("filetype", body.getFiletype());
            map.put("title", body.getTitle());
            map.put("key", body.getKey());
            map.put("password", body.getFilePass());
            if (isAsync.booleanValue()) {
                map.put("async", body.getAsync());
            }
            String token = this.jwtManager.createToken(map);
            body.setToken(token);
            HashMap<String, Object> payloadMap = new HashMap<String, Object>();
            payloadMap.put("payload", map);
            headerToken = this.jwtManager.createToken(payloadMap);
        }
        String jsonString = this.postToServer(body, headerToken);
        return this.getResponseUri(jsonString);
    }

    @Override
    public String generateRevisionId(String expectedKey) {
        if (expectedKey.length() > 20) {
            expectedKey = Integer.toString(expectedKey.hashCode());
        }
        String key = expectedKey.replace("[^0-9-.a-zA-Z_=]", "_");
        return key.substring(0, Math.min(key.length(), 20));
    }

    private void processConvertServiceResponceError(int errorCode) {
        String errorMessage = "";
        String errorMessageTemplate = "Error occurred in the ConvertService: ";
        switch (errorCode) {
            case -8: {
                errorMessage = errorMessageTemplate + "Error document VKey";
                break;
            }
            case -7: {
                errorMessage = errorMessageTemplate + "Error document request";
                break;
            }
            case -6: {
                errorMessage = errorMessageTemplate + "Error database";
                break;
            }
            case -5: {
                errorMessage = errorMessageTemplate + "Error unexpected guid";
                break;
            }
            case -4: {
                errorMessage = errorMessageTemplate + "Error download error";
                break;
            }
            case -3: {
                errorMessage = errorMessageTemplate + "Error convertation error";
                break;
            }
            case -2: {
                errorMessage = errorMessageTemplate + "Error convertation timeout";
                break;
            }
            case -1: {
                errorMessage = errorMessageTemplate + "Error convertation unknown";
                break;
            }
            case 0: {
                break;
            }
            default: {
                errorMessage = "ErrorCode = " + errorCode;
            }
        }
        throw new RuntimeException(errorMessage);
    }

    private String getResponseUri(String jsonString) {
        JSONObject jsonObj = this.convertStringToJSON(jsonString);
        Object error = jsonObj.get((Object)"error");
        if (error != null) {
            this.processConvertServiceResponceError(Math.toIntExact((Long)error));
        }
        Boolean isEndConvert = (Boolean)jsonObj.get((Object)"endConvert");
        Long resultPercent = 0L;
        String responseUri = null;
        if (isEndConvert.booleanValue()) {
            resultPercent = 100L;
            responseUri = (String)jsonObj.get((Object)"fileUrl");
        } else {
            resultPercent = (Long)jsonObj.get((Object)"percent");
            resultPercent = resultPercent >= 100L ? 99L : resultPercent;
        }
        return resultPercent >= 100L ? responseUri : "";
    }

    @Override
    public String convertStreamToString(InputStream stream) {
        InputStreamReader inputStreamReader = new InputStreamReader(stream);
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String line = bufferedReader.readLine();
        while (line != null) {
            stringBuilder.append(line);
            line = bufferedReader.readLine();
        }
        String result = stringBuilder.toString();
        return result;
    }

    @Override
    public JSONObject convertStringToJSON(String jsonString) {
        Object obj = this.parser.parse(jsonString);
        JSONObject jsonObj = (JSONObject)obj;
        return jsonObj;
    }
}

