/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.manager.impl;

import cn.hutool.core.lang.Assert;
import cn.keking.config.ConfigConstants;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.vo.DefaultFileVo;
import com.hotent.office.OfficeConfig;
import com.hotent.office.documentserver.managers.history.HistoryManager;
import com.hotent.office.documentserver.models.enums.Action;
import com.hotent.office.documentserver.models.enums.Type;
import com.hotent.office.documentserver.models.filemodel.FileModel;
import com.hotent.office.documentserver.util.FileUtil;
import com.hotent.office.entities.User;
import com.hotent.office.manager.OfficeManager;
import com.hotent.office.manager.OfficeVersionManager;
import com.hotent.office.model.DefaultFile;
import com.hotent.office.model.OfficeVersion;
import com.hotent.office.services.UserServices;
import com.hotent.office.services.configurers.FileConfigurer;
import com.hotent.office.services.configurers.wrappers.DefaultFileWrapper;
import com.hotent.office.util.OfficeUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
public class OfficeManagerImpl
implements OfficeManager {
    @Resource
    private UserServices userService;
    @Resource
    OfficeVersionManager officeVersionManager;
    @Resource
    private HistoryManager historyManager;
    @Resource
    private FileConfigurer<DefaultFileWrapper> fileConfigurer;
    @Resource
    OfficeConfig officeConfig;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String editor(String fileId, String actionParam, String typeParam, String actionLink, String token, String filePath, String source, Model model) throws IOException {
        Action action = Action.edit;
        Type type = Type.desktop;
        IUser currentUser = ContextUtil.getCurrentUser();
        String uid = currentUser.getUserId();
        Locale locale = LocaleContextHolder.getLocale();
        if (actionParam != null) {
            action = Action.valueOf(actionParam);
        }
        if (typeParam != null) {
            type = Type.valueOf(typeParam);
        }
        User user = this.userService.createUser(uid, currentUser.getFullname(), currentUser.getEmail());
        DefaultFileVo fileInfo = FileUtil.getFileInfo(fileId);
        Assert.notNull((Object)fileInfo, (String)"\u672a\u627e\u5230\u6587\u4ef6", (Object[])new Object[0]);
        OfficeVersion officeVersion = (OfficeVersion)((Object)this.officeVersionManager.getOne((Wrapper)Wrappers.lambdaQuery().eq(OfficeVersion::getFileId, (Object)fileInfo.getId()), false));
        if (officeVersion == null) {
            officeVersion = new OfficeVersion(fileId, 1);
            this.officeVersionManager.save((Object)officeVersion);
        }
        DefaultFile defaultFile = DefaultFile.builder().id(fileId).createBy(fileInfo.getCreateBy()).createtor(fileInfo.getCreatorName()).fileExt(fileInfo.getExtensionName()).ownerId(fileInfo.getCreateBy()).ownerName(fileInfo.getCreatorName()).createBy(fileInfo.getCreateBy()).createtor(fileInfo.getCreatorName()).filename(fileInfo.getFileName()).source("").version(officeVersion.getVersion()).build();
        String fileName = fileInfo.getFileName() + "." + fileInfo.getExtensionName();
        FileModel fileModel = this.fileConfigurer.getFileModel(DefaultFileWrapper.builder().type(type).lang(locale.toLanguageTag()).action(action).user(user).fileName(fileName).fileId(fileId).defaultFile(defaultFile).key(officeVersion.getKey()).build());
        model.addAttribute("model", (Object)fileModel);
        model.addAttribute("modelJsonStr", (Object)JsonUtil.toJsonString((Object)fileModel));
        String[] history = this.historyManager.getHistoryFromDb(fileModel.getDocument());
        model.addAttribute("histObj", (Object)"{}");
        model.addAttribute("histData", (Object)"[]");
        if (BeanUtils.isNotEmpty((Object)ConfigConstants.getBaseUrl()) && !"default".equals(ConfigConstants.getBaseUrl())) {
            model.addAttribute("baseUrl", (Object)ConfigConstants.getBaseUrl());
        } else {
            model.addAttribute("baseUrl", (Object)"");
        }
        model.addAttribute("docserviceApiUrl", (Object)(this.officeConfig.getDocserviceSite() + this.officeConfig.getDocserviceApiUrl()));
        model.addAttribute("dataInsertImage", (Object)OfficeUtil.getInsertImage());
        model.addAttribute("dataCompareFile", (Object)OfficeUtil.getCompareFile());
        model.addAttribute("dataMailMergeRecipients", (Object)OfficeUtil.getMailMerge());
        model.addAttribute("token", (Object)token);
        return "editor";
    }
}

