/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.mappers;

import com.hotent.office.documentserver.models.AbstractModel;
import com.hotent.office.entities.AbstractEntity;
import com.hotent.office.mappers.Mapper;
import java.util.Objects;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMapper<E extends AbstractEntity, M extends AbstractModel>
implements Mapper<E, M> {
    @Autowired
    ModelMapper mapper;
    private Class<M> modelClass;

    AbstractMapper(Class<M> modelClass) {
        this.modelClass = modelClass;
    }

    @Override
    public M toModel(E entity) {
        return (M)(Objects.isNull(entity) ? null : (AbstractModel)this.mapper.map(entity, this.modelClass));
    }

    Converter<E, M> modelConverter() {
        return context -> {
            AbstractEntity source = (AbstractEntity)context.getSource();
            AbstractModel destination = (AbstractModel)context.getDestination();
            this.handleSpecificFields(source, destination);
            return (AbstractModel)context.getDestination();
        };
    }

    void handleSpecificFields(E source, M destination) {
    }
}

