/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.services;

import com.hotent.office.documentserver.serializers.FilterState;
import com.hotent.office.entities.Group;
import com.hotent.office.entities.Permission;
import com.hotent.office.entities.User;
import com.hotent.office.services.GroupServices;
import com.hotent.office.services.PermissionServices;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServices {
    private static List<User> users = new ArrayList<User>();
    static AtomicInteger id = new AtomicInteger(1);
    @Autowired
    GroupServices groupServices;
    @Autowired
    PermissionServices permissionService;

    public List<User> findAll() {
        return users;
    }

    public Optional<User> findUserById(String id) {
        return users.stream().filter(user -> user.getId().equals(id)).findFirst();
    }

    public User createUser(String uid, String name, String email, List<String> description, String group, List<String> reviewGroups, List<String> viewGroups, List<String> editGroups, List<String> removeGroups, List<String> userInfoGroups, Boolean favoriteDoc, Boolean chat) {
        User newUser = new User();
        newUser.setId(uid);
        newUser.setName(name);
        newUser.setEmail(email);
        newUser.setDescriptions(description);
        newUser.setFavorite(favoriteDoc);
        List<Group> groupsReview = this.groupServices.createGroups(reviewGroups);
        List<Group> commentGroupsView = this.groupServices.createGroups(viewGroups);
        List<Group> commentGroupsEdit = this.groupServices.createGroups(editGroups);
        List<Group> commentGroupsRemove = this.groupServices.createGroups(removeGroups);
        List<Group> usInfoGroups = this.groupServices.createGroups(userInfoGroups);
        Permission permission = this.permissionService.createPermission(groupsReview, commentGroupsView, commentGroupsEdit, commentGroupsRemove, usInfoGroups, chat);
        newUser.setPermissions(permission);
        users.add(newUser);
        return newUser;
    }

    public User createUser(String uid, String name, String email) {
        ArrayList<String> description_user_1 = new ArrayList<String>();
        ArrayList<String> nullState = new ArrayList<String>();
        nullState.add(FilterState.NULL.toString());
        UserServices userServices = new UserServices();
        return this.createUser(uid, name, email, description_user_1, "", nullState, nullState, nullState, nullState, nullState, null, true);
    }
}

