/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.services.configurers.implementations;

import com.hotent.office.documentserver.managers.document.DocumentManager;
import com.hotent.office.documentserver.models.filemodel.Document;
import com.hotent.office.documentserver.models.filemodel.Permission;
import com.hotent.office.documentserver.storage.LocalFileStorage;
import com.hotent.office.documentserver.util.file.FileUtility;
import com.hotent.office.services.KeyServieces;
import com.hotent.office.services.configurers.DocumentConfigurer;
import com.hotent.office.services.configurers.wrappers.DefaultDocumentWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class DefaultDocumentConfigurer
implements DocumentConfigurer<DefaultDocumentWrapper> {
    @Autowired
    private DocumentManager documentManager;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private LocalFileStorage localFileStorage;
    @Autowired
    private KeyServieces keyServieces;

    @Override
    public void configure(Document document, DefaultDocumentWrapper wrapper) {
        String fileName = wrapper.getFileName();
        Permission permission = wrapper.getPermission();
        document.setTitle(fileName);
        document.setUrl(this.documentManager.getDownloadUrl(wrapper.getFileId(), true, wrapper.getFiledir(), wrapper.getDefaultFile().getSource()));
        document.setUrlUser(this.documentManager.getFileUri(wrapper.getFileId(), false, wrapper.getFiledir(), wrapper.getDefaultFile().getSource()));
        document.setDirectUrl(this.documentManager.getDownloadUrl(wrapper.getFileId(), false, wrapper.getFiledir(), wrapper.getDefaultFile().getSource()));
        document.setFileType(this.fileUtility.getFileExtension(fileName).replace(".", ""));
        document.getInfo().setFavorite(wrapper.getFavorite());
        String key = this.localFileStorage.getKey(wrapper.getFiledir(), fileName, wrapper.getFileId(), wrapper.getDefaultFile().getSource());
        document.setKey(wrapper.getFileId() + "-" + wrapper.getDefaultFile().getVersion());
        document.setPermissions(permission);
        document.setFileId(wrapper.getFileId());
        document.setSource(wrapper.getDefaultFile().getSource());
        document.setVersion(wrapper.getDefaultFile().getVersion());
    }
}

