/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.services.configurers.implementations;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.reflect.TypeToken;
import com.hotent.office.documentserver.managers.document.DocumentManager;
import com.hotent.office.documentserver.managers.template.TemplateManager;
import com.hotent.office.documentserver.models.enums.Action;
import com.hotent.office.documentserver.models.enums.Mode;
import com.hotent.office.documentserver.models.filemodel.EditorConfig;
import com.hotent.office.documentserver.models.filemodel.User;
import com.hotent.office.documentserver.util.file.FileUtility;
import com.hotent.office.mappers.Mapper;
import com.hotent.office.services.configurers.EditorConfigConfigurer;
import com.hotent.office.services.configurers.implementations.DefaultCustomizationConfigurer;
import com.hotent.office.services.configurers.implementations.DefaultEmbeddedConfigurer;
import com.hotent.office.services.configurers.wrappers.DefaultCustomizationWrapper;
import com.hotent.office.services.configurers.wrappers.DefaultEmbeddedWrapper;
import com.hotent.office.services.configurers.wrappers.DefaultFileWrapper;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class DefaultEditorConfigConfigurer
implements EditorConfigConfigurer<DefaultFileWrapper> {
    @Autowired
    private Mapper<com.hotent.office.entities.User, User> mapper;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private DocumentManager documentManager;
    @Autowired
    @Qualifier(value="sample")
    private TemplateManager templateManager;
    @Autowired
    private DefaultCustomizationConfigurer defaultCustomizationConfigurer;
    @Autowired
    private DefaultEmbeddedConfigurer defaultEmbeddedConfigurer;
    @Autowired
    private FileUtility fileUtility;

    @Override
    public void configure(EditorConfig config, DefaultFileWrapper wrapper) {
        if (wrapper.getActionData() != null) {
            config.setActionLink((HashMap)this.objectMapper.readValue(wrapper.getActionData(), (JavaType)new TypeToken<HashMap<String, Object>>(){}.getType()));
        }
        String fileName = wrapper.getFileName();
        boolean userIsAnon = wrapper.getUser().getName().equals("Anonymous");
        config.setTemplates(userIsAnon ? null : this.templateManager.createTemplates(fileName));
        config.setCallbackUrl(this.documentManager.getCallback(wrapper.getFileId(), wrapper.getFiledir(), wrapper.getDefaultFile().getSource()));
        config.setCreateUrl(userIsAnon ? null : this.documentManager.getCreateUrl(wrapper.getDefaultFile(), (Boolean)false));
        config.setLang(wrapper.getLang());
        Boolean canEdit = wrapper.getCanEdit();
        Action action = wrapper.getAction();
        config.setCoEditing(action.equals((Object)Action.view) && userIsAnon ? new HashMap<String, Object>(){
            {
                this.put("mode", "strict");
                this.put("change", false);
            }
        } : null);
        this.defaultCustomizationConfigurer.configure(config.getCustomization(), DefaultCustomizationWrapper.builder().action(action).user(userIsAnon ? null : wrapper.getUser()).build());
        config.setMode(canEdit != false && !action.equals((Object)Action.view) ? Mode.edit : Mode.view);
        config.setUser(this.mapper.toModel(wrapper.getUser()));
        this.defaultEmbeddedConfigurer.configure(config.getEmbedded(), DefaultEmbeddedWrapper.builder().type(wrapper.getType()).fileName(fileName).filedir(wrapper.getFiledir()).build());
    }
}

