/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.services.configurers.implementations;

import com.hotent.office.documentserver.managers.jwt.JwtManager;
import com.hotent.office.documentserver.models.enums.Action;
import com.hotent.office.documentserver.models.enums.DocumentType;
import com.hotent.office.documentserver.models.filemodel.FileModel;
import com.hotent.office.documentserver.models.filemodel.Permission;
import com.hotent.office.documentserver.util.file.FileUtility;
import com.hotent.office.mappers.Mapper;
import com.hotent.office.services.configurers.FileConfigurer;
import com.hotent.office.services.configurers.implementations.DefaultDocumentConfigurer;
import com.hotent.office.services.configurers.implementations.DefaultEditorConfigConfigurer;
import com.hotent.office.services.configurers.wrappers.DefaultDocumentWrapper;
import com.hotent.office.services.configurers.wrappers.DefaultFileWrapper;
import java.util.HashMap;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class DefaultFileConfigurer
implements FileConfigurer<DefaultFileWrapper> {
    @Autowired
    private ObjectFactory<FileModel> fileModelObjectFactory;
    @Autowired
    private FileUtility fileUtility;
    @Autowired
    private JwtManager jwtManager;
    @Autowired
    private Mapper<com.hotent.office.entities.Permission, Permission> mapper;
    @Autowired
    private DefaultDocumentConfigurer defaultDocumentConfigurer;
    @Autowired
    private DefaultEditorConfigConfigurer defaultEditorConfigConfigurer;

    @Override
    public void configure(FileModel fileModel, DefaultFileWrapper wrapper) {
        if (fileModel != null) {
            String fileName = wrapper.getFileName();
            Action action = wrapper.getAction();
            DocumentType documentType = this.fileUtility.getDocumentType(fileName);
            fileModel.setDocumentType(documentType);
            fileModel.setType(wrapper.getType());
            Permission userPermissions = this.mapper.toModel(wrapper.getUser().getPermissions());
            String fileExt = this.fileUtility.getFileExtension(wrapper.getFileName());
            Boolean canEdit = this.fileUtility.getEditedExts().contains(fileExt);
            if ((!canEdit.booleanValue() && action.equals((Object)Action.edit) || action.equals((Object)Action.fillForms)) && this.fileUtility.getFillExts().contains(fileExt)) {
                canEdit = true;
                wrapper.setAction(Action.fillForms);
            }
            wrapper.setCanEdit(canEdit);
            DefaultDocumentWrapper documentWrapper = DefaultDocumentWrapper.builder().fileName(fileName).fileId(wrapper.getFileId()).permission(this.updatePermissions(userPermissions, action, canEdit)).favorite(wrapper.getUser().getFavorite()).filedir(wrapper.getFiledir()).defaultFile(wrapper.getDefaultFile()).build();
            this.defaultDocumentConfigurer.configure(fileModel.getDocument(), documentWrapper);
            this.defaultEditorConfigConfigurer.configure(fileModel.getEditorConfig(), wrapper);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", (Object)fileModel.getType());
            map.put("documentType", (Object)documentType);
            map.put("document", fileModel.getDocument());
            map.put("editorConfig", fileModel.getEditorConfig());
            fileModel.setToken(this.jwtManager.createToken(map));
        }
    }

    @Override
    public FileModel getFileModel(DefaultFileWrapper wrapper) {
        FileModel fileModel = (FileModel)this.fileModelObjectFactory.getObject();
        this.configure(fileModel, wrapper);
        return fileModel;
    }

    private Permission updatePermissions(Permission userPermissions, Action action, Boolean canEdit) {
        userPermissions.setComment(!action.equals((Object)Action.view) && !action.equals((Object)Action.fillForms) && !action.equals((Object)Action.embedded) && !action.equals((Object)Action.blockcontent));
        userPermissions.setFillForms(!action.equals((Object)Action.view) && !action.equals((Object)Action.comment) && !action.equals((Object)Action.embedded) && !action.equals((Object)Action.blockcontent));
        userPermissions.setReview(canEdit != false && (action.equals((Object)Action.review) || action.equals((Object)Action.edit)));
        userPermissions.setEdit(canEdit != false && (action.equals((Object)Action.view) || action.equals((Object)Action.edit) || action.equals((Object)Action.filter) || action.equals((Object)Action.blockcontent)));
        return userPermissions;
    }
}

