/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.office.services.configurers.wrappers;

import com.hotent.office.documentserver.models.filemodel.Permission;
import com.hotent.office.model.DefaultFile;

public class DefaultDocumentWrapper {
    private Permission permission;
    private String fileName;
    private Boolean favorite;
    private String filedir;
    private String fileId;
    private DefaultFile defaultFile;

    DefaultDocumentWrapper(Permission permission, String fileName, Boolean favorite, String filedir, String fileId, DefaultFile defaultFile) {
        this.permission = permission;
        this.fileName = fileName;
        this.favorite = favorite;
        this.filedir = filedir;
        this.fileId = fileId;
        this.defaultFile = defaultFile;
    }

    public static DefaultDocumentWrapperBuilder builder() {
        return new DefaultDocumentWrapperBuilder();
    }

    public Permission getPermission() {
        return this.permission;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Boolean getFavorite() {
        return this.favorite;
    }

    public String getFiledir() {
        return this.filedir;
    }

    public String getFileId() {
        return this.fileId;
    }

    public DefaultFile getDefaultFile() {
        return this.defaultFile;
    }

    public static class DefaultDocumentWrapperBuilder {
        private Permission permission;
        private String fileName;
        private Boolean favorite;
        private String filedir;
        private String fileId;
        private DefaultFile defaultFile;

        DefaultDocumentWrapperBuilder() {
        }

        public DefaultDocumentWrapperBuilder permission(Permission permission) {
            this.permission = permission;
            return this;
        }

        public DefaultDocumentWrapperBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public DefaultDocumentWrapperBuilder favorite(Boolean favorite) {
            this.favorite = favorite;
            return this;
        }

        public DefaultDocumentWrapperBuilder filedir(String filedir) {
            this.filedir = filedir;
            return this;
        }

        public DefaultDocumentWrapperBuilder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public DefaultDocumentWrapperBuilder defaultFile(DefaultFile defaultFile) {
            this.defaultFile = defaultFile;
            return this;
        }

        public DefaultDocumentWrapper build() {
            return new DefaultDocumentWrapper(this.permission, this.fileName, this.favorite, this.filedir, this.fileId, this.defaultFile);
        }

        public String toString() {
            return "DefaultDocumentWrapper.DefaultDocumentWrapperBuilder(permission=" + this.permission + ", fileName=" + this.fileName + ", favorite=" + this.favorite + ", filedir=" + this.filedir + ", fileId=" + this.fileId + ", defaultFile=" + this.defaultFile + ")";
        }
    }
}

