<!DOCTYPE html>

<html lang="zh">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport"
          content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no, minimal-ui"/>
    <meta name="apple-mobile-web-app-capable" content="yes"/>
    <meta name="mobile-web-app-capable" content="yes"/>
    <!--
    *
    * (c) Copyright Ascensio System SIA 2020
    *
    * Licensed under the Apache License, Version 2.0 (the "License");
    * you may not use this file except in compliance with the License.
    * You may obtain a copy of the License at
    *
    *     http://www.apache.org/licenses/LICENSE-2.0
    *
    * Unless required by applicable law or agreed to in writing, software
    * distributed under the License is distributed on an "AS IS" BASIS,
    * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    * See the License for the specific language governing permissions and
    * limitations under the License.
    *
    -->
    <title>ONLYOFFICE</title>
    <link rel="icon" href="/css/img/${model.getDocumentType()}.ico" type="image/x-icon"/>
    <link rel="stylesheet" type="text/css" href="${baseUrl}/css/editor.css"/>

    <script type="text/javascript" src="${docserviceApiUrl}"></script>

    <script inline="javascript">
        var docEditor;
        var config;
        var token = "${token}";

        var innerAlert = function (message, inEditor) {
            if (console && console.log)
                console.log(message);
            if (inEditor && docEditor)
                docEditor.showMessage(message);
        };

        // the application is loaded into the browser
        var onAppReady = function () {
            innerAlert("Document editor ready");
        };

        // the document is modified
        var onDocumentStateChange = function (event) {
            var title = document.title.replace(/\*$/g, "");
            document.title = title + (event.data ? "*" : "");
        };

        // the user is trying to switch the document from the viewing into the editing mode
        var onRequestEditRights = function () {
            innerAlert("onRequestEditRights ready");
            let targetUrl=location.href
            targetUrl=targetUrl.replace(RegExp("\&?action=view\&?", "i"), "");
            let postParam={
                token:token,
                action:'edit'
            }
            jumpPost(targetUrl,postParam)
            // location.href = targetUrl
        };

        // an error or some other specific event occurs
        var onError = function (event) {
            if (event) innerAlert(event.data);
        };

        // the document is opened for editing with the old document.key value
        var onOutdatedVersion = function (event) {
            innerAlert("onOutdatedVersion ready");
            location.reload(true);
        };

        // replace the link to the document which contains a bookmark
        var replaceActionLink = function (href, linkParam) {
            var link;
            var actionIndex = href.indexOf("&actionLink=");
            if (actionIndex != -1) {
                var endIndex = href.indexOf("&", actionIndex + "&actionLink=".length);
                if (endIndex != -1) {
                    link = href.substring(0, actionIndex) + href.substring(endIndex) + "&actionLink=" + encodeURIComponent(linkParam);
                } else {
                    link = href.substring(0, actionIndex) + "&actionLink=" + encodeURIComponent(linkParam);
                }
            } else {
                link = href + "&actionLink=" + encodeURIComponent(linkParam);
            }
            return link;
        }

        // the user is trying to get link for opening the document which contains a bookmark, scrolling to the bookmark position
        var onMakeActionLink = function (event) {
            innerAlert("onMakeActionLink ready");
            var actionData = event.data;
            var linkParam = JSON.stringify(actionData);
            docEditor.setActionLink(replaceActionLink(location.href, linkParam));
        };

        // the meta information of the document is changed via the meta command
        var onMetaChange = function (event) {
            if (event.data.favorite) {
                var favorite = !!event.data.favorite;
                var title = document.title.replace(/^\☆/g, "");
                document.title = (favorite ? "☆" : "") + title;
                docEditor.setFavorite(favorite);
            }
            innerAlert("onMetaChange: " + JSON.stringify(event.data));
        };


        var dataInsertImage = {${dataInsertImage}};

        // the user is trying to insert an image by clicking the Image from Storage button
        var onRequestInsertImage = function (event) {
            innerAlert("onRequestInsertImage ready");
            const temp = Object.assign({}, {"c": event.data.c}, dataInsertImage);
            docEditor.insertImage(temp);
        };

        // the user is trying to select document for comparing by clicking the Document from Storage button
        var onRequestCompareFile = function () {
            innerAlert("onRequestCompareFile ready");
            docEditor.setRevisedFile(${dataCompareFile});
        };

        // the user is trying to select recipients data by clicking the Mail merge button
        var onRequestMailMergeRecipients = function (event) {
            innerAlert("onRequestMailMergeRecipients ready");
            docEditor.setMailMergeRecipients(${dataMailMergeRecipients});
        };

        config = ${modelJsonStr};

        if (config.editorConfig.user.name == "Anonymous") {
            config.editorConfig.user.name = "";
        }

        var onRequestSaveAs = function (event) {  //  the user is trying to save file by clicking Save Copy as... button
            innerAlert("onRequestSave: " + JSON.stringify(event.data));
            var title = event.data.title;
            var url = event.data.url;
            var data = {
                title: title,
                url: url
            };
            let xhr = new XMLHttpRequest();
            xhr.open("POST", "saveas");
            xhr.setRequestHeader('Content-Type', 'application/json');
            xhr.setRequestHeader('Authorization','Bearer '+token);
            xhr.send(JSON.stringify(data));
            xhr.onload = function () {
                innerAlert(xhr.responseText);
                innerAlert(JSON.parse(xhr.responseText).file, true);
            }
        };

        var onRequestRename = function (event) { //  the user is trying to rename file by clicking Rename... button
            innerAlert("onRequestRename: " + JSON.stringify(event.data));

            var newfilename = event.data;
            var data = {
                newfilename: newfilename,
                dockey: config.document.key,
                ext: config.document.fileType,
                fileId: config.document.fileId,
                source: config.document.source
            };
            let xhr = new XMLHttpRequest();
            xhr.open("POST", "rename");
            xhr.setRequestHeader('Content-Type', 'application/json');
            xhr.setRequestHeader('Authorization','Bearer '+token);
            xhr.send(JSON.stringify(data));
            xhr.onload = function () {
                innerAlert(xhr.responseText);
            }
        };
        var onRequestRestore = function (event) {
            var fileType = event.data.fileType;
            var url = event.data.url;
            var version = event.data.version;
            var data = {
                fileId: config.document.fileId,
                source: config.document.source,
                version: version
            };
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "historyRestore");
            xhr.setRequestHeader('Content-Type', 'application/json');
            xhr.setRequestHeader('Authorization','Bearer '+token);
            xhr.send(JSON.stringify(data));
            xhr.onload = function () {
                innerAlert(xhr.responseText);
            }
            document.location.reload();
            //docEditor.refreshHistory(hist);
        };

        config.width = "100%";
        config.height = "100%";
        config.events = {
            "onAppReady": onAppReady,
            "onDocumentStateChange": onDocumentStateChange,
            'onRequestEditRights': onRequestEditRights,
            "onError": onError,
            "onOutdatedVersion": onOutdatedVersion,
            "onMakeActionLink": onMakeActionLink,
            "onMetaChange": onMetaChange,
            "onRequestInsertImage": onRequestInsertImage,
            "onRequestCompareFile": onRequestCompareFile,
            "onRequestMailMergeRecipients": onRequestMailMergeRecipients,
            // "onRequestHistoryData": onRequestRestore,
            "onRequestRestore": onRequestRestore
        };
        <#--var histArray = ${fileHistory};-->
        var hist = ${histObj};
        var historyData = ${histData};
        <#--var usersForMentions = ${usersForMentions};-->
        if (config.editorConfig.user.id != '') {
            debugger
            if (hist && historyData) {
                // the user is trying to show the document version history
                config.events['onRequestHistory'] = function () {
                    debugger
                    docEditor.refreshHistory(hist);  // show the document version history
                    // docEditor.refreshHistory(JSON.parse(hist));  // show the document version history
                };
                // the user is trying to click the specific document version in the document version history
                config.events['onRequestHistoryData'] = function (event) {
                    debugger
                    var ver = event.data;
                    var histData = historyData;
                    docEditor.setHistoryData(histData[ver - 1]);  // send the link to the document for viewing the version history
                    // docEditor.setHistoryData(JSON.parse(histData)[ver - 1]);  // send the link to the document for viewing the version history
                };
                // the user is trying to go back to the document from viewing the document version history
                config.events['onRequestHistoryClose'] = function () {
                    document.location.reload();
                };
            }
            // add mentions for not anonymous users
            // config.events['onRequestUsers'] = function () {
            //     docEditor.setUsers({  // set a list of users to mention in the comments
            //         "users": usersForMentions
            //     });
            // };
            // the user is mentioned in a comment
            config.events['onRequestSendNotify'] = function (event) {
                event.data.actionLink = replaceActionLink(location.href, JSON.stringify(event.data.actionLink));
                var data = JSON.stringify(event.data);
                innerAlert("onRequestSendNotify: " + data);
            };
            // prevent file renaming for anonymous users
            config.events['onRequestRename'] = onRequestRename;
        }

        if (config.editorConfig.createUrl) {
            config.events.onRequestSaveAs = onRequestSaveAs;
        }
        ;




        var сonnectEditor = function () {
            if ((config.document.fileType === "docxf" || config.document.fileType === "oform")
                && DocsAPI.DocEditor.version().split(".")[0] < 7) {
                innerAlert("Please update ONLYOFFICE Docs to version 7.0 to work on fillable forms online.");
                return;
            }

            docEditor = new DocsAPI.DocEditor("iframeEditor", config);
        };

        if (window.addEventListener) {
            window.addEventListener("load", сonnectEditor);
        } else if (window.attachEvent) {
            window.attachEvent("load", сonnectEditor);
        }

        function jumpPost(url,postParam){
            let dom = document.createElement('form') //新建一个form表单
            dom.action = url //此处是跳转的url 请求地址
            dom.target = '_blank' //target 是否打开新页面
            dom.method = 'post' //请求方法 如果要隐藏就一定要post
            for (let key in postParam){
                if (!key){
                    continue;
                }
                let inputPas = document.createElement('input') //新建输入框
                inputPas.name = key //名字就是传值的key
                inputPas.type = 'hidden' //隐藏的输入字段
                inputPas.value = postParam[key] //此处为数据
                dom.appendChild(inputPas)
            }
            document.body.appendChild(dom) //将dom插入到body下
            dom.submit() //触发submit事件
            document.body.removeChild(dom) //操作完成后删除节点
        }
    </script>

</head>
<body>
<div class="form">
    <div id="iframeEditor"></div>
</div>
</body>
</html>
