/*
 * Decompiled with CFR 0.152.
 */
package poi.editor;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.ss.util.CellRangeAddress;
import poi.ExcelContext;
import poi.editor.AbstractRegionEditor;
import poi.editor.CellEditor;

public class RowEditor
extends AbstractRegionEditor<RowEditor> {
    private HSSFRow row;
    private int startCol = 0;

    public RowEditor(int row, int startCol, ExcelContext context) {
        super(context);
        this.row = this.getRow(row);
        this.startCol = startCol;
    }

    public RowEditor(int row, ExcelContext context) {
        this(row, 0, context);
    }

    public RowEditor value(Object[] rowData) {
        this.value(rowData, this.startCol);
        return this;
    }

    public RowEditor value(Object[] rowData, int startCol) {
        if (startCol < 0) {
            startCol = 0;
        }
        this.insertData(rowData, this.row, startCol, true);
        return this;
    }

    public RowEditor insert(Object[] rowData) {
        return this.insert(rowData, this.startCol);
    }

    public RowEditor insert(Object[] rowData, int startCol) {
        if (startCol < 0) {
            startCol = 0;
        }
        this.insertData(rowData, this.row, startCol, false);
        return this;
    }

    public RowEditor append(Object[] rowData) {
        this.insertData(rowData, this.row, this.row.getLastCellNum(), true);
        return this;
    }

    @Override
    public RowEditor height(float h) {
        this.row.setHeightInPoints(h);
        return this;
    }

    public CellEditor cell(int col, int ... cols) {
        CellEditor cellEditor = new CellEditor(this.row.getRowNum(), col, this.ctx);
        for (int c : cols) {
            cellEditor.add(this.row.getRowNum(), c);
        }
        return cellEditor;
    }

    public HSSFRow toHSSFRow() {
        return this.row;
    }

    public RowEditor width(int[] widths) {
        CellEditor cellEditor = this.newTopCellEditor();
        cellEditor.width(widths);
        return this;
    }

    private void insertData(Object[] rowData, HSSFRow row, int startCol, boolean overwrite) {
        if (!overwrite) {
            this.workingSheet.shiftRows(row.getRowNum(), this.workingSheet.getLastRowNum(), 1, true, false);
        }
        int i = 0;
        for (Object obj : rowData) {
            CellEditor cellEditor = new CellEditor(row.getRowNum(), startCol + i, this.ctx);
            cellEditor.value(obj);
            i = (short)(i + 1);
        }
    }

    @Override
    protected CellEditor newCellEditor() {
        CellEditor cellEditor = new CellEditor(this.ctx);
        int minColIx = 0;
        short maxColIx = 0;
        minColIx = this.startCol;
        maxColIx = this.row.getLastCellNum();
        for (int i = minColIx; i < maxColIx; ++i) {
            cellEditor.add(this.row.getRowNum(), i);
        }
        return cellEditor;
    }

    @Override
    protected CellEditor newBottomCellEditor() {
        return this.newCellEditor();
    }

    @Override
    protected CellEditor newLeftCellEditor() {
        CellEditor cellEditor = new CellEditor(this.ctx);
        cellEditor.add(this.row.getRowNum(), this.startCol);
        return cellEditor;
    }

    @Override
    protected CellEditor newRightCellEditor() {
        CellEditor cellEditor = new CellEditor(this.ctx);
        cellEditor.add(this.row.getRowNum(), (int)this.row.getLastCellNum());
        return cellEditor;
    }

    @Override
    protected CellEditor newTopCellEditor() {
        return this.newCellEditor();
    }

    @Override
    protected CellRangeAddress getCellRange() {
        return new CellRangeAddress(this.row.getRowNum(), this.row.getRowNum(), this.startCol, this.row.getLastCellNum() - 1);
    }

    protected HSSFRow getHSSFRow() {
        return this.row;
    }
}

