/*
 * Decompiled with CFR 0.152.
 */
package poi.util;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.hotent.base.annotation.ExcelColumn;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.RequiredException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.ReflectUtil;
import com.hotent.base.util.StringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.poi.common.Duplicatable;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import poi.Excel;
import poi.editor.IFontEditor;
import poi.reader.TableHeaderDef;
import poi.style.Align;
import poi.style.BorderStyle;
import poi.style.Color;
import poi.style.font.BoldWeight;
import poi.style.font.Font;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    public static final String EXCEL2003 = "xls";
    public static final String EXCEL2007 = "xlsx";
    public static final short DEFAULT_ROW_HEIGHT = 20;

    public static int getLastRowNum(HSSFSheet sheet) {
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum == 0) {
            lastRowNum = sheet.getPhysicalNumberOfRows() - 1;
        }
        return lastRowNum;
    }

    public static int getFirstCellNum(HSSFRow row) {
        return row.getFirstCellNum();
    }

    public static int getLastCellNum(HSSFRow row) {
        return row.getLastCellNum();
    }

    public static HSSFRow getHSSFRow(HSSFSheet sheet, int row) {
        HSSFRow r;
        if (row < 0) {
            row = 0;
        }
        if ((r = sheet.getRow(row)) == null) {
            r = sheet.createRow(row);
        }
        return r;
    }

    public static HSSFCell getHSSFCell(HSSFSheet sheet, int row, int col) {
        HSSFRow r = ExcelUtil.getHSSFRow(sheet, row);
        return ExcelUtil.getHSSFCell(r, col);
    }

    public static HSSFCell getHSSFCell(HSSFRow row, int col) {
        HSSFCell c;
        if (col < 0) {
            col = 0;
        }
        c = (c = row.getCell(col)) == null ? row.createCell(col) : c;
        return c;
    }

    public static HSSFSheet getHSSFSheet(HSSFWorkbook workbook, int index) {
        if (index < 0) {
            index = 0;
        }
        if (index > workbook.getNumberOfSheets() - 1) {
            workbook.createSheet();
            return workbook.getSheetAt(workbook.getNumberOfSheets() - 1);
        }
        return workbook.getSheetAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadExcel(Workbook workBook, String fileName, HttpServletResponse response) throws IOException {
        String type = ".xlsx";
        if (workBook instanceof HSSFWorkbook) {
            type = ".xls";
        }
        String filedisplay = URLEncoder.encode(fileName + type, "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        try (ServletOutputStream os = null;){
            os = response.getOutputStream();
            workBook.write((OutputStream)os);
            os.flush();
            os.close();
        }
    }

    public static HSSFWorkbook exportExcel(String type, String parentDesc, String sheetName, int rowHeight, Map<String, String> fieldMap, Excel excel, int index) throws Exception {
        int size;
        excel.setWorkingSheet(index).sheetName(sheetName);
        String tips = "";
        tips = type.equals("main") ? "\u8bf7\u6ce8\u610f\u6838\u5bf9\u5404\u4e2a\u5b50\u5b59\u5b9e\u4f53\u7684\u4e3b\u952e\u548c\u5916\u952e\u662f\u5426\u5bf9\u5e94\uff0c\u53ea\u6709\u7236\u5b9e\u4f53\u7684\u4e3b\u952e\u548c\u5b50\u5b9e\u4f53\u5916\u952e\u76f8\u7b49\uff0c\u624d\u80fd\u5bfc\u5165\u6210\u529f\uff01" : "\u5916\u952e\u5fc5\u987b\u4e0e\" " + parentDesc + " \"\u7684\u4e3b\u952e\u76f8\u7b49\u624d\u80fd\u5bfc\u5165\u6210\u529f\uff01";
        excel.cell(0, 0).value(tips).align(Align.CENTER).bgColor(Color.LIGHT_YELLOW).height(30.0f).addWidth(2000).font(new IFontEditor(){

            @Override
            public void updateFont(Font font) {
                font.boldweight(BoldWeight.BOLD);
                font.color(Color.BROWN);
            }
        });
        excel.region(0, 0, 0, fieldMap.size() - 1).merge();
        int titleCols = size = fieldMap.size();
        if (titleCols == 0) {
            throw new Exception("\u8bf7\u8bbe\u7f6e\u5217\uff01");
        }
        int i = 0;
        for (String name : fieldMap.values()) {
            excel.cell(1, i).value("").border(BorderStyle.MEDIUM, Color.BLACK).fontHeightInPoint(14).warpText(true).align(Align.LEFT);
            excel.cell(1, i).value(name).align(Align.CENTER).bgColor(Color.GREY_25_PERCENT).fontHeightInPoint(14).width(12800).border(BorderStyle.THIN, Color.BLACK).font(new IFontEditor(){

                @Override
                public void updateFont(Font font) {
                    font.boldweight(BoldWeight.BOLD);
                    font.color(Color.BLACK);
                }
            });
            ++i;
        }
        return excel.getWorkBook();
    }

    public static HSSFWorkbook exportExcel(String title, int rowHeight, Map<String, String> fieldMap, List data) throws Exception {
        int size = fieldMap.size();
        Excel excel = new Excel();
        if (size == 0) {
            throw new Exception("\u8bf7\u8bbe\u7f6e\u5217\uff01");
        }
        excel.sheet().sheetName(title);
        int i = 0;
        for (String name : fieldMap.values()) {
            excel.cell(0, i).value("").border(BorderStyle.MEDIUM, Color.BLACK).fontHeightInPoint(14).warpText(true).align(Align.LEFT);
            excel.cell(0, i).value(name).align(Align.CENTER).bgColor(Color.GREY_25_PERCENT).fontHeightInPoint(14).width(7680).border(BorderStyle.THIN, Color.BLACK).font(font -> {
                font.boldweight(BoldWeight.BOLD);
                font.color(Color.BLACK);
            });
            ++i;
        }
        int rows = 1;
        for (Object obj : data) {
            Map rowObj = (Map)obj;
            int col = 0;
            for (String key : fieldMap.keySet()) {
                String val = rowObj.get(key) == null ? "" : rowObj.get(key);
                excel.cell(rows, col).value(val).border(BorderStyle.MEDIUM, Color.BLACK).fontHeightInPoint(14).warpText(true).align(Align.LEFT);
                ++col;
            }
            ++rows;
        }
        return excel.getWorkBook();
    }

    public static HSSFWorkbook exportExcel(String sheetName, int rowHeight, List<TableHeaderDef> headerDefList, List data) throws Exception {
        int size = headerDefList.size();
        Excel excel = new Excel();
        int titleCols = size;
        if (titleCols == 0) {
            throw new Exception("\u8bf7\u8bbe\u7f6e\u5217\uff01");
        }
        excel.sheet().sheetName(sheetName);
        int i = 0;
        for (TableHeaderDef headerDef : headerDefList) {
            String name = headerDef.getName();
            String comment = headerDef.getComment();
            excel.cell(0, i).value(name).comment(comment).align(Align.CENTER).bgColor(Color.GREY_25_PERCENT).fontHeightInPoint(14).width(7680).border(BorderStyle.THIN, Color.BLACK).font(font -> {
                font.boldweight(BoldWeight.BOLD);
                font.color(Color.BLACK);
            });
            ++i;
        }
        int rows = 1;
        for (Object obj : data) {
            Map rowObj = (Map)obj;
            int col = 0;
            for (TableHeaderDef headerDef : headerDefList) {
                String key = headerDef.getKey();
                String val = rowObj.get(key) == null ? "" : rowObj.get(key).toString();
                excel.cell(rows, col).value(val).border(BorderStyle.MEDIUM, Color.BLACK).fontHeightInPoint(14).warpText(true).align(Align.LEFT);
                ++col;
            }
            ++rows;
        }
        return excel.getWorkBook();
    }

    public static List<Map<String, String>> ImportDate(MultipartFile firstFile) {
        return ExcelUtil.ImportDate(firstFile, false, 0);
    }

    public static List<Map<String, String>> ImportDate(MultipartFile firstFile, int headerIndex) {
        return ExcelUtil.ImportDate(firstFile, false, headerIndex);
    }

    public static List<Map<String, String>> ImportDate(MultipartFile firstFile, int headerIndex, String sheetName) {
        return ExcelUtil.ImportDate(firstFile, false, headerIndex, sheetName);
    }

    public static List<Map<String, String>> ImportDate(MultipartFile firstFile, boolean commentAsKey, int headerIndex) {
        Workbook wb = null;
        Sheet sheet = null;
        Row row = null;
        ArrayList list = null;
        String cellData = null;
        ArrayList<String> columns = new ArrayList<String>();
        wb = ExcelUtil.readExcel(firstFile);
        if (wb != null) {
            list = new ArrayList();
            sheet = wb.getSheetAt(0);
            int rownum = sheet.getPhysicalNumberOfRows() + headerIndex;
            row = sheet.getRow(headerIndex);
            int colnum = row.getPhysicalNumberOfCells();
            for (int i = headerIndex; i < rownum; ++i) {
                int j;
                LinkedHashMap map = new LinkedHashMap();
                row = sheet.getRow(i);
                if (row == null) continue;
                if (i == headerIndex) {
                    for (j = 0; j < colnum; ++j) {
                        cellData = commentAsKey ? ExcelUtil.getCellComment(row.getCell(j)) : (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                        columns.add(cellData);
                    }
                    continue;
                }
                for (j = 0; j < colnum; ++j) {
                    cellData = (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                    map.put(columns.get(j), cellData);
                }
                list.add(map);
            }
        }
        return list;
    }

    public static List<Map<String, String>> ImportDate(MultipartFile firstFile, boolean commentAsKey, int headerIndex, String sheetName) {
        Workbook wb = null;
        Sheet sheet = null;
        Row row = null;
        ArrayList list = null;
        String cellData = null;
        ArrayList<String> columns = new ArrayList<String>();
        wb = ExcelUtil.readExcel(firstFile);
        if (wb != null) {
            list = new ArrayList();
            sheet = wb.getSheet(sheetName);
            if (BeanUtils.isEmpty((Object)sheet)) {
                throw new BaseException("\u65e0\u6cd5\u4eceExcel\u4e2d\u83b7\u53d6sheetName\u4e3a\uff1a" + sheetName + "\u7684\u5de5\u4f5c\u7c3f\u3002\u8bf7\u68c0\u67e5Excel\u4e2d\u7684sheet\u540d\u79f0\u4e0e\u5efa\u6a21\u5b9e\u4f53\u540d\u79f0\u662f\u5426\u5bf9\u5e94\u3002");
            }
            int rownum = sheet.getPhysicalNumberOfRows() + headerIndex;
            row = sheet.getRow(headerIndex);
            int colnum = row.getPhysicalNumberOfCells();
            for (int i = headerIndex; i < rownum; ++i) {
                int j;
                LinkedHashMap map = new LinkedHashMap();
                row = sheet.getRow(i);
                if (row == null) continue;
                if (i == headerIndex) {
                    for (j = 0; j < colnum; ++j) {
                        cellData = commentAsKey ? ExcelUtil.getCellComment(row.getCell(j)) : (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                        columns.add(cellData);
                    }
                    continue;
                }
                for (j = 0; j < colnum; ++j) {
                    cellData = (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                    map.put(columns.get(j), cellData);
                }
                list.add(map);
            }
        }
        return list;
    }

    public static String getCellComment(Cell cell) {
        RichTextString richTextString;
        String comment = "";
        Comment cellComment = cell.getCellComment();
        if (cellComment != null && (richTextString = cellComment.getString()) != null) {
            comment = richTextString.getString();
        }
        return comment;
    }

    public static Workbook readExcel(MultipartFile multipartFile) {
        String filePath = multipartFile.getOriginalFilename();
        HSSFWorkbook wb = null;
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf("."));
        InputStream is = null;
        try {
            is = multipartFile.getInputStream();
            if (".xls".equals(extString)) {
                wb = new HSSFWorkbook(is);
                return wb;
            }
            if (".xlsx".equals(extString)) {
                wb = new XSSFWorkbook(is);
                return wb;
            }
            wb = null;
            return null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getCellFormatValue(Cell cell) {
        String cellValue = null;
        if (cell == null) return "";
        if (cell.getCellType() != CellType.FORMULA) return ExcelUtil.getCellValueOfCellType(cell, cell.getCellType());
        if (!DateUtil.isCellDateFormatted((Cell)cell)) return ExcelUtil.getCellValueOfCellType(cell, cell.getCachedFormulaResultType());
        ExcelStyleDateFormatter formatter = new ExcelStyleDateFormatter("yyyy-MM-dd");
        return formatter.format(cell.getDateCellValue());
    }

    private static Object getCellValueOfCellType(Cell cell, CellType cellType) {
        Object cellValue = "";
        switch (cellType) {
            case NUMERIC: {
                cellValue = StringUtil.format((double)cell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue();
                break;
            }
            case STRING: {
                cellValue = cell.getRichStringCellValue().getString();
                break;
            }
            default: {
                cellValue = "";
            }
        }
        return cellValue;
    }

    public static void saveExcel(HSSFWorkbook workBook, String fileName, String path) throws IOException {
        FileUtil.createFolder((String)path, (boolean)true);
        String excelName = fileName + ".xls";
        String filePath = path + File.separator + excelName;
        FileOutputStream fout = new FileOutputStream(filePath);
        workBook.write((OutputStream)fout);
        fout.flush();
        fout.close();
    }

    public static void mergeSameColumnCell(Sheet sheet, int startRow, int mergeCol) {
        String startValue = ExcelUtil.getCellContentAsString(ExcelUtil.getCell(sheet, startRow, mergeCol));
        int totalRows = sheet.getPhysicalNumberOfRows();
        int startMergeRow = startRow - 1;
        for (int compareRow = startRow + 1; totalRows > compareRow; ++compareRow) {
            Cell cell = ExcelUtil.getCell(sheet, compareRow, mergeCol);
            String rowCellValue = ExcelUtil.getCellContentAsString(cell);
            if (startValue.equals(rowCellValue)) continue;
            if (compareRow - startMergeRow > 1 && ExcelUtil.getCellContentAsString(ExcelUtil.getCell(sheet, startMergeRow, mergeCol)).equals(ExcelUtil.getCellContentAsString(ExcelUtil.getCell(sheet, compareRow - 1, mergeCol)))) {
                ExcelUtil.addMergeCellReign(sheet, startMergeRow, mergeCol, compareRow - 1, mergeCol);
            }
            startMergeRow = compareRow;
            startValue = rowCellValue;
        }
    }

    public static void mergeRowTotal(Sheet sheet, int startRow, int startCol, String totalName) {
        int totalRows = sheet.getPhysicalNumberOfRows();
        int totalCols = sheet.getRow(0).getPhysicalNumberOfCells();
        while (totalRows > startRow) {
            Cell cell = ExcelUtil.getCell(sheet, startRow, startCol);
            String rowCellValue = ExcelUtil.getCellContentAsString(cell);
            if (totalName.equals(rowCellValue)) {
                for (int currentCol = startCol + 1; totalCols > currentCol; ++currentCol) {
                    cell = ExcelUtil.getCell(sheet, startRow, currentCol);
                    rowCellValue = ExcelUtil.getCellContentAsString(cell);
                    if (totalName.equals(rowCellValue)) continue;
                    ExcelUtil.addMergeCellReign(sheet, startRow, startCol, startRow, currentCol - 1);
                    break;
                }
            }
            ++startRow;
        }
    }

    public static void setRowFillForegroundColor(Sheet sheet, int startRow, int startCol, String totalName, short indexedColors) {
        int totalRows = sheet.getPhysicalNumberOfRows();
        while (totalRows > startRow) {
            Cell cell = ExcelUtil.getCell(sheet, startRow, startCol);
            String rowCellValue = ExcelUtil.getCellContentAsString(cell);
            if (totalName.equals(rowCellValue)) {
                Row styleRow = sheet.getRow(startRow);
                for (Cell oldCell : styleRow) {
                    CellStyle cellStyle = oldCell.getCellStyle();
                    cellStyle.setFillForegroundColor(indexedColors);
                    oldCell.setCellStyle(cellStyle);
                }
            }
            ++startRow;
        }
    }

    public static void addMergeCellReign(Sheet sheet, int startRow, int startCol, int endRow, int endCol) {
        CellRangeAddress region = new CellRangeAddress(startRow, endRow, startCol, endCol);
        sheet.addMergedRegion(region);
        Cell cell = ExcelUtil.getCell(sheet, startRow, startCol);
        CellStyle cellStyle = cell.getCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
    }

    private static Cell getCell(Sheet sheet, int row, int col) {
        Row row2 = sheet.getRow(row);
        if (BeanUtils.isEmpty((Object)row2)) {
            return null;
        }
        Cell cell = row2.getCell(col);
        return cell;
    }

    public static void calcAndSetRowHeigt(HSSFRow sourceRow) {
        for (int cellIndex = sourceRow.getFirstCellNum(); cellIndex <= sourceRow.getPhysicalNumberOfCells(); ++cellIndex) {
            double stringNeedsHeight;
            double maxHeight = sourceRow.getHeight();
            HSSFCell sourceCell = sourceRow.getCell(cellIndex);
            String cellContent = ExcelUtil.getCellContentAsString((Cell)sourceCell);
            if (null == cellContent || "".equals(cellContent)) continue;
            Map<String, Object> cellInfoMap = ExcelUtil.getCellInfo(sourceCell);
            Integer cellWidth = (Integer)cellInfoMap.get("width");
            Integer cellHeight = (Integer)cellInfoMap.get("height");
            if ((double)cellHeight.intValue() > maxHeight) {
                maxHeight = cellHeight.intValue();
            }
            HSSFCellStyle cellStyle = sourceCell.getCellStyle();
            HSSFFont font = cellStyle.getFont((Workbook)sourceRow.getSheet().getWorkbook());
            short fontHeight = font.getFontHeight();
            double cellContentWidth = cellContent.getBytes().length * 2 * 256;
            double stringNeedsRows = cellContentWidth / (double)cellWidth.intValue();
            if (stringNeedsRows < 1.0) {
                stringNeedsRows = 1.0;
            }
            if (!((stringNeedsHeight = (double)fontHeight * stringNeedsRows) > maxHeight)) continue;
            maxHeight = stringNeedsHeight;
            if (maxHeight / (double)cellHeight.intValue() > 5.0) {
                maxHeight = 5 * cellHeight;
            }
            maxHeight = Math.ceil(maxHeight);
            Boolean isPartOfRowsRegion = (Boolean)cellInfoMap.get("isPartOfRowsRegion");
            if (isPartOfRowsRegion.booleanValue()) {
                Integer firstRow = (Integer)cellInfoMap.get("firstRow");
                Integer lastRow = (Integer)cellInfoMap.get("lastRow");
                double addHeight = (maxHeight - (double)cellHeight.intValue()) / (double)(lastRow - firstRow + 1);
                for (int i = firstRow.intValue(); i <= lastRow; ++i) {
                    double rowsRegionHeight = (double)sourceRow.getSheet().getRow(i).getHeight() + addHeight;
                    sourceRow.getSheet().getRow(i).setHeight((short)rowsRegionHeight);
                }
                continue;
            }
            sourceRow.setHeight((short)maxHeight);
        }
    }

    private static String getCellContentAsString(Cell cell) {
        if (null == cell) {
            return "";
        }
        return ExcelUtil.getCellFormatValue(cell).toString();
    }

    private static Map<String, Object> getCellInfo(HSSFCell cell) {
        HSSFSheet sheet = cell.getSheet();
        int rowIndex = cell.getRowIndex();
        int columnIndex = cell.getColumnIndex();
        boolean isPartOfRegion = false;
        int firstColumn = 0;
        int lastColumn = 0;
        int firstRow = 0;
        int lastRow = 0;
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            firstColumn = ca.getFirstColumn();
            lastColumn = ca.getLastColumn();
            firstRow = ca.getFirstRow();
            lastRow = ca.getLastRow();
            if (rowIndex < firstRow || rowIndex > lastRow || columnIndex < firstColumn || columnIndex > lastColumn) continue;
            isPartOfRegion = true;
            break;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer width = 0;
        Integer height = 0;
        boolean isPartOfRowsRegion = false;
        if (isPartOfRegion) {
            int i;
            for (i = firstColumn; i <= lastColumn; ++i) {
                width = width + sheet.getColumnWidth(i);
            }
            for (i = firstRow; i <= lastRow; ++i) {
                height = height + sheet.getRow(i).getHeight();
            }
            if (lastRow > firstRow) {
                isPartOfRowsRegion = true;
            }
        } else {
            width = sheet.getColumnWidth(columnIndex);
            height = height + cell.getRow().getHeight();
        }
        map.put("isPartOfRowsRegion", isPartOfRowsRegion);
        map.put("firstRow", firstRow);
        map.put("lastRow", lastRow);
        map.put("width", width);
        map.put("height", height);
        return map;
    }

    public static <T> List<T> readExcel(Class<T> cls, MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (!fileName.matches("^.+\\.(?i)(xls)$") && !fileName.matches("^.+\\.(?i)(xlsx)$")) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        ArrayList<T> dataList = new ArrayList<T>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
            if (workbook != null) {
                HashMap classMap = new HashMap();
                List<Field> fields = Stream.of(cls.getDeclaredFields()).collect(Collectors.toList());
                fields.forEach(field -> {
                    ExcelColumn annotation = field.getAnnotation(ExcelColumn.class);
                    if (annotation != null) {
                        String value = annotation.col() + "";
                        annotation.col();
                        if (StringUtils.isBlank((String)value)) {
                            return;
                        }
                        if (!classMap.containsKey(value)) {
                            classMap.put(value, new ArrayList());
                        }
                        field.setAccessible(true);
                        ((List)classMap.get(value)).add(field);
                    }
                });
                HashMap reflectionMap = new HashMap(16);
                Sheet sheet = workbook.getSheetAt(0);
                boolean firstRow = true;
                for (int i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
                    Row row = sheet.getRow(i);
                    if (firstRow) {
                        for (int j = row.getFirstCellNum(); j <= row.getLastCellNum(); ++j) {
                            if (!classMap.containsKey(j + "")) continue;
                            reflectionMap.put(j, classMap.get(j + ""));
                        }
                        firstRow = false;
                        continue;
                    }
                    if (row == null) continue;
                    try {
                        Object t = cls.newInstance();
                        boolean allBlank = true;
                        for (int j = row.getFirstCellNum(); j <= row.getLastCellNum(); ++j) {
                            if (!reflectionMap.containsKey(j)) continue;
                            Cell cell = row.getCell(j);
                            String cellValue = ExcelUtil.getCellContentAsString(cell);
                            if (StringUtils.isNotBlank((String)cellValue)) {
                                allBlank = false;
                            }
                            List fieldList = (List)reflectionMap.get(j);
                            fieldList.forEach(x -> {
                                try {
                                    ExcelUtil.handleField(t, cellValue, x);
                                }
                                catch (Exception e) {
                                    log.error(String.format("reflect field:%s value:%s exception!", x.getName(), cellValue), (Throwable)e);
                                }
                            });
                        }
                        if (!allBlank) {
                            dataList.add(t);
                            continue;
                        }
                        log.warn(String.format("row:%s is blank ignore!", i));
                        continue;
                    }
                    catch (Exception e) {
                        log.error(String.format("parse row:%s exception!", i), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(String.format("parse excel exception!", new Object[0]), (Throwable)e);
        }
        return dataList;
    }

    private static <T> void handleField(T t, String value, Field field) throws Exception {
        Class<?> type = field.getType();
        if (type == null || type == Void.TYPE || StringUtils.isBlank((String)value)) {
            return;
        }
        if (type == Object.class) {
            field.set(t, value);
        } else if (type.getSuperclass() == null || type.getSuperclass() == Number.class) {
            if (type == Integer.TYPE || type == Integer.class) {
                field.set(t, NumberUtils.toInt((String)value));
            } else if (type == Long.TYPE || type == Long.class) {
                field.set(t, NumberUtils.toLong((String)value));
            } else if (type == Byte.TYPE || type == Byte.class) {
                field.set(t, NumberUtils.toByte((String)value));
            } else if (type == Short.TYPE || type == Short.class) {
                field.set(t, NumberUtils.toShort((String)value));
            } else if (type == Double.TYPE || type == Double.class) {
                field.set(t, NumberUtils.toDouble((String)value));
            } else if (type == Float.TYPE || type == Float.class) {
                field.set(t, Float.valueOf(NumberUtils.toFloat((String)value)));
            } else if (type == Character.TYPE || type == Character.class) {
                field.set(t, Character.valueOf(CharUtils.toChar((String)value)));
            } else if (type == Boolean.TYPE) {
                field.set(t, BooleanUtils.toBoolean((String)value));
            } else if (type == BigDecimal.class) {
                field.set(t, new BigDecimal(value));
            }
        } else if (type == Boolean.class) {
            field.set(t, BooleanUtils.toBoolean((String)value));
        } else if (type == Date.class) {
            field.set(t, value);
        } else if (type == String.class) {
            field.set(t, value);
        } else {
            Constructor<?> constructor = type.getConstructor(String.class);
            field.set(t, constructor.newInstance(value));
        }
    }

    public static void setAutoResizeColumn(Workbook workbook) {
        int sheets = workbook.getNumberOfSheets();
        for (int index = 0; index < sheets; ++index) {
            Sheet sheet = workbook.getSheetAt(index);
            int cols = sheet.getRow(0).getPhysicalNumberOfCells();
            for (int i = 0; i < cols; ++i) {
                sheet.autoSizeColumn(i);
            }
        }
    }

    public static void exportCSV(String fileName, LinkedHashMap<String, String> headerMap, List<Map<String, Object>> exportData, HttpServletResponse response) throws IOException {
        String filedisplay = URLEncoder.encode(fileName + ".csv", "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        try (ServletOutputStream out = response.getOutputStream();
             ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
             BufferedWriter buffCvsWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteStream, StandardCharsets.UTF_8));){
            ExcelUtil.fillDataToCsv(buffCvsWriter, headerMap, headerMap);
            Iterator<Map<String, Object>> iterator = exportData.iterator();
            while (iterator.hasNext()) {
                ExcelUtil.fillDataToCsv(buffCvsWriter, headerMap, iterator.next());
            }
            buffCvsWriter.flush();
            out.write(byteStream.toByteArray());
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void fillDataToCsv(BufferedWriter buffCvsWriter, LinkedHashMap<String, String> header, Map row) throws IOException {
        Iterator<String> keyIterator = header.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            String propertyValue = "";
            if (BeanUtils.isNotEmpty(row.get(key))) {
                propertyValue = row.get(key).toString();
            }
            buffCvsWriter.write("\t" + propertyValue + " ");
            if (!keyIterator.hasNext()) continue;
            buffCvsWriter.write(",");
        }
        buffCvsWriter.newLine();
    }

    public static SXSSFWorkbook createSXSSFWorkbook(String sheetName, Map<String, String> fieldMap, List<Map<String, Object>> data) throws Exception {
        return ExcelUtil.createSXSSFWorkbook(sheetName, 20, fieldMap, data);
    }

    public static SXSSFWorkbook createSXSSFWorkbook(String sheetName, int rowHeight, Map<String, String> fieldMap, List<Map<String, Object>> data) throws Exception {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        ExcelUtil.createSheetForMap(workbook, sheetName, rowHeight, fieldMap, data);
        return workbook;
    }

    public static void createSheetForMap(SXSSFWorkbook workbook, String sheetName, int rowHeight, Map<String, String> fieldMap, List<Map<String, Object>> data) throws Exception {
        SXSSFSheet createSheet = workbook.createSheet(sheetName);
        SXSSFRow createRow = createSheet.createRow(1);
        createRow.setHeight((short)rowHeight);
        createRow.setHeightInPoints((float)rowHeight);
        createSheet.setDefaultRowHeight((short)rowHeight);
        createSheet.setDefaultRowHeightInPoints((float)rowHeight);
        createSheet.setDefaultColumnWidth(20);
        int i = 0;
        CellStyle style = workbook.createCellStyle();
        org.apache.poi.ss.usermodel.Font createFont = workbook.createFont();
        createFont.setBold(true);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setWrapText(true);
        style.setFont(createFont);
        style.setBorderLeft(org.apache.poi.ss.usermodel.BorderStyle.THIN);
        style.setBorderRight(org.apache.poi.ss.usermodel.BorderStyle.THIN);
        style.setBorderTop(org.apache.poi.ss.usermodel.BorderStyle.THIN);
        style.setBorderBottom(org.apache.poi.ss.usermodel.BorderStyle.THIN);
        for (String name : fieldMap.keySet()) {
            Cell createCell = createRow.createCell(i);
            createCell.setCellValue(fieldMap.get(name));
            createCell.setCellStyle(style);
            ++i;
        }
        if (BeanUtils.isNotEmpty(data)) {
            ExcelUtil.appendRow(data, new HashMap<String, Map<String, String>>(), createSheet, null, fieldMap, 1);
        }
    }

    public static void appendRow(List<Map<String, Object>> dataList, Map<String, Map<String, String>> filedFormat, SXSSFSheet sXSSFSheet, Row headerRow, Map<String, String> fieldMap, int preIndex) {
        if (BeanUtils.isEmpty(dataList)) {
            return;
        }
        if (sXSSFSheet == null) {
            throw new RequiredException("\u88ab\u5199\u5165\u6570\u636e\u7684sheet\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (fieldMap == null) {
            throw new RequiredException("\u8868\u5934map\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HashMap<String, String> descKeyMap = new HashMap<String, String>();
        for (Map.Entry<String, String> next : fieldMap.entrySet()) {
            descKeyMap.put(next.getValue(), next.getKey());
        }
        CellStyle styleBase = sXSSFSheet.getWorkbook().createCellStyle();
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> data = dataList.get(i);
            SXSSFRow newRow = sXSSFSheet.createRow(preIndex + i + 1);
            newRow.setHeight(headerRow.getHeight());
            newRow.setRowStyle(headerRow.getRowStyle());
            for (int j = 0; j < descKeyMap.keySet().size(); ++j) {
                Comparable<Double> res;
                String filedKey;
                Object value;
                Cell newCell = newRow.createCell(j);
                CellStyle cellStyle = styleBase instanceof Duplicatable ? (CellStyle)((Duplicatable)styleBase).copy() : sXSSFSheet.getWorkbook().createCellStyle();
                cellStyle.setWrapText(true);
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
                if (!descKeyMap.containsKey(headerRow.getCell(j).getStringCellValue()) || BeanUtils.isEmpty((Object)(value = data.get(filedKey = ((String)descKeyMap.get(headerRow.getCell(j).getStringCellValue())).replaceAll("\\.", ""))))) continue;
                if (filedFormat.containsKey(filedKey) && filedFormat.get(filedKey).containsKey(value.toString())) {
                    value = filedFormat.get(filedKey).get(value.toString());
                }
                if (value instanceof Double) {
                    res = (Double)value;
                    BigDecimal b = new BigDecimal((Double)res);
                    cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"0.00"));
                    newCell.setCellValue(b.setScale(2, RoundingMode.HALF_UP).doubleValue());
                } else if (value instanceof BigDecimal) {
                    res = (BigDecimal)value;
                    cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"0.00"));
                    newCell.setCellValue(((BigDecimal)res).doubleValue());
                } else if (value instanceof Integer) {
                    res = (Integer)value;
                    cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"0"));
                    newCell.setCellValue((double)((Integer)res).intValue());
                } else if (value instanceof Timestamp) {
                    res = (Timestamp)value;
                    cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"m/d/yy h:mm"));
                    newCell.setCellValue(((Timestamp)res).toLocalDateTime());
                } else if (value instanceof LocalDateTime) {
                    res = (LocalDateTime)value;
                    cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"m/d/yy h:mm"));
                    newCell.setCellValue(res);
                } else if (value instanceof LocalDate) {
                    res = (LocalDate)value;
                    cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"m/d/yy"));
                    newCell.setCellValue(res);
                } else {
                    newCell.setCellValue(value.toString());
                }
                newCell.setCellStyle(cellStyle);
            }
        }
    }

    public static <T> void exportData(HttpServletResponse response, String ignoreFields, List<T> datas, Class<T> cla) throws Exception {
        List<Object> ignoreFieldList = new ArrayList();
        if (StringUtil.isNotEmpty((String)ignoreFields)) {
            ignoreFieldList = Arrays.asList(ignoreFields.split(","));
        }
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        List allField = ReflectUtil.getAllField(cla);
        for (Object field : allField) {
            boolean isDBFiled;
            ApiModelProperty property = ((Field)field).getAnnotation(ApiModelProperty.class);
            TableId tableId = ((Field)field).getAnnotation(TableId.class);
            TableField tableField = ((Field)field).getAnnotation(TableField.class);
            boolean bl = isDBFiled = tableId != null || tableField != null && StringUtil.isNotEmpty((String)tableField.value());
            if (property == null || !isDBFiled || ignoreFieldList.contains(((Field)field).getName())) continue;
            exportMap.put(((Field)field).getName(), property.value());
        }
        ArrayList<Map> list = new ArrayList<Map>();
        if (BeanUtils.isNotEmpty(datas)) {
            for (Object t : datas) {
                list.add(JsonUtil.toMap((String)JsonUtil.toJson(t)));
            }
        }
        ApiModel annotation = cla.getAnnotation(ApiModel.class);
        HSSFWorkbook exportFile = ExcelUtil.exportExcel(annotation.description(), list.size(), exportMap, list);
        ExcelUtil.downloadExcel((Workbook)exportFile, annotation.description() + "_\u5bfc\u51fa\u6570\u636e", response);
    }

    public static <T> List<T> resolveData(MultipartFile file, Class<T> cla) throws Exception {
        List<Map<String, String>> data = ExcelUtil.ImportDate(file);
        LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>();
        List allField = ReflectUtil.getAllField(cla);
        for (Field field : allField) {
            ApiModelProperty property = field.getAnnotation(ApiModelProperty.class);
            if (property == null) continue;
            propMap.put(property.value(), field.getName());
        }
        ArrayList<Object> dataList = new ArrayList<Object>();
        if (BeanUtils.isNotEmpty(data)) {
            for (Map<String, String> map : data) {
                HashMap newMap = new HashMap();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!propMap.containsKey(entry.getKey())) continue;
                    newMap.put(propMap.get(entry.getKey()), entry.getValue());
                }
                dataList.add(JsonUtil.toBean((String)JsonUtil.toJson(newMap), cla));
            }
        }
        return dataList;
    }
}

