/*
 * Decompiled with CFR 0.152.
 */
package poi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import poi.DefaultExcelStyle;
import poi.Excel;
import poi.editor.listener.CellValueListener;

public final class ExcelContext {
    private Map<Integer, HSSFCellStyle> styleCache = new HashMap<Integer, HSSFCellStyle>();
    private Map<Integer, HSSFFont> fontCache = new HashMap<Integer, HSSFFont>();
    private Map<HSSFSheet, HSSFPatriarch> patriarchCache = new HashMap<HSSFSheet, HSSFPatriarch>();
    private HSSFWorkbook workBook;
    private HSSFCellStyle tempCellStyle;
    private HSSFFont tempFont;
    private Excel excel;
    private HSSFSheet workingSheet;
    private DefaultExcelStyle defaultStyle;
    private int workingSheetIndex = 0;
    private Map<Integer, List<CellValueListener>> cellValueListener;

    protected ExcelContext(Excel excel, HSSFWorkbook workBook) {
        this.workBook = workBook;
        short numStyle = (short)workBook.getNumCellStyles();
        for (short i = 0; i < numStyle; i = (short)(i + 1)) {
            HSSFCellStyle style = workBook.getCellStyleAt((int)i);
            if (style == this.tempCellStyle) continue;
            this.styleCache.put(style.hashCode() - style.getIndex(), style);
        }
        short numFont = workBook.getNumberOfFonts();
        for (short i = 0; i < numFont; i = (short)(i + 1)) {
            HSSFFont font = workBook.getFontAt(i);
            if (font == this.tempFont) continue;
            this.fontCache.put(font.hashCode() - font.getIndex(), font);
        }
    }

    public HSSFWorkbook getWorkBook() {
        return this.workBook;
    }

    public void setWorkBook(HSSFWorkbook workBook) {
        this.workBook = workBook;
    }

    public HSSFCellStyle getTempCellStyle() {
        return this.tempCellStyle;
    }

    public void setTempCellStyle(HSSFCellStyle tempCellStyle) {
        this.tempCellStyle = tempCellStyle;
    }

    public HSSFFont getTempFont() {
        return this.tempFont;
    }

    public void setTempFont(HSSFFont tempFont) {
        this.tempFont = tempFont;
    }

    public HSSFSheet getWorkingSheet() {
        return this.workingSheet;
    }

    public void setWorkingSheet(HSSFSheet workingSheet) {
        this.workingSheet = workingSheet;
        this.workingSheetIndex = this.workBook.getSheetIndex((Sheet)workingSheet);
    }

    public HSSFPatriarch getHSSFPatriarch(HSSFSheet sheet) {
        HSSFPatriarch patr = null;
        try {
            patr = this.patriarchCache.get(sheet);
            if (patr == null) {
                patr = sheet.createDrawingPatriarch();
                this.patriarchCache.put(sheet, patr);
            }
        }
        catch (Exception e) {
            patr = sheet.createDrawingPatriarch();
        }
        return patr;
    }

    public void setDefaultStyle(DefaultExcelStyle defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public DefaultExcelStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public int getWorkingSheetIndex() {
        return this.workingSheetIndex;
    }

    public void setStyleCache(Map<Integer, HSSFCellStyle> styleCache) {
        this.styleCache = styleCache;
    }

    public Map<Integer, HSSFCellStyle> getStyleCache() {
        return this.styleCache;
    }

    public void setFontCache(Map<Integer, HSSFFont> fontCache) {
        this.fontCache = fontCache;
    }

    public Map<Integer, HSSFFont> getFontCache() {
        return this.fontCache;
    }

    private Map<Integer, List<CellValueListener>> getCellValueListener() {
        if (this.cellValueListener == null) {
            this.cellValueListener = new HashMap<Integer, List<CellValueListener>>();
        }
        return this.cellValueListener;
    }

    public List<CellValueListener> getListenerList(int sheetIndex) {
        Map<Integer, List<CellValueListener>> map = this.getCellValueListener();
        List<CellValueListener> listenerList = map.get(sheetIndex);
        if (listenerList == null) {
            listenerList = new ArrayList<CellValueListener>();
            map.put(sheetIndex, listenerList);
        }
        return listenerList;
    }

    public Excel getExcel() {
        return this.excel;
    }
}

