/*
 * Decompiled with CFR 0.152.
 */
package poi.easypoi.style;

import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.export.styler.AbstractExcelExportStyler;
import cn.afterturn.easypoi.excel.export.styler.IExcelExportStyler;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import poi.style.BorderStyle;

public class CustomExcelExportStyler
extends AbstractExcelExportStyler
implements IExcelExportStyler {
    protected Workbook workbook;
    private CellStyle headerStyle;
    private CellStyle titleStyle;
    private CellStyle styles;
    protected static final short STRING_FORMAT = (short)BuiltinFormats.getBuiltinFormat((String)"TEXT");

    public CustomExcelExportStyler(Workbook workbook) {
        this.headerStyle = this.initHeaderStyle(workbook);
        this.titleStyle = this.initTitleStyle(workbook);
        this.styles = this.initDataStyle(workbook);
    }

    protected void createStyles(Workbook workbook) {
        this.workbook = workbook;
    }

    public CellStyle getHeaderStyle(short headerColor) {
        return this.headerStyle;
    }

    public CellStyle getTitleStyle(short color) {
        return this.titleStyle;
    }

    public CellStyle getStyles(boolean parity, ExcelExportEntity entity) {
        return this.styles;
    }

    public CellStyle getStyles(Cell cell, int dataRow, ExcelExportEntity entity, Object obj, Object data) {
        return this.getStyles(true, entity);
    }

    private CellStyle initHeaderStyle(Workbook workbook) {
        CellStyle style = this.getBaseCellStyle(workbook);
        style.setFont(this.getFont(workbook, (short)14, true));
        return style;
    }

    private CellStyle initTitleStyle(Workbook workbook) {
        CellStyle style = this.getBaseCellStyle(workbook);
        style.setFont(this.getFont(workbook, (short)14, false));
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return style;
    }

    private CellStyle initDataStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN.getBorderType());
        style.setBorderLeft(BorderStyle.THIN.getBorderType());
        style.setBorderTop(BorderStyle.THIN.getBorderType());
        style.setBorderRight(BorderStyle.THIN.getBorderType());
        style.setFont(this.getFont(workbook, (short)12, false));
        return style;
    }

    private CellStyle getBaseCellStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setDataFormat(STRING_FORMAT);
        style.setBorderBottom(BorderStyle.THIN.getBorderType());
        style.setBorderLeft(BorderStyle.THIN.getBorderType());
        style.setBorderTop(BorderStyle.THIN.getBorderType());
        style.setBorderRight(BorderStyle.THIN.getBorderType());
        style.setWrapText(true);
        return style;
    }

    private Font getFont(Workbook workbook, short size, boolean isBold) {
        Font font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setBold(isBold);
        font.setFontHeightInPoints(size);
        return font;
    }
}

