/*
 * Decompiled with CFR 0.152.
 */
package poi.easypoi.util;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;
import poi.easypoi.style.CustomExcelExportStyler;

public class ExcelUtils {
    public static final int DEFAULT_COLUMN_WIDTH = 12800;

    public static Workbook exportExcel(String title, Map<String, String> fieldMap, List<Map<String, Object>> data) throws Exception {
        ExportParams exportParams = new ExportParams(null, title);
        exportParams.setCreateHeadRows(true);
        exportParams.setStyle(CustomExcelExportStyler.class);
        ArrayList<ExcelExportEntity> entityList = new ArrayList<ExcelExportEntity>();
        for (String key : fieldMap.keySet()) {
            ExcelExportEntity excelExportEntity = new ExcelExportEntity();
            excelExportEntity.setKey((Object)key);
            excelExportEntity.setName(fieldMap.get(key));
            entityList.add(excelExportEntity);
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entityList, data);
        for (int i = 0; i < fieldMap.size(); ++i) {
            workbook.getSheetAt(0).setColumnWidth(i, 12800);
        }
        return workbook;
    }

    public static Workbook exportExcel(String title, Class<?> pojoClass, Collection<?> data) throws Exception {
        ExportParams exportParams = new ExportParams(null, title);
        exportParams.setCreateHeadRows(true);
        exportParams.setStyle(CustomExcelExportStyler.class);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, pojoClass, data);
        return workbook;
    }
}

