/*
 * Decompiled with CFR 0.152.
 */
package poi.editor;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.util.CellRangeAddress;
import poi.ExcelContext;
import poi.editor.AbstractRegionEditor;
import poi.editor.CellEditor;

public class RegionEditor
extends AbstractRegionEditor<RegionEditor> {
    private CellRangeAddress cellRange;

    public RegionEditor(int beginRow, int beginCol, int endRow, int endCol, ExcelContext context) {
        super(context);
        this.cellRange = new CellRangeAddress(beginRow, endRow, beginCol, endCol);
    }

    public RegionEditor(CellRangeAddress cellRange, ExcelContext context) {
        super(context);
        this.cellRange = cellRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionEditor image(String imgPath) {
        ByteArrayOutputStream byteArrayOut = null;
        BufferedImage bufferImg = null;
        try {
            if (imgPath.startsWith("http")) {
                URL url = new URL(imgPath);
                URLConnection conn = url.openConnection();
                bufferImg = ImageIO.read(conn.getInputStream());
            } else {
                bufferImg = ImageIO.read(new File(imgPath));
            }
            HSSFClientAnchor anchor = new HSSFClientAnchor(10, 10, 0, 0, (short)this.cellRange.getFirstColumn(), this.cellRange.getFirstRow(), (short)(this.cellRange.getLastColumn() + 1), this.cellRange.getLastRow() + 1);
            anchor.setAnchorType(ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE);
            HSSFPatriarch patr = this.ctx.getHSSFPatriarch(this.workingSheet);
            byteArrayOut = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferImg, "JPEG", byteArrayOut);
            int imageIndex = this.workBook.addPicture(byteArrayOut.toByteArray(), 5);
            patr.createPicture(anchor, imageIndex);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (byteArrayOut != null) {
                try {
                    byteArrayOut.close();
                }
                catch (Exception e) {}
            }
        }
        return this;
    }

    @Override
    protected CellEditor newCellEditor() {
        CellEditor cellEditor = new CellEditor(this.ctx);
        for (int i = this.cellRange.getFirstRow(); i <= this.cellRange.getLastRow(); ++i) {
            for (int j = this.cellRange.getFirstColumn(); j <= this.cellRange.getLastColumn(); ++j) {
                cellEditor.add(i, j);
            }
        }
        return cellEditor;
    }

    @Override
    protected CellEditor newBottomCellEditor() {
        CellEditor cellEditorBottom = new CellEditor(this.ctx);
        for (int i = this.cellRange.getFirstColumn(); i <= this.cellRange.getLastColumn(); ++i) {
            cellEditorBottom.add(this.cellRange.getLastRow(), i);
        }
        return cellEditorBottom;
    }

    @Override
    protected CellEditor newLeftCellEditor() {
        CellEditor cellEditorLeft = new CellEditor(this.ctx);
        for (int i = this.cellRange.getFirstRow(); i <= this.cellRange.getLastRow(); ++i) {
            cellEditorLeft.add(i, this.cellRange.getFirstColumn());
        }
        return cellEditorLeft;
    }

    @Override
    protected CellEditor newRightCellEditor() {
        CellEditor cellEditorRight = new CellEditor(this.ctx);
        for (int i = this.cellRange.getFirstRow(); i <= this.cellRange.getLastRow(); ++i) {
            cellEditorRight.add(i, this.cellRange.getLastColumn());
        }
        return cellEditorRight;
    }

    @Override
    protected CellEditor newTopCellEditor() {
        CellEditor cellEditorTop = new CellEditor(this.ctx);
        for (int i = this.cellRange.getFirstColumn(); i <= this.cellRange.getLastColumn(); ++i) {
            cellEditorTop.add(this.cellRange.getFirstRow(), i);
        }
        return cellEditorTop;
    }

    @Override
    protected CellRangeAddress getCellRange() {
        return this.cellRange;
    }
}

