/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.sys.persistence.manager.DataDictManager;
import com.hotent.sys.persistence.manager.SysTypeManager;
import com.hotent.sys.persistence.model.DataDict;
import com.hotent.sys.persistence.model.SysType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sys/dataDict/v1"})
@Api(tags={"\u6570\u636e\u5b57\u5178"})
@ApiGroup(group={"group_portal"})
public class DataDictController
extends BaseController<DataDictManager, DataDict> {
    @Resource
    DataDictManager dataDictManager;
    @Resource
    SysTypeManager sysTypeManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5b57\u5178\u5217\u8868", httpMethod="POST", notes="\u5b57\u5178\u5217\u8868")
    @ResponseBody
    public PageList<DataDict> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<DataDict> queryFilter) throws Exception {
        return this.dataDictManager.listJson(queryFilter);
    }

    @RequestMapping(value={"movePosition"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u79fb\u52a8\u5b57\u5178\u4f4d\u7f6e", httpMethod="POST", notes="\u5b57\u5178\u5217\u8868")
    @ResponseBody
    public CommonResult<String> movePosition(@ApiParam(name="params", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody Map<String, String> params) throws Exception {
        return this.dataDictManager.movePosition(params);
    }

    @RequestMapping(value={"dataDictEdit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u5b57\u5178\u4fe1\u606f\u9875\u9762", httpMethod="GET", notes="\u7f16\u8f91\u6570\u636e\u5b57\u5178\u4fe1\u606f\u9875\u9762")
    public Map<String, Object> edit(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id, @ApiParam(name="isAdd", value="\u662f\u5426\u662f\u6dfb\u52a0") @RequestParam int isAdd, @ApiParam(name="isRoot", value="\u662f\u5426\u662f\u6839\u8282\u70b9", required=false) @RequestParam int isRoot) throws Exception {
        return this.dataDictManager.edit(id, Integer.valueOf(isAdd), Integer.valueOf(isRoot));
    }

    @RequestMapping(value={"getByTypeId"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178", httpMethod="POST", notes="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178")
    @ResponseBody
    public List<DataDict> getByTypeId(@ApiParam(name="typeId", value="\u5206\u7c7bid", required=true) @RequestBody String typeId) throws Exception {
        if (StringUtil.isEmpty((String)typeId)) {
            return null;
        }
        SysType dictType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        return this.dataDictManager.getDataDict(dictType, Boolean.valueOf(true));
    }

    @RequestMapping(value={"getByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bkey\u83b7\u53d6\u5b57\u5178", httpMethod="GET", notes="\u6839\u636e\u5206\u7c7bkey\u83b7\u53d6\u5b57\u5178")
    public List<DataDict> getByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bid", required=true) @RequestParam String typeKey) throws Exception {
        if (StringUtil.isEmpty((String)typeKey)) {
            return null;
        }
        SysType dictType = this.sysTypeManager.getByKey(typeKey);
        return this.dataDictManager.getDataDict(dictType, Boolean.valueOf(false));
    }

    @RequestMapping(value={"getByTypeIdForComBo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178(ComBo)", httpMethod="POST", notes="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178(ComBo)")
    public List<DataDict> getByTypeIdForComBo(@ApiParam(name="typeId", value="\u5206\u7c7bid", required=true) @RequestBody String typeId) throws Exception {
        if (StringUtil.isEmpty((String)typeId)) {
            return null;
        }
        SysType dictType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        List list = this.dataDictManager.getDataDict(dictType, Boolean.valueOf(false));
        return BeanUtils.listToTree((List)list);
    }

    @RequestMapping(value={"getByTypeKeyForComBo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7groupKey\u3001typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178", httpMethod="POST", notes="\u901a\u8fc7groupKey\u3001typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178")
    public List<DataDict> getByTypeKeyForComBo(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        Locale simplifiedChinese;
        List rtnList = ((DataDictManager)this.baseService).getByTypeKeyForComBo(typeKey);
        Locale locale = LocaleContextHolder.getLocale();
        if (!locale.equals(simplifiedChinese = Locale.SIMPLIFIED_CHINESE)) {
            for (DataDict dataDict : rtnList) {
                String message;
                String key = "dictionary." + dataDict.getTypeId() + "." + dataDict.getKey();
                if (key.equals(message = I18nUtil.getMessage((String)key, (Locale)locale))) continue;
                dataDict.setName(message);
            }
        }
        return rtnList;
    }

    @RequestMapping(value={"getMoibleComBoByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178", httpMethod="GET", notes="\u901a\u8fc7typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178")
    public Map<String, Object> getMoibleComBoByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        return this.dataDictManager.getMoibleComBoByTypeKey(typeKey);
    }

    @RequestMapping(value={"dataDictGet"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u660e\u7ec6\u9875\u9762", httpMethod="POST", notes="\u6570\u636e\u5b57\u5178\u660e\u7ec6\u9875\u9762")
    public DataDict get(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestBody String id) throws Exception {
        DataDict dataDict = new DataDict();
        if (StringUtil.isNotEmpty((String)id)) {
            dataDict = (DataDict)this.dataDictManager.get((Serializable)((Object)id));
        }
        return dataDict;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="dataDict", value="\u5b57\u5178", required=true) @RequestBody DataDict dataDict) throws Exception {
        return this.dataDictManager.saveDataDict(dataDict);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u5b57\u5178", httpMethod="DELETE", notes="\u5220\u9664\u6570\u636e\u5b57\u5178")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u5b57\u5178", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.dataDictManager.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(true, "\u5220\u9664\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getDataDictByTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7b\u6570\u636e\u5b57\u5178", httpMethod="GET")
    public List<DataDict> getDataDictByType(@ApiParam(name="typeId", value="\u5b57\u5178", required=true) @RequestParam String typeId) throws Exception {
        List dataDictList = this.dataDictManager.getByTypeId(typeId);
        List rtnList = BeanUtils.listToTree((List)dataDictList);
        return rtnList;
    }

    @RequestMapping(value={"sortList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f\u5217\u8868\u9875\u9762", httpMethod="POST")
    public List<DataDict> sortList(@ApiParam(name="id", value="\u5b57\u5178", required=false, defaultValue="-1") @RequestBody String id) throws Exception {
        List dataDictList = this.dataDictManager.getFirstChilsByParentId(id);
        return dataDictList;
    }

    @RequestMapping(value={"sort"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f", httpMethod="POST")
    public CommonResult<String> sort(@ApiParam(name="dicIds", value="\u5b57\u5178", required=true) @RequestBody String[] dicIds) throws Exception {
        try {
            if (BeanUtils.isNotEmpty((Object)dicIds)) {
                for (int i = 0; i < dicIds.length; ++i) {
                    String dicId = dicIds[i];
                    int sn = i + 1;
                    this.dataDictManager.updSn(dicId, sn);
                }
            }
        }
        catch (Exception e) {
            return new CommonResult(true, "\u6392\u5e8f\u5931\u8d25");
        }
        return new CommonResult(true, "\u6392\u5e8f\u6210\u529f");
    }

    @RequestMapping(value={"removeByTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u5220\u9664\u5206\u7c7b\u4e0b\u7684\u5b57\u5178", httpMethod="GET")
    public CommonResult<String> removeByTypeIds(@ApiParam(name="typeIds", value="\u5206\u7c7bid", required=true) @RequestParam String typeIds) throws Exception {
        return this.dataDictManager.removeByTypeIds(typeIds);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u5bfc\u5165", httpMethod="POST", notes="\u6570\u636e\u5b57\u5178\u5bfc\u5165")
    public CommonResult<String> importData(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> file, @ApiParam(name="typeId", value="\u6570\u636e\u5b57\u5178\u5206\u7c7bid", required=true) @RequestParam String typeId) throws Exception {
        boolean isRepeat = this.dataDictManager.importData(file, typeId);
        if (!isRepeat) {
            return new CommonResult(true, "confirmUpload");
        }
        return new CommonResult(true, "\u5bfc\u5165\u6570\u636e\u5b57\u5178\u6210\u529f");
    }

    @RequestMapping(value={"importData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2", httpMethod="POST", notes="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2")
    public CommonResult<String> importDataConfirm(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> file, @ApiParam(name="status", value="status", required=true) @RequestParam String status, @ApiParam(name="typeId", value="\u6570\u636e\u5b57\u5178\u5206\u7c7bid", required=true) @RequestParam String typeId) throws Exception {
        CommonResult res = this.dataDictManager.importDataConfirm(file, status, typeId);
        return res;
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u5bfc\u51fa", httpMethod="GET", notes="\u6570\u636e\u5b57\u5178\u5bfc\u51fa")
    public void export(@ApiParam(name="dictId", value="\u5b57\u5178ID") @RequestParam String dictId, @ApiParam(name="typeId", value="\u7c7b\u578bID") @RequestParam String typeId, HttpServletResponse response) throws Exception {
        this.dataDictManager.export(typeId, dictId, response);
    }

    @RequestMapping(value={"dictionaries"}, method={RequestMethod.GET})
    public List<DataDict> getDictionaries(String ... alias) {
        return ((DataDictManager)this.baseService).getDictionaries(Arrays.asList(alias));
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public List<ImportCheckResult> importCheck(@RequestBody String json) throws Exception {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        List dataDicts = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<DataDict>>(){});
        this.dataDictManager.importCheck(dataDicts, dictionary -> results.add(new ImportCheckResult(true, "\u5b57\u5178", dictionary.getName())));
        return results;
    }

    @RequestMapping(value={"importData1"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult<String> importData1(@RequestBody String json, @RequestParam(value="status") String status, @RequestParam(value="typeId") String typeId) throws Exception {
        List dataDicts = (List)JsonUtil.toBean((String)json, (TypeReference)new TypeReference<List<DataDict>>(){});
        this.dataDictManager.importData(dataDicts, status, typeId);
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }
}

