/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.portal.params.dataDict.DictEditVo;
import com.hotent.portal.params.dataDict.MoibleComBoVo;
import com.hotent.sys.constants.CategoryConstants;
import com.hotent.sys.persistence.manager.DataDictManager;
import com.hotent.sys.persistence.manager.SysTypeManager;
import com.hotent.sys.persistence.model.DataDict;
import com.hotent.sys.persistence.model.SysType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import poi.util.ExcelUtil;

@RestController
@RequestMapping(value={"/sys/dataDict/v2"})
@Api(tags={"\u6570\u636e\u5b57\u51782"})
@ApiGroup(group={"group_portal"})
public class DataDictController2
extends BaseController2<DataDictManager, DataDict> {
    @Resource
    DataDictManager dataDictManager;
    @Resource
    SysTypeManager sysTypeManager;

    @RequestMapping(value={"dataDictEdit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u6570\u636e\u5b57\u5178\u4fe1\u606f\u9875\u9762", httpMethod="GET", notes="\u7f16\u8f91\u6570\u636e\u5b57\u5178\u4fe1\u606f\u9875\u9762")
    public CommonResult<DictEditVo> edit(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id, @ApiParam(name="isAdd", value="\u662f\u5426\u662f\u6dfb\u52a0") @RequestParam Integer isAdd, @ApiParam(name="isRoot", value="\u662f\u5426\u662f\u6839\u8282\u70b9", required=false) @RequestParam Integer isRoot) throws Exception {
        Map map = this.dataDictManager.edit(id, isAdd, isRoot);
        DictEditVo dictEditVo = new DictEditVo();
        dictEditVo.setIsAdd((Integer)map.get("isAdd"));
        dictEditVo.setTypeId((String)map.get("typeId"));
        dictEditVo.setParentId((String)map.get("parentId"));
        dictEditVo.setDataDict((DataDict)map.get("dataDict"));
        return CommonResult.ok().value((Object)dictEditVo);
    }

    @RequestMapping(value={"getByTypeId"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178", httpMethod="POST", notes="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178")
    @ResponseBody
    public CommonResult<List<DataDict>> getByTypeId(@ApiParam(name="typeId", value="\u5206\u7c7bid", required=true) @RequestBody String typeId) throws Exception {
        if (StringUtil.isEmpty((String)typeId)) {
            return null;
        }
        SysType dictType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        List dictList = this.dataDictManager.getDataDict(dictType, Boolean.valueOf(true));
        return CommonResult.ok().value((Object)dictList);
    }

    @RequestMapping(value={"getByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bkey\u83b7\u53d6\u5b57\u5178", httpMethod="GET", notes="\u6839\u636e\u5206\u7c7bkey\u83b7\u53d6\u5b57\u5178")
    public CommonResult<List<DataDict>> getByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bid", required=true) @RequestParam String typeKey) throws Exception {
        if (StringUtil.isEmpty((String)typeKey)) {
            return null;
        }
        SysType dictType = this.sysTypeManager.getByKey(typeKey);
        List dictList = this.dataDictManager.getDataDict(dictType, Boolean.valueOf(false));
        return CommonResult.ok().value((Object)dictList);
    }

    @RequestMapping(value={"getByTypeIdForComBo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178(ComBo)", httpMethod="POST", notes="\u6839\u636e\u5206\u7c7bid\u83b7\u53d6\u5b57\u5178(ComBo)")
    public CommonResult<List<DataDict>> getByTypeIdForComBo(@ApiParam(name="typeId", value="\u5206\u7c7bid", required=true) @RequestBody String typeId) throws Exception {
        if (StringUtil.isEmpty((String)typeId)) {
            return null;
        }
        SysType dictType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        List list = this.dataDictManager.getDataDict(dictType, Boolean.valueOf(false));
        List rtnList = BeanUtils.listToTree((List)list);
        return CommonResult.ok().value((Object)rtnList);
    }

    @RequestMapping(value={"getByTypeKeyForComBo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7groupKey\u3001typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178", httpMethod="POST", notes="\u901a\u8fc7groupKey\u3001typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178")
    public CommonResult<List<DataDict>> getByTypeKeyForComBo(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        Locale simplifiedChinese;
        if (StringUtil.isEmpty((String)typeKey)) {
            return null;
        }
        SysType dictType = this.sysTypeManager.getByTypeKeyAndGroupKey(CategoryConstants.CAT_DIC.key(), typeKey);
        List list = this.dataDictManager.getDataDict(dictType, Boolean.valueOf(false));
        List rtnList = BeanUtils.listToTree((List)list);
        Locale locale = LocaleContextHolder.getLocale();
        if (!locale.equals(simplifiedChinese = Locale.SIMPLIFIED_CHINESE)) {
            for (DataDict dataDict : rtnList) {
                String message;
                String key = "dictionary." + dataDict.getTypeId() + "." + dataDict.getKey();
                if (key.equals(message = I18nUtil.getMessage((String)key, (Locale)locale))) continue;
                dataDict.setName(message);
            }
        }
        return CommonResult.ok().value((Object)rtnList);
    }

    @RequestMapping(value={"getMoibleComBoByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178", httpMethod="GET", notes="\u901a\u8fc7typeKey\u83b7\u53d6\u6570\u636e\u5b57\u5178")
    public CommonResult<MoibleComBoVo> getMoibleComBoByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        if (StringUtil.isEmpty((String)typeKey)) {
            return CommonResult.ok().message("\u6682\u65e0\u6570\u636e\uff01");
        }
        SysType dictType = this.sysTypeManager.getByTypeKeyAndGroupKey(CategoryConstants.CAT_DIC.key(), typeKey);
        List list = this.dataDictManager.getDataDict(dictType, Boolean.valueOf(false));
        List rtnList = BeanUtils.listToTree((List)list);
        MoibleComBoVo moibleComBoVo = new MoibleComBoVo();
        moibleComBoVo.setDictType(dictType);
        moibleComBoVo.setDataDictList(rtnList);
        return CommonResult.ok().value((Object)moibleComBoVo);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6570\u636e\u5b57\u5178\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="dataDict", value="\u5b57\u5178", required=true) @RequestBody DataDict dataDict) throws Exception {
        CommonResult commonResult = this.dataDictManager.saveDataDict(dataDict);
        return CommonResultUtil.getResult((CommonResult)commonResult);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u5b57\u5178", httpMethod="DELETE", notes="\u5220\u9664\u6570\u636e\u5b57\u5178")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u5b57\u5178", required=true) @RequestParam String id) throws Exception {
        String[] aryIds = StringUtil.getStringAryByStr((String)id);
        this.dataDictManager.removeByIds(aryIds);
        return CommonResult.ok().message("\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"getDataDictByTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7b\u6570\u636e\u5b57\u5178", httpMethod="GET")
    public CommonResult<List<DataDict>> getDataDictByType(@ApiParam(name="typeId", value="\u5b57\u5178", required=true) @RequestParam String typeId) throws Exception {
        List dataDictList = this.dataDictManager.getByTypeId(typeId);
        List rtnList = BeanUtils.listToTree((List)dataDictList);
        return CommonResult.ok().value((Object)rtnList);
    }

    @RequestMapping(value={"sortList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f\u5217\u8868\u9875\u9762", httpMethod="POST")
    public CommonResult<List<DataDict>> sortList(@ApiParam(name="id", value="\u5b57\u5178\u7236Id", required=false, defaultValue="-1") @RequestParam String id) throws Exception {
        List dataDictList = this.dataDictManager.getFirstChilsByParentId(id);
        return CommonResult.ok().value((Object)dataDictList);
    }

    @RequestMapping(value={"sort"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f", httpMethod="POST")
    public CommonResult<String> sort(@ApiParam(name="dicIds", value="\u5b57\u5178", required=true) @RequestBody String[] dicIds) throws Exception {
        CommonResult commonResult = this.dataDictManager.sort(dicIds);
        return CommonResultUtil.getResult((CommonResult)commonResult);
    }

    @RequestMapping(value={"removeByTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u5220\u9664\u5206\u7c7b\u4e0b\u7684\u5b57\u5178", httpMethod="GET")
    public CommonResult<String> removeByTypeIds(@ApiParam(name="typeIds", value="\u5206\u7c7bid", required=true) @RequestParam String typeIds) throws Exception {
        CommonResult commonResult = this.dataDictManager.removeByTypeIds(typeIds);
        return CommonResultUtil.getResult((CommonResult)commonResult);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u5bfc\u5165", httpMethod="POST", notes="\u6570\u636e\u5b57\u5178\u5bfc\u5165")
    public CommonResult<String> importData(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> file, @ApiParam(name="typeId", value="\u6570\u636e\u5b57\u5178\u5206\u7c7bid", required=true) @RequestParam String typeId) throws Exception {
        this.dataDictManager.importData(file, typeId);
        return CommonResult.ok().message("\u5bfc\u5165\u6570\u636e\u5b57\u5178\u6210\u529f");
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u5bfc\u51fa", httpMethod="GET", notes="\u6570\u636e\u5b57\u5178\u5bfc\u51fa")
    public void export(@ApiParam(name="typeId", value="\u7c7b\u578bID") @RequestParam String typeId, HttpServletResponse response) throws Exception {
        SysType sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        List dataDict = this.dataDictManager.getDataDict(sysType, Boolean.valueOf(true));
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        exportMap.put("parentKey", "\u7236\u8282\u70b9key");
        exportMap.put("typeKey", "\u5206\u7c7bkey");
        exportMap.put("typeName", "\u5206\u7c7b\u540d\u79f0");
        ArrayList list = new ArrayList();
        for (DataDict dict : dataDict) {
            if (StringUtil.isEmpty((String)dict.getKey())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("parentKey", this.getKeyFromList(dict.getParentId(), dataDict));
            map.put("typeKey", dict.getKey());
            map.put("typeName", dict.getName());
            list.add(map);
        }
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u6570\u636e\u5b57\u5178", (int)dataDict.size(), exportMap, list);
        ExcelUtil.downloadExcel((Workbook)exportFile, (String)"\u5b57\u5178\u5bfc\u51fa", (HttpServletResponse)response);
    }

    private String getKeyFromList(String id, List<DataDict> list) {
        if (StringUtil.isEmpty((String)id)) {
            return "";
        }
        for (DataDict dataDict : list) {
            if (!id.equals(dataDict.getId())) continue;
            return dataDict.getKey();
        }
        return "";
    }
}

