/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.hotent.base.controller.BaseController2;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.portal.model.Popup;
import com.hotent.portal.persistence.manager.PopupManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portal/portalSysPopup/v2"})
public class PopupController2
extends BaseController2<PopupManager, Popup> {
    @Autowired
    PopupManager popupManager;

    @GetMapping(value={"getCurrentUserPopup"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5f39\u7a97", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5f39\u7a97")
    public CommonResult<List<Popup>> getCurrentUserPopup() throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        List<Popup> authList = ((PopupManager)this.baseService).authList(userId);
        List<Popup> popupList = ((PopupManager)this.baseService).filterData(authList, userId);
        return CommonResult.ok().value(popupList);
    }

    @PostMapping(value={"saveWithAuth"})
    @ApiOperation(value="\u4fdd\u5b58\u5f39\u7a97\u5e76\u6dfb\u52a0\u4e00\u4e2a\u6240\u6709\u4eba\u7684\u6388\u6743", httpMethod="POST", notes="\u4fdd\u5b58\u5f39\u7a97\u63d0\u9192")
    public CommonResult<String> saveWithAuth(@ApiParam(name="\u5f39\u7a97\u63d0\u9192", value="POPUP") @RequestBody Popup popup) throws Exception {
        boolean result = ((PopupManager)this.baseService).saveWithAuth(popup);
        if (!result) {
            return CommonResult.result((ResponseErrorEnums)ResponseErrorEnums.FAIL_OPTION);
        }
        return CommonResult.ok();
    }

    @GetMapping(value={"validateSql"})
    @ApiOperation(value="\u9a8c\u8bc1sql\u8bed\u53e5", httpMethod="GET", notes="\u9a8c\u8bc1sql\u8bed\u53e5")
    public CommonResult<String> validateSql(@ApiParam(name="SQL\u8bed\u53e5(base64)", value="sql") @RequestParam String sql, @ApiParam(name="\u6570\u636e\u6e90", value="dsAlias") @RequestParam String dsAlias) throws Exception {
        CommonResult<String> commonResult = this.popupManager.validateSql(sql, dsAlias);
        return CommonResultUtil.getResult(commonResult);
    }

    @PostMapping(value={"exportPopup"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5f39\u7a97\u63d0\u9192", httpMethod="POST", notes="\u5bfc\u51fa\u5f39\u7a97\u63d0\u9192")
    public void exportPopup(@ApiParam(name="ids", value="\u8981\u5bfc\u51fa\u7684id") @RequestBody List<String> ids, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = "popup_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MM_dd_HHmm");
        String json = ((PopupManager)this.baseService).exportPopup(ids);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"popup.json", (String)fileName);
    }

    @PostMapping(value={"importPopup"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5f39\u7a97\u63d0\u9192", httpMethod="POST", notes="\u5bfc\u5165\u5f39\u7a97\u63d0\u9192")
    public CommonResult<String> importPopup(@ApiParam(name="confirmImport", value="\u786e\u8ba4\u5bfc\u5165") @RequestParam Optional<Boolean> confirmImport, @ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u6d41\u7a0b\u6587\u4ef6id") @RequestParam Optional<String> cacheFileId) throws Exception {
        CommonResult<String> commonResult = this.popupManager.importPopup(confirmImport, cacheFileId);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5f39\u7a97\u524d\u6821\u9a8c", httpMethod="POST", notes="\u5bfc\u5165\u5f39\u7a97\u524d\u6821\u9a8c")
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.popupManager.importCheck(request, response);
    }
}

