/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.portal.params.TemplateToMenuVo;
import com.hotent.sys.constants.FrontTypeConstant;
import com.hotent.sys.persistence.manager.SysMenuManager;
import com.hotent.sys.persistence.manager.SysMethodManager;
import com.hotent.sys.persistence.model.SysMenu;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/sys/sysMenu/v1"})
@Api(tags={"\u7cfb\u7edf\u83dc\u5355"})
@ApiGroup(group={"group_portal"})
public class SysMenuController
extends BaseController<SysMenuManager, SysMenu> {
    @Resource
    SysMenuManager sysMenuManager;
    @Resource
    SysMethodManager sysMethodManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u8d44\u6e90\u6570\u636e", httpMethod="POST", notes="\u83dc\u5355\u8d44\u6e90\u6570\u636e")
    public PageList<SysMenu> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysMenu> queryFilter) throws Exception {
        return this.sysMenuManager.query(queryFilter);
    }

    @RequestMapping(value={"getTree"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u6811\u5f62\u83dc\u5355", httpMethod="GET", notes="\u83b7\u5f97\u6811\u5f62\u83dc\u5355")
    public List<SysMenu> getTree(@ApiParam(name="ignoreAlias", value="\u5ffd\u7565\u83dc\u5355\uff08\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00\uff09", required=true) @RequestParam Optional<String> ignoreAlias) throws Exception {
        List list = this.sysMenuManager.getAllByTenant(ignoreAlias.orElse(""));
        list = BeanUtils.listToTree((List)list);
        return list;
    }

    @RequestMapping(value={"getList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u6811\u5f62\u83dc\u5355", httpMethod="GET", notes="\u83b7\u5f97\u6811\u5f62\u83dc\u5355")
    public List<SysMenu> getList(@ApiParam(name="ignoreAlias", value="\u5ffd\u7565\u83dc\u5355\uff08\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00\uff09", required=true) @RequestParam Optional<String> ignoreAlias) throws Exception {
        return this.sysMenuManager.getAllByTenant(ignoreAlias.orElse(""));
    }

    @RequestMapping(value={"saveMenus"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8d44\u6e90\u83dc\u5355", httpMethod="POST", notes="\u4fdd\u5b58\u8d44\u6e90\u83dc\u5355")
    public CommonResult<String> saveMenus(@ApiParam(name="list", value="\u83dc\u5355\u5217\u8868") @RequestBody List<SysMenu> list) throws Exception {
        CommonResult res = this.sysMenuManager.saveMenus(list);
        return res;
    }

    @RequestMapping(value={"getMenuByRoleAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u89d2\u8272\u6811\u5f62\u83dc\u5355", httpMethod="GET", notes="\u83b7\u5f97\u89d2\u8272\u6811\u5f62\u83dc\u5355")
    public List<SysMenu> getMenuByRoleAlias(@ApiParam(name="roleAlias", value="\u89d2\u8272\u522b\u540d", required=true) @RequestParam String roleAlias) throws Exception {
        return this.sysMenuManager.getMenuByRoleAlias(roleAlias);
    }

    @RequestMapping(value={"getAllMenuRoleAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u89d2\u8272\u6811\u5f62\u83dc\u5355", httpMethod="GET", notes="\u83b7\u5f97\u89d2\u8272\u6811\u5f62\u83dc\u5355")
    public List<SysMenu> getAllMenuRoleAlias(@ApiParam(name="roleAlias", value="\u89d2\u8272\u522b\u540d", required=true) @RequestParam String roleAlias) throws Exception {
        return this.sysMenuManager.getAllMenuRoleAlias(roleAlias);
    }

    @RequestMapping(value={"getAllMethodByRoleAlias"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6388\u6743\u7684\u540e\u53f0\u65b9\u6cd5", httpMethod="POST", notes="\u83b7\u53d6\u6388\u6743\u7684\u540e\u53f0\u65b9\u6cd5")
    public ArrayList<Map<String, Object>> getAllMethodByRoleAlias(@ApiParam(name="roleAlias", value="\u89d2\u8272\u522b\u540d", required=true) @RequestParam String roleAlias) throws Exception {
        return (ArrayList)this.sysMethodManager.getAllMethodByRoleAlias(roleAlias);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u8d44\u6e90\u6570\u636e\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u83dc\u5355\u8d44\u6e90\u6570\u636e\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public SysMenu getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return this.sysMenuManager.getJson(id);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u83dc\u5355\u8d44\u6e90\u6570\u636e\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u83dc\u5355\u8d44\u6e90\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysMenu", value="\u83dc\u5355\u8d44\u6e90", required=true) @RequestBody SysMenu sysMenu, @ApiParam(name="parentId", value="\u7236\u8282\u70b9id", required=true) @RequestParam Optional<String> parentId) throws Exception {
        CommonResult res = this.sysMenuManager.saveMenus(sysMenu, parentId);
        return res;
    }

    @RequestMapping(value={"saveBatch"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u83dc\u5355\u8d44\u6e90\u6570\u636e\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u83dc\u5355\u8d44\u6e90\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> saveBatch(@ApiParam(name="list", value="\u83dc\u5355\u8d44\u6e90", required=true) @RequestBody List<SysMenu> list) throws Exception {
        CommonResult res = this.sysMenuManager.saveDataByBatch(list);
        return res;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u83dc\u5355\u4fe1\u606f\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u83dc\u5355\u4fe1\u606f\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="id", value="\u5f3a\u5236\u5220\u9664", required=false) @RequestParam(required=false) boolean force) throws Exception {
        try {
            this.sysMenuManager.removeByResId(id, force);
        }
        catch (BaseException e) {
            if (ResponseErrorEnums.FAIL_OPTION.getCode().equals(e.getCode())) {
                CommonResult result = new CommonResult(true, e.getMessage());
                result.setErrorCode(ResponseErrorEnums.FAIL_OPTION.getCode());
                return result;
            }
            throw e;
        }
        return new CommonResult(true, "\u5220\u9664\u83dc\u5355\u4fe1\u606f\u6210\u529f");
    }

    @RequestMapping(value={"isMenuExistByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u6d4b\u83dc\u5355\u8d44\u6e90\u522b\u540d\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="GET", notes="\u68c0\u6d4b\u83dc\u5355\u8d44\u6e90\u522b\u540d\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    @ResponseBody
    public CommonResult<Boolean> isMenuExistByAlias(@ApiParam(name="alias", value="\u83dc\u5355\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        boolean existByAlias = this.sysMenuManager.isExistByAlias(alias);
        CommonResult commonResult = new CommonResult();
        commonResult.setValue((Object)existByAlias);
        return commonResult;
    }

    @RequestMapping(value={"isMethodExistByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u6d4b\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="GET", notes="\u68c0\u6d4b\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    @ResponseBody
    public CommonResult<Boolean> isMethodExistByAlias(@ApiParam(name="alias", value="\u83dc\u5355\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        boolean existByAlias = this.sysMethodManager.isExistByAlias(alias);
        CommonResult commonResult = new CommonResult();
        commonResult.setValue((Object)existByAlias);
        return commonResult;
    }

    @RequestMapping(value={"getCurrentUserMenu"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355")
    @ResponseBody
    public CommonResult<List<SysMenu>> getCurrentUserMenu(@ApiParam(name="menuAlias", value="\u83dc\u5355\u7c7b\u578b", required=true) @RequestParam String menuAlias, @ApiParam(name="filterMenuAlias", value="\u8fc7\u6ee4\u6389\u7684\u83dc\u5355\u53ca\u5176\u5b50\u83dc\u5355\uff0c\u7528\u9017\u53f7\u5206\u5272", required=true) @RequestParam(required=false) String filterMenuAlias, @ApiParam(name="isNeedTop", value="\u662f\u5426\u9700\u8981\u9876\u7ea7\u83dc\u5355") @RequestParam(required=false) Boolean isNeedTop) throws Exception {
        CommonResult commonResult = new CommonResult(true, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u83dc\u5355\u4fe1\u606f");
        List lists = this.sysMenuManager.getCurrentUserMenu();
        lists = this.sysMenuManager.i18nSysMenu(lists);
        HashSet filterMenuAliasSet = StringUtil.isNotEmpty((String)filterMenuAlias) ? Arrays.stream(filterMenuAlias.split(",")).collect(Collectors.toSet()) : Sets.newHashSet();
        List result = this.sysMenuManager.filterByMenuAlias(menuAlias, lists, (Set)filterMenuAliasSet);
        if (BeanUtils.isNotEmpty((Object)isNeedTop) && isNeedTop.booleanValue()) {
            result = this.sysMenuManager.setTopMenu(result);
        }
        commonResult.setValue((Object)result);
        return commonResult;
    }

    @RequestMapping(value={"getAppCenterMenu"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5e94\u7528\u5206\u7c7b\u83dc\u5355", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5e94\u7528\u5206\u7c7b\u83dc\u5355")
    @ResponseBody
    public CommonResult<List<SysMenu>> getAppCenterMenu(@ApiParam(name="menuAlias", value="\u83dc\u5355\u7c7b\u578b", required=true) @RequestParam String menuAlias) throws Exception {
        CommonResult commonResult = new CommonResult(true, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u83dc\u5355\u4fe1\u606f");
        List lists = null;
        lists = "appCenter".equals(menuAlias) ? this.sysMenuManager.getAll() : this.sysMenuManager.getCurrentUserMenu();
        lists = this.sysMenuManager.i18nSysMenu(lists);
        List result = this.sysMenuManager.filterByAppCenter(menuAlias, lists);
        commonResult.setValue((Object)result);
        return commonResult;
    }

    @RequestMapping(value={"getCurrentUserMenuByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u83dc\u5355\u522b\u540d\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355", httpMethod="GET", notes="\u6839\u636e\u83dc\u5355\u522b\u540d\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355")
    @ResponseBody
    public CommonResult<List<SysMenu>> getCurrentUserMenuByAlias(@ApiParam(name="alias", value="\u83dc\u5355\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        CommonResult commonResult = new CommonResult(true, "\u6839\u636e\u83dc\u5355\u522b\u540d\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355");
        List lists = this.sysMenuManager.getCurrentUserMenu();
        List collect = lists.stream().filter(r -> alias.equals(r.getAlias())).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            commonResult.setValue(collect);
        }
        return commonResult;
    }

    @RequestMapping(value={"getAppMenuByAuthApp"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u7528\u6237\u6388\u6743\u5e94\u7528\u83b7\u53d6\u5e94\u7528\u5206\u7c7b\u83dc\u5355", httpMethod="GET", notes="\u6839\u636e\u5f53\u524d\u7528\u6237\u6388\u6743\u5e94\u7528\u83b7\u53d6\u5e94\u7528\u5206\u7c7b\u83dc\u5355")
    @ResponseBody
    public CommonResult<List<SysMenu>> getAppMenuByAuthApp(@ApiParam(name="menuAlias", value="\u83dc\u5355\u7c7b\u578b", required=true) @RequestParam String menuAlias) throws Exception {
        List result = this.sysMenuManager.getAppMenuByAuthApp(menuAlias);
        return new CommonResult(true, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u83dc\u5355\u4fe1\u606f", (Object)result);
    }

    @RequestMapping(value={"getCurrentUserMethodAuth"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u8bf7\u6c42\u6743\u9650", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u8bf7\u6c42\u6743\u9650")
    @ResponseBody
    public Map<String, List<String>> getCurrentUserMethodAuth() throws Exception {
        return this.sysMenuManager.getCurrentUserMethodAuth();
    }

    @RequestMapping(value={"addDataTemplateToMenu"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5230\u83dc\u5355", httpMethod="POST", notes="\u6dfb\u52a0\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5230\u83dc\u5355")
    public CommonResult<String> addDataTemplateToMenu(@ApiParam(name="templateToMenuVo", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6dfb\u52a0\u5230\u83dc\u5355\u53c2\u6570", required=true) @RequestBody TemplateToMenuVo templateToMenuVo) throws Exception {
        if (StringUtil.isEmpty((String)templateToMenuVo.getParentAlias())) {
            return new CommonResult(false, "\u7236\u83dc\u5355\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)templateToMenuVo.getAlias())) {
            return new CommonResult(false, "\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysMenu pMenu = this.sysMenuManager.getByAlias(templateToMenuVo.getParentAlias());
        if (BeanUtils.isEmpty((Object)pMenu)) {
            return new CommonResult(false, "\u6839\u636e\u7236\u83dc\u5355\u522b\u540d" + templateToMenuVo.getParentAlias() + "\u672a\u627e\u5230\u5bf9\u5e94\u83dc\u5355\uff01");
        }
        boolean isExist = this.sysMenuManager.isExistByAlias(templateToMenuVo.getAlias());
        if (isExist) {
            return new CommonResult(false, "\u522b\u540d\u3010" + templateToMenuVo.getAlias() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        SysMenu templateListMenu = new SysMenu();
        try {
            String id = UniqueIdUtil.getSuid();
            if (pMenu.getPath().endsWith(".")) {
                templateListMenu.setPath(String.format("%s%s.", pMenu.getPath(), id));
            } else {
                templateListMenu.setPath(String.format("%s.%s.", pMenu.getPath(), id));
            }
            templateListMenu.setSn(99);
            templateListMenu.setOpen(false);
            templateListMenu.setHref(templateToMenuVo.getHref());
            templateListMenu.setAlias(templateToMenuVo.getAlias());
            templateListMenu.setName(templateToMenuVo.getName());
            templateListMenu.setActiveTab(templateToMenuVo.getPath());
            templateListMenu.setId(id);
            templateListMenu.setParentId(pMenu.getId());
            templateListMenu.setRouterExtend(templateToMenuVo.getRouteExtend());
            templateListMenu.setType(templateToMenuVo.getType());
            this.sysMenuManager.create((Model)templateListMenu);
            if (StringUtil.isNotEmpty((String)templateToMenuVo.getAuthorizeId())) {
                this.sysMenuManager.createMenuAndAuth(templateToMenuVo.getAuthorizeId(), templateListMenu);
            }
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6dfb\u52a0\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f\uff0c\u91cd\u65b0\u767b\u5f55\u540e\u751f\u6548\uff01");
    }

    @RequestMapping(value={"addDatavToMenu"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5230\u83dc\u5355", httpMethod="POST", notes="\u6dfb\u52a0\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5230\u83dc\u5355")
    public CommonResult<String> addDatavToMenu(@ApiParam(name="templateToMenuVo", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6dfb\u52a0\u5230\u83dc\u5355\u53c2\u6570", required=true) @RequestBody TemplateToMenuVo templateToMenuVo) throws Exception {
        if (StringUtil.isEmpty((String)templateToMenuVo.getParentAlias())) {
            return new CommonResult(false, "\u7236\u83dc\u5355\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)templateToMenuVo.getAlias())) {
            return new CommonResult(false, "\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysMenu pMenu = this.sysMenuManager.getByAlias(templateToMenuVo.getParentAlias());
        if (BeanUtils.isEmpty((Object)pMenu)) {
            return new CommonResult(false, "\u6839\u636e\u7236\u83dc\u5355\u522b\u540d" + templateToMenuVo.getParentAlias() + "\u672a\u627e\u5230\u5bf9\u5e94\u83dc\u5355\uff01");
        }
        boolean isExist = this.sysMenuManager.isExistByAlias(templateToMenuVo.getAlias());
        if (isExist) {
            return new CommonResult(false, "\u522b\u540d\u3010" + templateToMenuVo.getAlias() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        SysMenu templateListMenu = new SysMenu();
        try {
            String id = UniqueIdUtil.getSuid();
            templateListMenu.setPath(pMenu.getPath() + id + ".");
            templateListMenu.setSn(99);
            templateListMenu.setOpen(false);
            templateListMenu.setAlias(templateToMenuVo.getAlias());
            templateListMenu.setName(templateToMenuVo.getName());
            templateListMenu.setActiveTab(templateToMenuVo.getPath());
            templateListMenu.setId(id);
            templateListMenu.setParentId(pMenu.getId());
            ObjectNode routeExtendNode = JsonUtil.getMapper().createObjectNode();
            String[] paths = templateToMenuVo.getAlias().split("/");
            routeExtendNode.put("path", String.format("/datav/%s?alias=%s", paths[1], paths[1]));
            routeExtendNode.put("component", "DatavLayout");
            routeExtendNode.put("redirect", "");
            routeExtendNode.put("alwaysShow", false);
            routeExtendNode.put("caseSensitive", false);
            ObjectNode metaNode = JsonUtil.getMapper().createObjectNode();
            metaNode.put("title", templateToMenuVo.getName());
            metaNode.put("isChildren", true);
            routeExtendNode.set("meta", (JsonNode)metaNode);
            templateListMenu.setRouterExtend(JsonUtil.toJson((Object)routeExtendNode));
            templateListMenu.setType(templateToMenuVo.getType());
            this.sysMenuManager.create((Model)templateListMenu);
            if (StringUtil.isNotEmpty((String)templateToMenuVo.getAuthorizeId())) {
                this.sysMenuManager.createMenuAndAuth(templateToMenuVo.getAuthorizeId(), templateListMenu);
            }
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6dfb\u52a0\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f\uff0c\u91cd\u65b0\u767b\u5f55\u540e\u751f\u6548\uff01");
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u5bfc\u5165", httpMethod="POST", notes="\u83dc\u5355\u5bfc\u5165")
    public CommonResult<String> importData(MultipartHttpServletRequest request, @ApiParam(name="parentMenuId", value="\u7236\u83dc\u5355ID", required=true) @RequestParam String parentMenuId) throws Exception {
        CommonResult res = this.sysMenuManager.importData(request, parentMenuId);
        return res;
    }

    @RequestMapping(value={"coverImport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u8986\u76d6\u5bfc\u5165", httpMethod="POST", notes="\u83dc\u5355\u5bfc\u5165")
    public CommonResult<String> coverImport(@ApiParam(name="parentMenuId", value="\u7236\u83dc\u5355ID", required=true) @RequestParam String parentMenuId, @ApiParam(name="cacheId", value="\u7f13\u5b58\u7684id", required=true) @RequestParam String cacheId) throws Exception {
        String cacheMenuJson = ((SysMenuManager)this.baseService).getImportFileFromCache(cacheId);
        if (StringUtil.isEmpty((String)cacheMenuJson)) {
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:\u4e0a\u4f20\u7684\u6587\u4ef6\u5df2\u4ece\u7f13\u5b58\u4e2d\u6e05\u9664\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
        }
        try {
            this.sysMenuManager.importFile(null, parentMenuId, cacheMenuJson);
        }
        catch (Exception e) {
            return CommonResult.error((String)e.getMessage());
        }
        return CommonResult.ok();
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u5bfc\u51fa", httpMethod="GET", notes="\u83dc\u5355\u5bfc\u51fa")
    public void export(@ApiParam(name="parentMenuId", value="\u7236\u83dc\u5355ID") @RequestParam String parentMenuId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SysMenu menu = (SysMenu)this.sysMenuManager.get((Serializable)((Object)parentMenuId));
        if (!BeanUtils.isNotEmpty((Object)menu)) {
            throw new RuntimeException("\u5bfc\u51fa\u7684\u83dc\u5355\u4e0d\u5b58\u5728\uff01");
        }
        List childrenMenus = this.sysMenuManager.getByChidrensParentPath(menu.getPath());
        String json = JsonUtil.toJson((Object)childrenMenus);
        HashMap<String, String> fileContentMap = new HashMap<String, String>();
        fileContentMap.put("sysMenus.json", json);
        String fileName = "sysMenus_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, fileContentMap, (String)fileName);
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u83dc\u5355\u522b\u540d\u83b7\u53d6\u83dc\u5355\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u83dc\u5355\u522b\u540d\u83b7\u53d6\u83dc\u5355\u4fe1\u606f")
    @ResponseBody
    public SysMenu getByAlias(@ApiParam(name="alias", value="\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        return this.sysMenuManager.getByAlias(alias);
    }

    @RequestMapping(value={"getFirstMenuRouterPathByTemplateAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5e94\u7528\u6a21\u677f\u522b\u540d\u67e5\u8be2\u5339\u914d\u7684\u7b2c\u4e00\u6761\u8bb0\u5f55\u7684\u83dc\u5355\u524d\u53f0\u8bbf\u95ee\u8def\u5f84", httpMethod="GET", notes="\u6839\u636e\u6570\u636e\u5e94\u7528\u6a21\u677f\u522b\u540d\u67e5\u8be2\u5339\u914d\u7684\u7b2c\u4e00\u6761\u8bb0\u5f55\u7684\u83dc\u5355\u524d\u53f0\u8bbf\u95ee\u8def\u5f84")
    @ResponseBody
    public CommonResult<String> getFirstMenuRouterPathByTemplateAlias(@ApiParam(name="templateAlias", value="\u6a21\u677f\u522b\u540d", required=true) @RequestParam String templateAlias, @ApiParam(name="frontType", value="\u524d\u7aef\u7c7b\u578b(manage\u3001front\u3001mobile)", required=false) @RequestParam Optional<String> frontType) throws Exception {
        return this.sysMenuManager.getFirstMenuRouterPathByTemplateAlias(templateAlias, frontType.isPresent() ? FrontTypeConstant.valueOf((String)frontType.get()) : FrontTypeConstant.front);
    }

    @RequestMapping(value={"updateFrontMenuPath"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8001\u7248\u672c\u522b\u540d\u548cpath\u53ef\u4ee5\u5206\u522b\u914d\u7f6e\u3002\u65b0\u7248\u91c7\u7528\u522b\u540d\u4f5c\u4e3apath\u3002\u6b64\u63a5\u53e3\u7528\u4e8e\u5904\u7406\u8001\u7248\u522b\u540d\u548cpath\u4e0d\u4e00\u81f4\u7684\u6570\u636e\u3002\u4ee5\u514d\u65b0\u7248\u6dfb\u52a0\u83dc\u5355\u7ecf\u5e38\u51fa\u73b0path\u88ab\u5360\u7528", httpMethod="GET", notes="\u8001\u7248\u672c\u522b\u540d\u548cpath\u53ef\u4ee5\u5206\u522b\u914d\u7f6e\u3002\u65b0\u7248\u91c7\u7528\u522b\u540d\u4f5c\u4e3apath\u3002\u6b64\u63a5\u53e3\u7528\u4e8e\u5904\u7406\u8001\u7248\u522b\u540d\u548cpath\u4e0d\u4e00\u81f4\u7684\u6570\u636e\u3002\u4ee5\u514d\u65b0\u7248\u6dfb\u52a0\u83dc\u5355\u7ecf\u5e38\u51fa\u73b0path\u88ab\u5360\u7528")
    @ResponseBody
    public CommonResult<String> updateFrontMenuPath() throws Exception {
        this.sysMenuManager.updateFrontMenuPath();
        return CommonResult.ok();
    }

    @GetMapping(value={"menus/right"})
    @ApiOperation(value="\u83b7\u53d6\u83dc\u5355\u6743\u9650", httpMethod="GET", notes="\u8001\u7248\u672c\u522b\u540d\u548cpath\u53ef\u4ee5\u5206\u522b\u914d\u7f6e\u3002\u65b0\u7248\u91c7\u7528\u522b\u540d\u4f5c\u4e3apath\u3002\u6b64\u63a5\u53e3\u7528\u4e8e\u5904\u7406\u8001\u7248\u522b\u540d\u548cpath\u4e0d\u4e00\u81f4\u7684\u6570\u636e\u3002\u4ee5\u514d\u65b0\u7248\u6dfb\u52a0\u83dc\u5355\u7ecf\u5e38\u51fa\u73b0path\u88ab\u5360\u7528")
    public List<SysMenu> menuRights(String ... alias) throws Exception {
        return this.sysMenuManager.getMenusByAlias(Arrays.stream(alias).collect(Collectors.toList()));
    }
}

