/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.sys.persistence.manager.SysModuleDetailManager;
import com.hotent.sys.persistence.manager.SysModuleManager;
import com.hotent.sys.persistence.model.SysModule;
import com.hotent.sys.vo.SaveAndPublishModuleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sys/sysModule/v1"})
@Api(tags={"\u7cfb\u7edf\u6a21\u5757"})
@ApiGroup(group={"group_portal"})
public class SysModuleController
extends BaseController<SysModuleManager, SysModule> {
    @Resource
    SysModuleManager sysModuleManager;
    @Resource
    SysModuleDetailManager sysModuleDetailManager;
    private static final String ROOT_PATH = "attachFiles" + File.separator + "tempZip";

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6a21\u5757\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6a21\u5757\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    @ResponseBody
    public PageList<SysModule> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysModule> queryFilter) {
        queryFilter.getSorter().add(new FieldSort("updateTime", Direction.DESC));
        return this.sysModuleManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6a21\u5757\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u6a21\u5757\u660e\u7ec6\u9875\u9762")
    public CommonResult<SysModule> getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id) {
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)new SysModule());
        }
        SysModule sysModule = (SysModule)this.sysModuleManager.get((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)sysModule)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)new SysModule());
        }
        String dbType = SQLUtil.getDbType();
        if (StringUtil.isEmpty((String)sysModule.getMenu()) && dbType.equals("oracle")) {
            sysModule.setMenu("");
        }
        List details = this.sysModuleDetailManager.getModuleDetail(sysModule.getId(), null);
        sysModule.setModuleDetail(details);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)sysModule);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6a21\u5757\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6a21\u5757\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysModule", value="\u6a21\u5757\u4fe1\u606f\u5bf9\u8c61") @RequestBody SysModule sysModule) {
        CommonResult res = this.sysModuleManager.saveSysModule(sysModule);
        return res;
    }

    @RequestMapping(value={"saveModule"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6a21\u5757\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6a21\u5757\u4fe1\u606f")
    public CommonResult<String> saveModule(@ApiParam(name="sysModule", value="\u6a21\u5757\u4fe1\u606f\u5bf9\u8c61") @RequestBody SysModule sysModule) {
        CommonResult resultMsg = null;
        String id = sysModule.getId();
        this.sysModuleManager.saveModule(sysModule);
        resultMsg = StringUtil.isEmpty((String)id) ? new CommonResult(true, "\u6dfb\u52a0\u6a21\u5757\u4fe1\u606f\u6210\u529f", (Object)sysModule.getId()) : new CommonResult(true, "\u66f4\u65b0\u6a21\u5757\u4fe1\u606f\u6210\u529f", (Object)sysModule.getId());
        return resultMsg;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6a21\u5757\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6a21\u5757\u8bb0\u5f55")
    public CommonResult<String> remove(String ... ids) {
        CommonResult message = null;
        try {
            this.sysModuleManager.removeByIds(ids);
            message = new CommonResult("\u5220\u9664\u6a21\u5757\u6210\u529f");
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5220\u9664\u6a21\u5757\u5931\u8d25");
        }
        return message;
    }

    @RequestMapping(value={"isExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u6a21\u5757\u7f16\u53f7\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u5224\u65ad\u6a21\u5757\u7f16\u53f7\u662f\u5426\u5b58\u5728")
    public boolean isExist(@ApiParam(name="code", value="\u6a21\u5757\u7f16\u7801", required=false) @RequestParam String code) throws Exception {
        boolean res = false;
        if (StringUtil.isNotEmpty((String)code)) {
            SysModule temp = this.sysModuleManager.getModuleByCode(code);
            res = BeanUtils.isNotEmpty((Object)temp);
        }
        return res;
    }

    @RequestMapping(value={"exportModule"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u683c\u5f0f\u4e3a*.zip\u7684\u6a21\u5757\u5bf9\u8c61\uff0czip\u6587\u4ef6\u5305\u542b\u4e00\u4e2axml\u6587\u4ef6\uff0cxml\u6587\u4ef6\u90fd\u662f\u591a\u4e2a\u6a21\u5757\u5bf9\u8c61;", httpMethod="GET", notes="\u5bfc\u51fa\u683c\u5f0f\u4e3a*.zip\u7684\u6a21\u5757\u5bf9\u8c61\uff0czip\u6587\u4ef6\u5305\u542b\u4e00\u4e2axml\u6587\u4ef6\uff0cxml\u6587\u4ef6\u90fd\u662f\u591a\u4e2a\u6a21\u5757\u5bf9\u8c61;")
    public void exportModule(HttpServletRequest request, HttpServletResponse response, String ... ids) throws Exception {
        if (BeanUtils.isEmpty((Object)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids);
        Map map = this.sysModuleManager.exportModules(idList);
        String fileName = "ht_module_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (Map)map, (String)fileName);
    }

    @RequestMapping(value={"importModule"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u6a21\u5757\u5bf9\u8c61", httpMethod="POST", notes="\u5bfc\u5165\u6a21\u5757\u5bf9\u8c61")
    public CommonResult<String> importModule(@ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u6a21\u5757\u5bf9\u8c61\u6587\u4ef6id") @RequestParam Optional<String> cacheFileId) throws Exception {
        return this.sysModuleManager.importModule(cacheFileId);
    }

    @RequestMapping(value={"importModuleCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u5bfc\u5165\u6a21\u5757\u5bf9\u8c61\u662f\u5426\u91cd\u590d", httpMethod="POST", notes="\u68c0\u67e5\u5bfc\u5165\u6a21\u5757\u5bf9\u8c61\u662f\u5426\u91cd\u590d")
    public CommonResult<String> importModuleCheck(@ApiParam(name="file", value="\u5bfc\u5165\u7684zip\u6587\u4ef6", required=true) @RequestBody MultipartFile file) throws Exception {
        return this.sysModuleManager.importModuleCheck(file);
    }

    @PostMapping(value={"saveAndPublishModule"})
    @ApiOperation(value="\u4fdd\u5b58\u5e76\u53d1\u5e03\u6d41\u7a0b\u6a21\u5757", httpMethod="POST", notes="\u4fdd\u5b58\u5e76\u53d1\u5e03\u6d41\u7a0b\u6a21\u5757")
    public CommonResult<String> saveAndPublishModule(@ApiParam(name="saveAndPublishModuleVo", value="\u6d41\u7a0b\u6a21\u5757\u4fdd\u5b58\u5e76\u53d1\u5e03\u53c2\u6570") @RequestBody SaveAndPublishModuleVo saveAndPublishModuleVo, @ApiParam(name="type", value="\u53d1\u5e03\u7c7b\u578b manage\uff1a\u7ba1\u7406\u7aef\uff0cfront\uff1a\u5e94\u7528\u7aef\uff0capp\uff1a\u5e94\u7528\u4e2d\u5fc3 ") @RequestParam(value="type") String type) {
        CommonResult res = this.sysModuleManager.saveAndPublishModule(saveAndPublishModuleVo, type);
        return res;
    }

    @RequestMapping(value={"updateSysModuleByCustomId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u56fe\u8868id\u4fee\u6539\u7cfb\u7edf\u6a21\u5757\u76f8\u5173\u4fe1\u606f", httpMethod="GET", notes="\u901a\u8fc7\u56fe\u8868id\u4fee\u6539\u7cfb\u7edf\u6a21\u5757\u76f8\u5173\u4fe1\u606f")
    public CommonResult<String> updateSysModuleByCustomId(@ApiParam(name="code", value="\u56fe\u8868id", required=true) @RequestParam String customChartId, @ApiParam(name="objectNode", value="\u56fe\u8868\u4fe1\u606f", required=true) @RequestBody ObjectNode objectNode) throws Exception {
        return this.sysModuleManager.updateSysModuleByCustomId(customChartId, objectNode);
    }
}

