/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.EncryptUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.portal.service.SysPropertiesService;
import com.hotent.sys.persistence.manager.SysPropertiesManager;
import com.hotent.sys.persistence.model.SysProperties;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/sysProperties/v1"})
@Api(tags={"\u7cfb\u7edf\u5c5e\u6027"})
@ApiGroup(group={"group_portal"})
public class SysPropertiesController
extends BaseController<SysPropertiesManager, SysProperties> {
    @Resource
    SysPropertiesManager sysPropertiesManager;
    @Autowired
    SysPropertiesService propertiesService;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u5c5e\u6027\u5217\u8868", httpMethod="POST", notes="\u7cfb\u7edf\u5c5e\u6027\u5217\u8868")
    public PageList<SysProperties> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysProperties> queryFilter) throws Exception {
        return this.sysPropertiesManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u5c5e\u6027\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u7cfb\u7edf\u5c5e\u6027\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public SysProperties getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        SysProperties res = this.propertiesService.getJson(id);
        return res;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7cfb\u7edf\u5c5e\u6027\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u7cfb\u7edf\u5c5e\u6027\u4fe1\u606f")
    @CacheEvict(value={"eip:sys:props"}, key="#sysProperties.alias")
    public CommonResult<String> save(@ApiParam(name="sysProperties", value="\u7cfb\u7edf\u5c5e\u6027", required=true) @RequestBody @Valid SysProperties sysProperties) throws Exception {
        String resultMsg = null;
        String id = sysProperties.getId();
        sysProperties.setValByEncrypt();
        if (StringUtil.isEmpty((String)id)) {
            if (BeanUtils.isNotEmpty((Object)this.sysPropertiesManager.getByAlias(sysProperties.getAlias()))) {
                return new CommonResult(false, "\u7cfb\u7edf\u5c5e\u6027\u5df2\u5b58\u5728\uff01");
            }
            sysProperties.setId(UniqueIdUtil.getSuid());
            this.sysPropertiesManager.create((Model)sysProperties);
            resultMsg = "\u6dfb\u52a0\u7cfb\u7edf\u5c5e\u6027\u6210\u529f";
        } else {
            this.sysPropertiesManager.update((Model)sysProperties);
            this.sysPropertiesManager.deleteCacheByAlias(sysProperties.getAlias());
            resultMsg = "\u66f4\u65b0\u7cfb\u7edf\u5c5e\u6027\u6210\u529f";
        }
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u5c5e\u6027\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u5c5e\u6027\u8bb0\u5f551,2,3")
    @CacheEvict(value={"eip:sys:props"}, allEntries=true)
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = StringUtil.getStringAryByStr((String)ids);
        this.sysPropertiesManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u7cfb\u7edf\u5c5e\u6027\u6210\u529f");
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u53c2\u6570\u503c\u3002", httpMethod="GET", notes="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u53c2\u6570\u503c")
    public String getByAlias(@ApiParam(name="alias", value="\u5c5e\u6027\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="defaultValue", value="\u9ed8\u8ba4\u503c") @RequestParam Optional<String> defaultValue) throws Exception {
        String value = this.sysPropertiesManager.getByAlias(alias, defaultValue.orElse(""));
        return value;
    }

    @RequestMapping(value={"getDecryptByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u89e3\u5bc6\u540e\u53c2\u6570\u503c\u3002", httpMethod="GET", notes="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u89e3\u5bc6\u540e\u53c2\u6570\u503c")
    public SysProperties getDecryptByAlias(@ApiParam(name="alias", value="\u5c5e\u6027\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        SysProperties sysProperties = this.sysPropertiesManager.getByAliasFromDb(alias);
        if (BeanUtils.isNotEmpty((Object)sysProperties)) {
            SysProperties sysProperties1 = (SysProperties)BeanUtils.cloneBean((Object)sysProperties);
            String realVal = sysProperties1.getRealVal();
            sysProperties1.setValue(realVal);
            return sysProperties1;
        }
        return null;
    }

    @RequestMapping(value={"getDecryptBySysSetting"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u522b\u540d\u4e3a\u201csysSetting\u201d\u89e3\u5bc6\u540e\u53c2\u6570\u503c", httpMethod="GET", notes="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u522b\u540d\u4e3a\u201csysSetting\u201d\u89e3\u5bc6\u540e\u53c2\u6570\u503c")
    public SysProperties getDecryptBySysSetting() throws Exception {
        SysProperties sysProperties = this.sysPropertiesManager.getByAliasFromDb("sysSetting");
        if (BeanUtils.isNotEmpty((Object)sysProperties)) {
            sysProperties.setValue(EncryptUtil.decrypt((String)sysProperties.getValue()));
            return sysProperties;
        }
        return null;
    }

    @RequestMapping(value={"setDeleteSetting"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u53c2\u6570\u8bbe\u7f6e", httpMethod="GET", notes="\u83b7\u53d6\u7cfb\u7edf\u5c5e\u6027\u522b\u540d\u4e3a\u201csysSetting\u201d\u89e3\u5bc6\u540e\u53c2\u6570\u503c")
    public void setDeleteSetting(@ApiParam(name="value", value="\u5c5e\u6027\u503c", required=true) @RequestParam String value, @ApiParam(name="alias", value="\u5c5e\u6027\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="name", value="\u5c5e\u6027\u540d\u79f0", required=true) @RequestParam String name) throws Exception {
        this.propertiesService.setDeleteSetting(value, alias, name);
    }
}

