/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.context.BaseContext;
import com.hotent.base.controller.BaseController;
import com.hotent.base.exception.MessagePassingException;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.sys.persistence.manager.DataDictManager;
import com.hotent.sys.persistence.manager.SysCategoryManager;
import com.hotent.sys.persistence.manager.SysTypeManager;
import com.hotent.sys.persistence.model.SysCategory;
import com.hotent.sys.persistence.model.SysType;
import com.hotent.sys.vo.SysTypeTreeVO;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/sysType/v1"})
@Api(tags={"\u7cfb\u7edf\u5206\u7c7b"})
@ApiGroup(group={"group_portal"})
public class SysTypeController
extends BaseController<SysTypeManager, SysType> {
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    SysCategoryManager sysCategoryManager;
    @Resource
    IUserService iUserService;
    @Resource
    JmsProducer jmsProducer;
    @Resource
    DataDictManager dataDictManager;
    @Resource
    BaseContext baseContext;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u5206\u7c7b", httpMethod="POST", notes="\u7cfb\u7edf\u5206\u7c7b")
    public PageList<SysType> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysType> queryFilter) throws Exception {
        return this.sysTypeManager.query(queryFilter);
    }

    @RequestMapping(value={"editJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u603b\u5206\u7c7b\u8868\u3002\u7528\u4e8e\u663e\u793a\u5e73\u7ea7\u6216\u6811\u5c42\u6b21\u7ed3\u6784\u7684\u5206\u7c7b\uff0c\u53ef\u4ee5\u5141\u8bb8\u4efb\u4f55\u5c42\u6b21\u7ed3\u6784", httpMethod="GET", notes="\u7cfb\u7edf\u5206\u7c7b")
    public Map<String, Object> editJson(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id, @ApiParam(name="isRoot", value="\u662f\u5426\u662f\u6839\u8282\u70b9\uff0c1=\u6839\u8282\u70b9\uff0c0=\u5176\u4ed6\u8282\u70b9", required=false) @RequestParam int isRoot, @ApiParam(name="parentId", value="\u7236\u8282\u70b9ID", required=false) @RequestParam String parentId, @ApiParam(name="isPriNode", value="\u662f\u5426\u662f\u79c1\u6709\u7684\u8282\u70b9\uff0c1=\u79c1\u6709\u8282\u70b9\uff0c0=\u666e\u901a\u8282\u70b9", required=false) @RequestParam int isPriNode) throws Exception {
        Map res = this.sysTypeManager.editJson(id, isRoot, parentId, isPriNode);
        return res;
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u5206\u7c7b\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u7cfb\u7edf\u5206\u7c7b")
    public SysType getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id) throws Exception {
        SysType sysType = new SysType();
        if (StringUtil.isNotEmpty((String)id) && BeanUtils.isEmpty((Object)(sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)id))))) {
            sysType = this.sysTypeManager.getByKey(id);
        }
        return sysType;
    }

    @RequestMapping(value={"getSysTypeByType"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u522b\u540d\u548c\u5206\u7c7b\u522b\u540d\u83b7\u53d6\u7cfb\u7edf\u5206\u7c7b", httpMethod="GET", notes="\u7cfb\u7edf\u5206\u7c7b")
    public SysType getSysTypeByType(@ApiParam(name="group", value="\u5206\u7ec4\u7f16\u7801", required=true) @RequestParam String group, @ApiParam(name="typeKey", value="\u5206\u7c7b\u7f16\u7801", required=true) @RequestParam String typeKey) throws Exception {
        return this.sysTypeManager.getByTypeKeyAndGroupKey(group, typeKey);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5206\u7c7b\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u7cfb\u7edf\u5c5e\u6027\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysType", value="\u5206\u7c7b", required=true) @RequestBody SysType sysType, @ApiParam(name="parentId", value="\u7236\u8282\u70b9", required=true) @RequestParam String parentId, @ApiParam(name="isRoot", value="\u662f\u5426\u6839\u8282\u70b9", required=false) @RequestParam int isRoot, @ApiParam(name="isPriNode", value="\u662f\u5426\u662f\u79c1\u6709\u7684\u5206\u7c7b", required=false) @RequestParam int isPriNode, @ApiParam(name="isDefaultAuth", value="\u662f\u5426\u6dfb\u52a0\u9ed8\u8ba4\u6743\u9650", required=false) @RequestParam(required=false) Integer isDefaultAuth) throws Exception {
        CommonResult res = this.sysTypeManager.save(sysType, parentId, isRoot, isPriNode, isDefaultAuth);
        return res;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u5206\u7c7b", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u5206\u7c7b")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        try {
            this.dataDictManager.delByDictTypeId(id);
            this.sysTypeManager.delByIds(id);
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        catch (MessagePassingException e) {
            return new CommonResult(false, e.getMessage());
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25");
        }
    }

    @RequestMapping(value={"sysTypeTree"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u7c7b\u6811", httpMethod="GET", notes="\u5206\u7c7b\u6811")
    public Map<String, Object> tree() throws Exception {
        List list = this.sysCategoryManager.list();
        SysCategory sysCategory = (SysCategory)list.get(0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysCategoryList", list);
        map.put("sysCategory", sysCategory);
        return map;
    }

    @RequestMapping(value={"getByParentId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7236\u8282\u70b9\u83b7\u53d6\u5206\u7c7b", httpMethod="GET", notes="\u6839\u636e\u7236\u8282\u70b9\u83b7\u53d6\u5206\u7c7b")
    public List<SysType> getByParentId(@ApiParam(name="catId", value="\u5206\u7c7bid", required=true, defaultValue="0") @RequestParam String catId) throws Exception {
        List res = this.sysTypeManager.getDataByParentId(catId);
        return res;
    }

    @RequestMapping(value={"sysTypeSortList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f\u5217\u8868\u9875\u9762", httpMethod="POST", notes="\u6392\u5e8f\u5217\u8868\u9875\u9762")
    public List<SysType> sortList(@ApiParam(name="id", value="\u4e3b\u952e", required=true, defaultValue="-1") @RequestParam String id) throws Exception {
        String curUserId = ContextUtil.getCurrentUserId();
        List sysTypes = this.sysTypeManager.getPrivByPartId(id, curUserId);
        return sysTypes;
    }

    @RequestMapping(value={"sort"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f", httpMethod="POST", notes="\u6392\u5e8f")
    public CommonResult<String> sort(@ApiParam(name="typeIds", value="\u5206\u7c7bid", required=true) @RequestParam String[] typeIds) throws Exception {
        CommonResult res = this.sysTypeManager.sort(typeIds);
        return res;
    }

    @RequestMapping(value={"getTypesByKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b", httpMethod="GET", notes="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b")
    public List<SysType> getTypesByKey(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        List res = this.sysTypeManager.getTypesByKey(typeKey);
        return res;
    }

    @RequestMapping(value={"getTypeAndDicByKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b", httpMethod="GET", notes="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b")
    public List<SysType> getTypeAndDicByKey(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        List res = this.sysTypeManager.getTypeAndDicByKey(typeKey);
        return res;
    }

    @RequestMapping(value={"getTreeDateByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b\u6811", httpMethod="GET", notes="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b\u6811")
    public List<SysType> getTreeDateByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        List groupTypes = null;
        if (StringUtil.isNotEmpty((String)typeKey)) {
            groupTypes = this.sysTypeManager.getChildByTypeKey(typeKey);
        }
        List rtnList = BeanUtils.listToTree(groupTypes);
        return rtnList;
    }

    @RequestMapping(value={"getTreeByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b\u6811", httpMethod="GET", notes="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b\u6811")
    public List<SysType> getTreeByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) {
        return this.sysTypeManager.getTreeByTypeKey(typeKey);
    }

    @RequestMapping(value={"getByGroupKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53ef\u4ee5\u7ec4key\u83b7\u53d6\u5206\u7c7b", httpMethod="GET", notes="\u6839\u636e\u53ef\u4ee5\u7ec4key\u83b7\u53d6\u5206\u7c7b")
    public List<SysType> getByGroupKey(@ApiParam(name="groupKey", value="\u5206\u7c7b\u7ec4key", required=true) @RequestParam String groupKey) throws Exception {
        if ("DIC".equals(groupKey)) {
            return this.sysTypeManager.getTypeAndDicByKey(groupKey);
        }
        List types = null;
        if (StringUtil.isNotEmpty((String)groupKey)) {
            types = this.sysTypeManager.getByGroupKey(groupKey);
        }
        List rtnList = BeanUtils.listToTree(types);
        return rtnList;
    }

    @RequestMapping(value={"updateEntitySysType"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u5bf9\u8c61\u7684\u5206\u7c7b\u4fe1\u606f", httpMethod="GET", notes="\u66f4\u65b0\u5bf9\u8c61\u7684\u5206\u7c7b\u4fe1\u606f")
    public CommonResult<String> updateEntitySysType(@ApiParam(name="typeID", value="\u8981\u8bbe\u7f6e\u4e3a\u7684\u5206\u7c7bid", required=true) @RequestParam String typeID, @ApiParam(name="entityIds", value="\u8981\u66f4\u65b0\u7684\u5b9e\u4f53id", required=true) @RequestParam String entityIds) throws Exception {
        CommonResult res = this.sysTypeManager.updateEntitySysType(typeID, entityIds);
        return res;
    }

    @RequestMapping(value={"getByParentIdOrLikeName"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7236\u8282\u70b9\u83b7\u53d6\u5206\u7c7b\u6216\u8005 \u6839\u636e\u5206\u7c7b\u540d\u79f0\u6a21\u7cca\u67e5\u8be2", httpMethod="GET", notes="\u6839\u636e\u7236\u8282\u70b9\u83b7\u53d6\u5206\u7c7b\u6216\u8005 \u6839\u636e\u5206\u7c7b\u540d\u79f0\u6a21\u7cca\u67e5\u8be2")
    public List<SysTypeTreeVO> getByParentIdOrLikeName(@ApiParam(name="catId", value="\u7cfb\u7edf\u5206\u7c7b\u5206\u7ec4id", required=true, defaultValue="0") @RequestParam String catId, @ApiParam(name="parentId", value="\u5206\u7c7bid", required=false, defaultValue="catId") @RequestParam(required=false) String parentId, @ApiParam(name="typeName", value="\u5206\u7c7b\u540d\u79f0", required=false) @RequestParam(required=false) String typeName) throws Exception {
        List res = this.sysTypeManager.getByParentIdOrLikeName(catId, parentId, typeName);
        return res;
    }

    @RequestMapping(value={"getSysTypeByIds"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5206\u7c7bids\u83b7\u53d6\u5206\u7c7b", httpMethod="POST", notes="\u6839\u636e\u5206\u7c7bids\u83b7\u53d6\u5206\u7c7b")
    public CommonResult<List<SysType>> getSysTypeByIds(@RequestBody List<String> ids) {
        return CommonResult.success((Object)((SysTypeManager)this.baseService).getByIds(ids));
    }
}

