/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.jms.impl;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jms.JmsHandler;
import com.hotent.base.jms.JmsMessage;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.portal.model.MsgTemplate;
import com.hotent.portal.persistence.manager.MessageLogManager;
import com.hotent.portal.persistence.manager.MsgTemplateManager;
import com.hotent.portal.service.impl.TemplateServiceImpl;
import com.hotent.portal.util.DingTalkUtil;
import com.hotent.portal.util.JmsHandlerUtil;
import com.hotent.system.consts.DingTalkConsts;
import com.hotent.system.model.SysExternalUnite;
import com.hotent.system.persistence.manager.SysExternalUniteManager;
import com.hotent.system.util.DingTalkTokenUtil;
import com.hotent.system.util.ExtUniUtil;
import com.taobao.api.TaobaoRequest;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DingTalkHandler
implements JmsHandler {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkHandler.class);
    @Resource
    MessageLogManager messageLogManager;
    @Resource
    SysExternalUniteManager sysExternalUniteManager;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    TemplateServiceImpl templateServiceImpl;
    @Resource
    UCFeignService uCFeignService;

    public String getType() {
        return NoticeMessageType.DINGTALK.key();
    }

    public String getTitle() {
        return "\u9489\u9489\u6d88\u606f";
    }

    public boolean getIsDefault() {
        return false;
    }

    public boolean getSupportHtml() {
        return true;
    }

    public boolean send(JmsMessage jmsMessage) {
        try {
            String description;
            String title;
            SysExternalUnite dingtalkUnite;
            List receivers = jmsMessage.getReceivers();
            String content = jmsMessage.getContent();
            content = content.replace("<p>", "");
            content = content.replace("</p>", "");
            jmsMessage.setContent(content);
            MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(jmsMessage.getTemplateAlias());
            if (BeanUtils.isNotEmpty((Object)((Object)msgTemplate))) {
                jmsMessage.getExtendVars().put("templateType", msgTemplate.getTypeKey());
            }
            if (BeanUtils.isEmpty((Object)(dingtalkUnite = this.sysExternalUniteManager.getDingtalk()))) {
                this.messageLogManager.handLogByMsgHander(jmsMessage, false, "\u96c6\u6210\u4e2d\u5fc3\u65e0\u76f8\u5173\u914d\u7f6e");
                return false;
            }
            List<String> users = JmsHandlerUtil.jmsActor2UserId(receivers);
            if (CollectionUtils.isEmpty(users)) {
                this.messageLogManager.handLogByMsgHander(jmsMessage, false, "\u65e0\u6d88\u606f\u63a5\u6536\u4eba");
                return false;
            }
            String dingtalkIds = this.uCFeignService.getDingtalkIdsByUserIds(String.join((CharSequence)",", users));
            if (StringUtil.isEmpty((String)dingtalkIds)) {
                this.messageLogManager.handLogByMsgHander(jmsMessage, false, "\u7528\u6237\u6570\u636e\u672a\u7ed1\u5b9a\uff0c\u8bf7\u5148\u540c\u6b65\u901a\u8baf\u5f55");
                return false;
            }
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingTalkConsts.getMsgSendUrl());
            OapiMessageCorpconversationAsyncsendV2Request req = new OapiMessageCorpconversationAsyncsendV2Request();
            req.setAgentId(Long.valueOf(dingtalkUnite.getAgentId()));
            req.setUseridList(dingtalkIds);
            String descriptionNode = "";
            if (jmsMessage.getExtendVars() != null && BeanUtils.isNotEmpty(jmsMessage.getExtendVars().getOrDefault("nodeName", null))) {
                descriptionNode = "\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u4e3a\uff1a" + jmsMessage.getExtendVars().getOrDefault("nodeName", null);
            }
            String string = title = StringUtil.isEmpty((String)jmsMessage.getSubject()) ? "EIP\u6d88\u606f" : jmsMessage.getSubject();
            if (msgTemplate == null) {
                description = jmsMessage.getContent();
            } else {
                title = this.templateServiceImpl.parseSubject(msgTemplate, jmsMessage.getExtendVars());
                description = this.templateServiceImpl.parsePlainContent(msgTemplate, jmsMessage.getExtendVars());
            }
            String cardContent = MessageFormat.format("### {0}  \n  ##### {1}  \n  {2}  \n  {3}", title, DateUtil.getCurrentTime((String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"), description, descriptionNode);
            cardContent = ExtUniUtil.takeOutHtmlTab((String)cardContent);
            String url = DingTalkUtil.renderMobileUrl(jmsMessage);
            OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
            if (StringUtil.isEmpty((String)url)) {
                msg.setMsgtype("markdown");
                msg.setMarkdown(new OapiMessageCorpconversationAsyncsendV2Request.Markdown());
                msg.getMarkdown().setText(cardContent);
                msg.getMarkdown().setTitle(title);
            } else {
                msg.setMsgtype("action_card");
                OapiMessageCorpconversationAsyncsendV2Request.ActionCard actionCard = new OapiMessageCorpconversationAsyncsendV2Request.ActionCard();
                actionCard.setTitle(title);
                actionCard.setMarkdown(cardContent);
                actionCard.setSingleTitle("\u67e5\u770b\u8be6\u60c5");
                actionCard.setSingleUrl(url);
                msg.setActionCard(actionCard);
            }
            req.setMsg(msg);
            OapiMessageCorpconversationAsyncsendV2Response rsp = (OapiMessageCorpconversationAsyncsendV2Response)client.execute((TaobaoRequest)req, DingTalkTokenUtil.getToken());
            if (!rsp.isSuccess()) {
                this.messageLogManager.handLogByMsgHander(jmsMessage, false, JsonUtil.toJson((Object)rsp));
                logger.error(JsonUtil.toJson((Object)rsp));
                return false;
            }
            this.messageLogManager.handLogByMsgHander(jmsMessage, true, JsonUtil.toJson((Object)rsp));
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            this.messageLogManager.handLogByMsgHander(jmsMessage, false, ex.getMessage());
            return false;
        }
    }
}

