/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.jms.impl;

import cn.keking.config.ConfigConstants;
import cn.keking.model.FileType;
import cn.keking.service.FileHandlerService;
import cn.keking.service.OfficeToPdfService;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.file.model.DefaultFile;
import com.hotent.file.persistence.manager.FileManager;
import com.hotent.jms.api.PortalServer;
import java.io.File;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class JmsPortalServerImpl
implements PortalServer {
    private static final Logger logger = LoggerFactory.getLogger(JmsPortalServerImpl.class);
    @Resource
    FileManager fileManager;
    @Resource
    OfficeToPdfService officeToPdfService;
    @Resource
    FileHandlerService fileHandlerService;

    public void handlerPreviewTrans(String source) throws Exception {
        System.out.println("\u5904\u7406\u9884\u89c8\u8f6c\u6362\u903b\u8f91: " + source);
        JsonNode jsonNode = JsonUtil.toJsonNode((String)source);
        String fileId = jsonNode.get("fileId").asText();
        String fileName = jsonNode.get("fileName").asText();
        String suffix = FileUtil.getFileExt((String)fileName);
        FileType fileType = FileType.typeFromFileName((String)fileName);
        if ("officeFilePreviewImpl".equalsIgnoreCase(fileType.getInstanceName())) {
            boolean isHtml = suffix.equalsIgnoreCase("xls") || suffix.equalsIgnoreCase("xlsx");
            String previewExtName = isHtml ? "html" : "pdf";
            String basePath = ConfigConstants.getFileDir();
            basePath = basePath + "jms";
            new File(basePath).mkdirs();
            String inputFilePath = basePath + File.separator + fileId + "." + suffix;
            String outputFilePath = basePath + File.separator + fileId + "." + previewExtName;
            FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
            fileManager.downloadFileToPath((DefaultFile)fileManager.get((Serializable)((Object)fileId)), inputFilePath);
            this.officeToPdfService.openOfficeToPDF(inputFilePath, outputFilePath);
            String folder = "";
            if (!isHtml) {
                this.fileHandlerService.pdf2jpg(outputFilePath);
            }
        } else if ("pdfFilePreviewImpl".equalsIgnoreCase(fileType.getInstanceName())) {
            String basePath = ConfigConstants.getFileDir();
            basePath = basePath + "jms";
            new File(basePath).mkdirs();
            String inputFilePath = basePath + File.separator + fileId + "." + suffix;
            FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
            fileManager.downloadFileToPath((DefaultFile)fileManager.get((Serializable)((Object)fileId)), inputFilePath);
            this.fileHandlerService.pdf2jpg(inputFilePath);
        }
        System.out.println(source);
    }
}

