/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.entity.AutoFillModel;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.portal.model.AppModel;
import com.hotent.portal.model.AppModelList;
import com.hotent.portal.params.AppTree;
import com.hotent.portal.persistence.dao.AppModelDao;
import com.hotent.portal.persistence.manager.AppModelManager;
import com.hotent.sys.persistence.dao.SysAuthUserDao;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.sys.persistence.manager.SysCategoryManager;
import com.hotent.sys.persistence.manager.SysRecentlyAppManager;
import com.hotent.sys.persistence.manager.SysTypeManager;
import com.hotent.sys.persistence.model.SysAuthUser;
import com.hotent.sys.persistence.model.SysCategory;
import com.hotent.sys.persistence.model.SysRecentlyApp;
import com.hotent.sys.persistence.model.SysType;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="appModelManager")
public class AppModelManagerImpl
extends BaseManagerImpl<AppModelDao, AppModel>
implements AppModelManager {
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    SysAuthUserDao sysAuthUserDao;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    SysCategoryManager sysCategoryManager;
    @Resource
    SysRecentlyAppManager sysRecentlyAppManager;

    @Override
    public List<AppModel> getByTypeId(String typeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.eq((Object)"TYPE_ID_", (Object)typeId)).eq((Object)"ENABLE_", (Object)1);
        });
        queryWrapper.orderByAsc((Object)"SN_");
        queryWrapper.orderByDesc((Object)"CREATE_TIME_");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, String> exportData(List<String> ids) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        AppModelList appModelList = new AppModelList();
        for (String id : ids) {
            AppModel appModel = (AppModel)this.get((Serializable)((Object)id));
            SysType sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)appModel.getTypeId()));
            if (sysType == null && (sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("appType", "mrfl")) == null) {
                sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("appType", "default");
            }
            appModel.setTypeKey(sysType.getTypeKey());
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("authorize_id_", id);
            List sysAuthUserList = this.sysAuthUserDao.selectByMap(condition);
            for (SysAuthUser sysAuthUser : sysAuthUserList) {
                String code;
                CommonResult result;
                String rightType = sysAuthUser.getRightType();
                String ownerId = sysAuthUser.getOwnerId();
                if ("user".equals(rightType)) {
                    result = this.ucFeignService.getUserById(ownerId);
                    if (!BeanUtils.isNotEmpty((Object)result)) continue;
                    JsonNode userNode = (JsonNode)result.getValue();
                    String account = JsonUtil.getString((JsonNode)userNode, (String)"account");
                    sysAuthUser.setOwnerCode(account);
                    continue;
                }
                if ("org".equals(rightType)) {
                    ObjectNode orgObjNode = this.ucFeignService.getOrgByIdOrCode(ownerId);
                    if (!BeanUtils.isNotEmpty((Object)orgObjNode)) continue;
                    String code2 = orgObjNode.get("code").asText();
                    sysAuthUser.setOwnerCode(code2);
                    continue;
                }
                if ("pos".equals(rightType)) {
                    result = this.ucFeignService.getPostByIdOrCode(ownerId);
                    if (!result.getState().booleanValue() || !BeanUtils.isNotEmpty((Object)result.getValue())) continue;
                    ObjectNode posObjNode = (ObjectNode)result.getValue();
                    code = posObjNode.get("code").asText();
                    sysAuthUser.setOwnerCode(code);
                    continue;
                }
                if (!"role".equals(rightType) || !(result = this.ucFeignService.getRoleByIdOrCode(ownerId)).getState().booleanValue() || !BeanUtils.isNotEmpty((Object)result.getValue())) continue;
                ObjectNode roleObjNode = (ObjectNode)result.getValue();
                code = roleObjNode.get("code").asText();
                sysAuthUser.setOwnerCode(code);
            }
            appModel.setSysAuthUserList(sysAuthUserList);
            appModelList.addAppModel(appModel);
        }
        try {
            String xml = JAXBUtil.marshall((Object)appModelList, AppModelList.class);
            map.put("appModels.portal.xml", xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    @Transactional
    public void importData(MultipartFile file) {
        File formDir;
        String unZipFilePath = null;
        try {
            String rootRealPath = Paths.get(FileUtil.getIoTmpdir(), "/attachFiles/unZip").toString();
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            unZipFilePath = Paths.get(rootRealPath, fileDir).toString();
            String xml = FileUtil.readFile((String)Paths.get(unZipFilePath, "appModels.portal.xml").toString());
            if (StringUtil.isEmpty((String)xml)) {
                throw new BaseException("\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9\uff01");
            }
            AppModelList list = (AppModelList)JAXBUtil.unmarshall((String)xml, AppModelList.class);
            List<AppModel> appModelList = list.getAppModelList();
            for (AppModel appModel : appModelList) {
                this.importData(appModel);
            }
        }
        catch (Exception e) {
            try {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                File formDir2;
                if (StringUtil.isNotEmpty(unZipFilePath) && (formDir2 = new File(unZipFilePath)).exists()) {
                    FileUtil.deleteDir((File)formDir2);
                }
                throw throwable;
            }
        }
        if (StringUtil.isNotEmpty((String)unZipFilePath) && (formDir = new File(unZipFilePath)).exists()) {
            FileUtil.deleteDir((File)formDir);
        }
    }

    @Override
    public List<AppTree> getApp(String typeKey) throws Exception {
        SysCategory sysCategory = this.sysCategoryManager.getByTypeKey(typeKey);
        ArrayList<AppTree> appTrees = new ArrayList<AppTree>();
        if (BeanUtils.isEmpty((Object)sysCategory)) {
            return appTrees;
        }
        IUser user = ContextUtil.getCurrentUser();
        List list = this.sysTypeManager.getByGroupKey(sysCategory.getGroupKey());
        List newList = this.sysAuthUserManager.getAuthItems(list, SysType::getId, user.getUserId(), AutoFillModel::getCreateBy);
        List<String> authList = newList.stream().map(SysType::getId).collect(Collectors.toList());
        for (SysType sysType : list) {
            List appList = this.getByTypeId(sysType.getId());
            if (!user.isAdmin()) {
                appList = this.sysAuthUserManager.getAuthItems(appList, AppModel::getId, user.getUserId(), AppModel::getCreateBy);
            }
            AppTree appItem = new AppTree();
            appItem.setTypeId(sysType.getId());
            appItem.setTypeName(sysType.getName());
            appItem.setPid(sysType.getParentId());
            appItem.setAppList(appList);
            appTrees.add(appItem);
        }
        List<AppTree> rtnList = BeanUtils.listToTree(appTrees);
        if (!user.isAdmin()) {
            rtnList = this.traversalTree(rtnList, authList, false);
        }
        return rtnList;
    }

    @Override
    public CommonResult<String> importData(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String msg;
            CommonResult message = new CommonResult("\u5bfc\u5165\u6210\u529f");
            this.importData(request.getFile("file"));
            LinkedHashSet appModelsSaved = ThreadMsgUtil.getMapMsg2((String)"appModelsSaved");
            LinkedHashSet appModelsSkipped = ThreadMsgUtil.getMapMsg2((String)"appModelsSkipped");
            StringBuilder sb = new StringBuilder();
            if (BeanUtils.isNotEmpty((Object)appModelsSkipped)) {
                sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u79fb\u52a8\u7aef\u5e94\u7528\u5df2\u5b58\u5728\u6545\u8df3\u8fc7\uff1a</div>");
                msg = String.format("%s", String.join((CharSequence)"", appModelsSkipped));
                sb.append(msg);
            }
            if (StringUtil.isNotEmpty((String)(msg = sb.toString()))) {
                message.setMessage(msg);
            }
            return message;
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public CommonResult<String> createOrUpdate(AppModel appModel) {
        String msg = "\u6dfb\u52a0\u79fb\u52a8\u7aef\u5e94\u7528\u6210\u529f";
        IUser user = ContextUtil.getCurrentUser();
        if (StringUtil.isEmpty((String)appModel.getId())) {
            appModel.setCreateBy(user.getUserId());
            appModel.setCreateTime(LocalDateTime.now());
            this.create((Model)appModel);
            this.sysAuthUserManager.createDefault(appModel.getId());
        } else {
            appModel.setUpdateBy(user.getUserId());
            appModel.setUpdateTime(LocalDateTime.now());
            this.update((Model)appModel);
            msg = "\u66f4\u65b0\u79fb\u52a8\u7aef\u5e94\u7528\u6210\u529f";
        }
        return new CommonResult(true, msg);
    }

    private List<AppTree> traversalTree(List<AppTree> appTrees, List<String> authList, boolean isShow) {
        ArrayList<AppTree> trees = new ArrayList<AppTree>();
        for (AppTree tree : appTrees) {
            if (authList.contains(tree.getId())) {
                List<AppTree> children = this.traversalTree(tree.getChildren(), authList, true);
                tree.setChildren(children);
                trees.add(tree);
                continue;
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"authorize_id_", (Object)tree.getId());
            wrapper.eq((Object)"obj_type_", (Object)"app");
            if (this.sysAuthUserManager.count((Wrapper)wrapper) > 0 || !isShow) continue;
            List<AppTree> children = this.traversalTree(tree.getChildren(), authList, true);
            tree.setChildren(children);
            trees.add(tree);
        }
        return trees;
    }

    private void importData(AppModel appModel) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"name_", (Object)appModel.getName());
        List appModelList = ((AppModelDao)this.baseMapper).selectList((Wrapper)wrapper);
        if (appModelList != null && !appModelList.isEmpty()) {
            ThreadMsgUtil.addMapMsg2((String)"appModelsSkipped", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s</div>", appModel.getName() + ""));
            return;
        }
        String appId = UniqueIdUtil.getSuid();
        appModel.setId(appId);
        SysType sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("appType", appModel.getTypeKey());
        if (sysType == null && (sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("appType", "mrfl")) == null) {
            sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("appType", "default");
        }
        appModel.setTypeId(sysType.getId());
        appModel.setTypeName(sysType.getName());
        List<SysAuthUser> sysAuthUserList = appModel.getSysAuthUserList();
        if (BeanUtils.isEmpty(sysAuthUserList)) {
            this.sysAuthUserManager.createDefault(appId);
        } else {
            for (SysAuthUser sysAuthUser : sysAuthUserList) {
                String ownerName;
                String ownerId;
                CommonResult result;
                String ownerName2;
                String ownerId2;
                String authId = UniqueIdUtil.getSuid();
                sysAuthUser.setId(authId);
                sysAuthUser.setAuthorizeId(appId);
                String rightType = sysAuthUser.getRightType();
                String ownerCode = sysAuthUser.getOwnerCode();
                if ("user".equals(rightType)) {
                    JsonNode userNode = this.ucFeignService.getUser(ownerCode, null);
                    if (BeanUtils.isNotEmpty((Object)userNode)) {
                        ownerId2 = JsonUtil.getString((JsonNode)userNode, (String)"id");
                        ownerName2 = JsonUtil.getString((JsonNode)userNode, (String)"fullname");
                        sysAuthUser.setOwnerId(ownerId2);
                        sysAuthUser.setOwnerName(ownerName2);
                    }
                } else if ("org".equals(rightType)) {
                    ObjectNode orgObjNode = this.ucFeignService.getOrgByIdOrCode(ownerCode);
                    if (BeanUtils.isNotEmpty((Object)orgObjNode)) {
                        ownerId2 = orgObjNode.get("id").asText();
                        ownerName2 = orgObjNode.get("name").asText();
                        sysAuthUser.setOwnerId(ownerId2);
                        sysAuthUser.setOwnerName(ownerName2);
                    }
                } else if ("pos".equals(rightType)) {
                    result = this.ucFeignService.getPostByIdOrCode(ownerCode);
                    if (result.getState().booleanValue() && BeanUtils.isNotEmpty((Object)result.getValue())) {
                        ObjectNode posObjNode = (ObjectNode)result.getValue();
                        ownerId = posObjNode.get("id").asText();
                        ownerName = posObjNode.get("name").asText();
                        sysAuthUser.setOwnerId(ownerId);
                        sysAuthUser.setOwnerName(ownerName);
                    }
                } else if ("role".equals(rightType) && (result = this.ucFeignService.getRoleByIdOrCode(ownerCode)).getState().booleanValue() && BeanUtils.isNotEmpty((Object)result.getValue())) {
                    ObjectNode roleObjNode = (ObjectNode)result.getValue();
                    ownerId = roleObjNode.get("id").asText();
                    ownerName = roleObjNode.get("name").asText();
                    sysAuthUser.setOwnerId(ownerId);
                    sysAuthUser.setOwnerName(ownerName);
                }
                this.sysAuthUserDao.insert((Object)sysAuthUser);
            }
        }
        this.create((Model)appModel);
        ThreadMsgUtil.addMapMsg2((String)"appModelsSaved", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s</div>", appModel.getName() + ""));
    }

    public PageList<AppModel> query(QueryFilter<AppModel> queryFilter) {
        return new PageList(((AppModelDao)this.baseMapper).customQuery((IPage<AppModel>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<AppModel>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    @Override
    public List<AppModel> getRecentlyApps() throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(4)));
        IUser currentUser = ContextUtil.getCurrentUser();
        queryFilter.addFilter("ACCOUNT_", (Object)currentUser.getAccount(), QueryOP.EQUAL);
        FieldSort fieldSort = new FieldSort("COUNT_", Direction.DESC);
        queryFilter.getSorter().add(fieldSort);
        queryFilter.addFilter("ENABLE_", (Object)1, QueryOP.EQUAL);
        List list = ((AppModelDao)this.baseMapper).getRecentlyApps((IPage<AppModel>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<AppModel>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (!currentUser.isAdmin()) {
            list = this.sysAuthUserManager.getAuthItems(list, AppModel::getId, currentUser.getUserId(), AppModel::getCreateBy);
        }
        return list;
    }

    @Override
    public CommonResult<Boolean> addRecentlyAppsCount(String account, String appId) throws Exception {
        LambdaQueryWrapper queryWrapper;
        SysRecentlyApp sysRecentlyApp;
        if (StringUtil.isEmpty((String)account)) {
            account = ContextUtil.getCurrentUser().getAccount();
        }
        if (BeanUtils.isNotEmpty((Object)(sysRecentlyApp = (SysRecentlyApp)this.sysRecentlyAppManager.getOne((Wrapper)(queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysRecentlyApp::getAccount, (Object)account)).eq(SysRecentlyApp::getAppId, (Object)appId))))) && StringUtil.isNotEmpty((String)sysRecentlyApp.getId())) {
            sysRecentlyApp.setCount(Integer.valueOf(sysRecentlyApp.getCount() + 1));
            this.sysRecentlyAppManager.update((Model)sysRecentlyApp);
            return CommonResult.ok();
        }
        sysRecentlyApp = new SysRecentlyApp();
        sysRecentlyApp.setAccount(account);
        sysRecentlyApp.setAppId(appId);
        sysRecentlyApp.setCount(Integer.valueOf(1));
        sysRecentlyApp.setId(UniqueIdUtil.getSuid());
        this.sysRecentlyAppManager.save((Object)sysRecentlyApp);
        return CommonResult.ok();
    }
}

