/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.JmsAtt;
import com.hotent.base.jms.JmsMessage;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.jms.Notice;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.file.model.DefaultFile;
import com.hotent.file.model.UploadResult;
import com.hotent.file.persistence.manager.FileManager;
import com.hotent.file.print.model.WordPrintParam;
import com.hotent.portal.jms.impl.MailHandler;
import com.hotent.portal.model.MailTemplate;
import com.hotent.portal.persistence.dao.MailTemplateDao;
import com.hotent.portal.persistence.manager.MailTemplateManager;
import com.hotent.uc.api.impl.model.UserFacade;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MailTemplateManagerImpl
extends BaseManagerImpl<MailTemplateDao, MailTemplate>
implements MailTemplateManager {
    @Resource
    MailHandler mailHandler;
    @Resource
    FileManager fileManager;

    @Override
    public MailTemplate getDetail(String id) {
        MailTemplate MailTemplate2 = (MailTemplate)this.get((Serializable)((Object)id));
        return MailTemplate2;
    }

    @Transactional
    public boolean save(MailTemplate mailTemplate) {
        mailTemplate.setCreateOrgId(ContextUtil.getCurrentGroupId());
        return super.save((Object)mailTemplate);
    }

    @Transactional
    public boolean updateById(MailTemplate mailTemplate) {
        return SqlHelper.retBool((Integer)((MailTemplateDao)this.getBaseMapper()).updateById((Object)mailTemplate));
    }

    @Override
    public void executeMailTemplateJob() throws Exception {
        List<MailTemplate> mailTemplates = this.getAll();
        mailTemplates = this.findSendMailTemplate(mailTemplates);
        HashMap<String, Exception> exceptions = new HashMap<String, Exception>();
        for (MailTemplate mailTemplate : mailTemplates) {
            try {
                String receiver = mailTemplate.getReceiver();
                JsonNode receiverJson = JsonUtil.toJsonNode((String)receiver);
                String receiverType = JsonUtil.getString((JsonNode)receiverJson, (String)"type");
                String value = JsonUtil.getString((JsonNode)receiverJson, (String)"value");
                List<IUser> receiverUser = this.getUserByReceiver(mailTemplate, receiverType, value);
                if (mailTemplate.getType().equals("private")) {
                    for (IUser user : receiverUser) {
                        Map<String, Object> sourceResult = this.getSourceResult(mailTemplate.getSource(), this.getSourceVariable(mailTemplate, user), null);
                        String handleEmailContentTemplate = this.handleEmailContentTemplate(mailTemplate.getEmailContentTemplate(), sourceResult);
                        DefaultFile defaultFile = this.wordPrint(mailTemplate, sourceResult);
                        this.mailHandler.send(this.buildJmsMessage(mailTemplate, user, handleEmailContentTemplate, defaultFile));
                    }
                } else {
                    Map<String, Object> sourceResult = this.getSourceResult(mailTemplate.getSource(), this.getSourceVariable(mailTemplate, null), null);
                    String handleEmailContentTemplate = this.handleEmailContentTemplate(mailTemplate.getEmailContentTemplate(), sourceResult);
                    DefaultFile defaultFile = this.wordPrint(mailTemplate, sourceResult);
                    this.mailHandler.send(this.buildJmsMessage(mailTemplate, receiverUser, handleEmailContentTemplate, defaultFile));
                }
                String messageContent = MailTemplateManagerImpl.getStrByRule(mailTemplate.getMessageContent(), this.getMessageContentVariable(mailTemplate));
                IUser sender = ((IUserService)AppUtil.getBean(IUserService.class)).getUserById(mailTemplate.getCreateBy());
                MailTemplateManagerImpl.sendMsgNoTemplate(mailTemplate.getMessageType(), receiverUser, messageContent, sender);
                this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(MailTemplate::getId, (Object)mailTemplate.getId())).set(MailTemplate::getLatestSendingTime, (Object)LocalDateTime.now()));
            }
            catch (Exception e) {
                exceptions.put(mailTemplate.getTitle(), e);
            }
        }
        if (CollUtil.isNotEmpty(exceptions)) {
            throw new BaseException("\u5f02\u5e38\u4fe1\u606f\uff1a" + JsonUtil.toJsonString(exceptions));
        }
    }

    private List<MailTemplate> findSendMailTemplate(List<MailTemplate> mailTemplates) throws Exception {
        ArrayList<MailTemplate> list = new ArrayList<MailTemplate>();
        for (MailTemplate mailTemplate : mailTemplates) {
            LocalDateTime latestSendingTime = mailTemplate.getLatestSendingTime();
            String sendTiming = mailTemplate.getSendTiming();
            JsonNode sendTimingNode = JsonUtil.toJsonNode((String)sendTiming);
            String type = JsonUtil.getString((JsonNode)sendTimingNode, (String)"type");
            String value = JsonUtil.getString((JsonNode)sendTimingNode, (String)"currentDate");
            LocalDateTime parse = DateFormatUtil.parse((String)value);
            String date = JsonUtil.getString((JsonNode)sendTimingNode, (String)"date");
            switch (type) {
                case "once": {
                    if (!BeanUtils.isEmpty((Object)latestSendingTime) || !parse.isBefore(LocalDateTime.now())) break;
                    list.add(mailTemplate);
                    break;
                }
                case "day": {
                    if (BeanUtils.isEmpty((Object)latestSendingTime)) {
                        if (!parse.isBefore(LocalDateTime.now())) break;
                        list.add(mailTemplate);
                        break;
                    }
                    if (!parse.isBefore(LocalDateTime.now()) || !latestSendingTime.toLocalDate().equals(LocalDate.now().minusDays(1L))) break;
                    list.add(mailTemplate);
                    break;
                }
                case "week": {
                    String week = String.valueOf(LocalDate.now().getDayOfWeek().getValue());
                    if (!Arrays.asList(date.split(",")).contains(week) || !parse.isBefore(LocalDateTime.now())) break;
                    list.add(mailTemplate);
                    break;
                }
                case "month": {
                    String month = String.valueOf(LocalDate.now().getDayOfMonth());
                    if (!Arrays.asList(date.split(",")).contains(month) || !parse.isBefore(LocalDateTime.now())) break;
                    list.add(mailTemplate);
                }
            }
        }
        return list;
    }

    private JmsMessage buildJmsMessage(MailTemplate mailTemplate, IUser receiver, String content, DefaultFile file) throws Exception {
        JmsMessage jmsMessage = new JmsMessage();
        jmsMessage.setContent(content);
        List<JmsActor> ccList = this.getCC(mailTemplate);
        jmsMessage.setCcUsers(ccList);
        jmsMessage.setReceivers(Collections.singletonList(BeanUtil.toBean((Object)receiver, JmsActor.class)));
        if (BeanUtils.isNotEmpty((Object)file)) {
            jmsMessage.setAttList(Collections.singletonList(new JmsAtt(file.getId(), file.getFileName() + "." + file.getExtensionName())));
        }
        jmsMessage.setSubject(MailTemplateManagerImpl.getStrByRule(mailTemplate.getTitle(), this.getTitleVariable(mailTemplate, receiver)));
        jmsMessage.setContent(content);
        jmsMessage.setType(NoticeMessageType.MAIL.key());
        return jmsMessage;
    }

    private List<JmsActor> getCC(MailTemplate mailTemplate) throws Exception {
        ArrayList<JmsActor> ccList = new ArrayList<JmsActor>();
        String cc = mailTemplate.getCc();
        JsonNode ccJson = JsonUtil.toJsonNode((String)cc);
        String ccType = JsonUtil.getString((JsonNode)ccJson, (String)"type");
        String value = JsonUtil.getString((JsonNode)ccJson, (String)"value");
        if (StringUtil.isNotEmpty((String)value)) {
            List<IUser> ccUser = this.getUserByReceiver(mailTemplate, ccType, value);
            for (IUser user : ccUser) {
                ccList.add((JmsActor)BeanUtil.toBean((Object)user, JmsActor.class));
            }
        }
        return ccList;
    }

    private JmsMessage buildJmsMessage(MailTemplate mailTemplate, List<IUser> receiver, String content, DefaultFile file) throws Exception {
        JmsMessage jmsMessage = new JmsMessage();
        List<JmsActor> ccList = this.getCC(mailTemplate);
        jmsMessage.setContent(content);
        jmsMessage.setCcUsers(ccList);
        jmsMessage.setReceivers(BeanUtil.copyToList(receiver, JmsActor.class));
        if (file != null) {
            jmsMessage.setAttList(Collections.singletonList(new JmsAtt(file.getId(), file.getFileName() + "." + file.getExtensionName())));
        }
        jmsMessage.setSubject(MailTemplateManagerImpl.getStrByRule(mailTemplate.getTitle(), this.getTitleVariable(mailTemplate, null)));
        jmsMessage.setContent(content);
        jmsMessage.setType(NoticeMessageType.MAIL.key());
        return jmsMessage;
    }

    private List<IUser> getUserByReceiver(MailTemplate mailTemplate, String receiverType, String value) throws Exception {
        List<Object> list = new ArrayList<IUser>();
        switch (receiverType) {
            case "account": {
                String[] split = value.split("\\.");
                String alias = split[0];
                String field = split[1];
                Map<String, Object> sourceResult = this.getSourceResult(mailTemplate.getSource(), this.getSourceVariable(mailTemplate, null), Collections.singletonList(alias));
                List result = (List)sourceResult.get(alias);
                List userAccount = result.stream().filter(map -> StringUtil.isNotEmpty((String)MapUtil.getString((Map)map, (String)field))).map(map -> MapUtil.getString((Map)map, (String)field)).collect(Collectors.toList());
                if (!BeanUtils.isNotEmpty(userAccount)) break;
                IUserService userServiceImpl = (IUserService)AppUtil.getBean(IUserService.class);
                list = userServiceImpl.getUserByAccounts(String.join((CharSequence)",", userAccount));
                break;
            }
            case "user": {
                if (!StringUtil.isNotEmpty((String)value)) break;
                IUserService userServiceImpl = (IUserService)AppUtil.getBean(IUserService.class);
                list = userServiceImpl.getUserByAccounts(value);
                break;
            }
            case "role": {
                for (String code : value.split(",")) {
                    ArrayNode usersByRoleCode = ((UCFeignService)AppUtil.getBean(UCFeignService.class)).getUsersByRoleCode(code);
                    for (JsonNode j : usersByRoleCode) {
                        list.add((IUser)JsonUtil.toBean((JsonNode)j, UserFacade.class));
                    }
                }
                break;
            }
        }
        return list;
    }

    private Map<String, Object> getSourceVariable(MailTemplate mailTemplate, IUser receiver) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String createBy = mailTemplate.getCreateBy();
        IUser createUser = ((IUserService)AppUtil.getBean(IUserService.class)).getUserById(createBy);
        map.put("creatorName", createUser.getFullname());
        map.put("creatorAccount", createUser.getAccount());
        map.put("creatorId", createUser.getUserId());
        String createOrgId = mailTemplate.getCreateOrgId();
        if (StringUtil.isNotEmpty((String)createOrgId)) {
            ObjectNode org = ((UCFeignService)AppUtil.getBean(UCFeignService.class)).getOrgById(createOrgId);
            map.put("creatorOrgId", JsonUtil.getString((JsonNode)org, (String)"id"));
            map.put("creatorOrgCode", JsonUtil.getString((JsonNode)org, (String)"code"));
        }
        map.put("receiverName", BeanUtils.isNotEmpty((Object)receiver) ? receiver.getFullname() : "");
        map.put("receiverAccount", BeanUtils.isNotEmpty((Object)receiver) ? receiver.getAccount() : "");
        map.put("receiverId", BeanUtils.isNotEmpty((Object)receiver) ? receiver.getUserId() : "");
        return map;
    }

    private Map<String, Object> getTitleVariable(MailTemplate mailTemplate, IUser receiver) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String createBy = mailTemplate.getCreateBy();
        String createOrgId = mailTemplate.getCreateOrgId();
        IUser createUser = ((IUserService)AppUtil.getBean(IUserService.class)).getUserById(createBy);
        map.put("creatorName", createUser.getFullname());
        if (BeanUtils.isNotEmpty((Object)createOrgId)) {
            ObjectNode org = ((UCFeignService)AppUtil.getBean(UCFeignService.class)).getOrgById(createOrgId);
            map.put("creatorOrgName", JsonUtil.getString((JsonNode)org, (String)"name"));
        }
        map.put("receiverName", BeanUtils.isNotEmpty((Object)receiver) ? receiver.getFullname() : "");
        map.put("yyyy", DateUtil.getCurrentTime((String)"yyyy"));
        map.put("mm", DateUtil.getCurrentTime((String)"MM"));
        map.put("dd", DateUtil.getCurrentTime((String)"dd"));
        return map;
    }

    private Map<String, Object> getMessageContentVariable(MailTemplate mailTemplate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String createOrgId = mailTemplate.getCreateOrgId();
        String createBy = mailTemplate.getCreateBy();
        IUser createUser = ((IUserService)AppUtil.getBean(IUserService.class)).getUserById(createBy);
        if (BeanUtils.isNotEmpty((Object)createOrgId)) {
            ObjectNode org = ((UCFeignService)AppUtil.getBean(UCFeignService.class)).getOrgById(createOrgId);
            map.put("creatorOrgName", JsonUtil.getString((JsonNode)org, (String)"name"));
        }
        map.put("creatorName", createUser.getFullname());
        map.put("subject", mailTemplate.getSubject());
        return map;
    }

    private Map<String, Object> getSourceResult(String source, Map<String, Object> map, List<String> appointList) throws Exception {
        HashMap<String, Object> sourceResult = new HashMap<String, Object>();
        String queryData = "";
        ArrayNode sourceJsonList = (ArrayNode)JsonUtil.toJsonNode((String)source);
        for (JsonNode sourceJson : sourceJsonList) {
            ArrayList<Map> list = new ArrayList<Map>();
            String alias = JsonUtil.getString((JsonNode)sourceJson, (String)"alias");
            if (BeanUtils.isNotEmpty(appointList) && !appointList.contains(alias)) continue;
            ArrayNode conditionfield = JsonUtil.getArray((JsonNode)sourceJson, (String)"conditionfield");
            ArrayNode arrayNode = JsonUtil.createArrayNode();
            for (JsonNode jsonNode : conditionfield) {
                ObjectNode node = JsonUtil.createObjectNode();
                node.put("key", JsonUtil.getString((JsonNode)jsonNode, (String)"field"));
                String value = JsonUtil.getString((JsonNode)jsonNode, (String)"fieldPath");
                String valueType = JsonUtil.getString((JsonNode)jsonNode, (String)"type");
                if ("1".equals(valueType) && StringUtil.isEmpty((String)(value = StringUtil.getStrByRule((String)value, map, (String)"\\{(.*?)\\}")))) {
                    value = JsonUtil.getString((JsonNode)jsonNode, (String)"defaultValue");
                }
                if ("3".equals(valueType)) {
                    GroovyScriptEngine groovyScriptEngine = new GroovyScriptEngine();
                    value = groovyScriptEngine.executeString(value, map);
                }
                node.put("value", value);
                arrayNode.add((JsonNode)node);
            }
            if (BeanUtils.isNotEmpty((Object)arrayNode) && arrayNode.size() > 0) {
                queryData = JsonUtil.toJson((Object)arrayNode);
            }
            Object obj = ((FormFeignService)AppUtil.getBean(FormFeignService.class)).doCustomQuery(alias, Integer.valueOf(0), queryData);
            List rows = null;
            if (obj instanceof List) {
                rows = (List)obj;
            } else {
                PageList pageList = this.getPageList(obj);
                if (pageList != null && CollUtil.isNotEmpty((Collection)pageList.getRows())) {
                    rows = pageList.getRows();
                }
            }
            if (rows == null) continue;
            for (Object row : rows) {
                list.add(JsonUtil.toMap((String)JsonUtil.toJson(row)));
            }
            sourceResult.put(alias, list);
        }
        return sourceResult;
    }

    private PageList getPageList(Object object) {
        if (object instanceof PageList) {
            return (PageList)object;
        }
        if (object instanceof Map) {
            try {
                String json = JsonUtil.toJson((Object)object);
                return (PageList)JsonUtil.toBean((String)json, PageList.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String handleEmailContentTemplate(String emailContentTemplate, Map<String, Object> map) throws Exception {
        Document doc = Jsoup.parse((String)emailContentTemplate);
        Elements htmlList = doc.children();
        for (Element html : htmlList) {
            if (!html.nodeName().equals("html")) continue;
            Elements bodyList = html.children();
            for (Element body : bodyList) {
                if (!body.nodeName().equals("body")) continue;
                Elements tableList = body.children();
                for (Element tableNode : tableList) {
                    if (!tableNode.nodeName().equals("table")) continue;
                    Elements tables = tableNode.children();
                    for (Element table : tables) {
                        String alias = "";
                        String tableText = table.text();
                        String[] split1 = tableText.split("\\{\\{");
                        if (split1.length > 2) {
                            String[] split2 = split1[1].split("\\.");
                            String string = alias = split2.length > 0 ? split2[0] : alias;
                        }
                        if (!BeanUtils.isNotEmpty((Object)alias)) continue;
                        List list = (List)map.get(alias);
                        Elements td = table.children();
                        if (!BeanUtils.isNotEmpty((Object)td) || td.size() <= 1) continue;
                        Element trTwo = td.get(1);
                        if (list.size() > 1) {
                            for (int i = 1; i < list.size(); ++i) {
                                Element clone = trTwo.clone();
                                for (Element child : clone.children()) {
                                    String text = child.text();
                                    String str = MailTemplateManagerImpl.getStrByRule(text, (Map)list.get(i));
                                    child.text(str);
                                }
                                table.appendChild((Node)clone);
                            }
                        }
                        for (Element child : trTwo.children()) {
                            String text = child.text();
                            String str = "";
                            if (BeanUtils.isNotEmpty((Object)list)) {
                                str = MailTemplateManagerImpl.getStrByRule(text, (Map)list.get(0));
                            }
                            child.text(str);
                        }
                    }
                }
            }
        }
        emailContentTemplate = MailTemplateManagerImpl.getStrByRule(doc.body().html().replace("\n", ""), map);
        return emailContentTemplate;
    }

    private DefaultFile wordPrint(MailTemplate mailTemplate, Map<String, Object> map) throws Exception {
        if (StringUtil.isEmpty((String)mailTemplate.getAttachmentTemplate())) {
            return null;
        }
        WordPrintParam wordPrintParam = new WordPrintParam();
        String attachmentTemplate = mailTemplate.getAttachmentTemplate();
        ArrayNode file = (ArrayNode)JsonUtil.toJsonNode((String)attachmentTemplate);
        if (file.size() == 0) {
            return null;
        }
        UploadResult uploadResult = (UploadResult)JsonUtil.toBean((JsonNode)file.get(0), UploadResult.class);
        String attachmentTemplateScript = mailTemplate.getAttachmentTemplateScript();
        wordPrintParam.setScriptStr(attachmentTemplateScript);
        wordPrintParam.setFileId(uploadResult.getFileId());
        wordPrintParam.setSubject(mailTemplate.getSubject() + "\u5957\u6253\u6587\u4ef6");
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        for (String s : map.keySet()) {
            if (map.get(s) instanceof Map) {
                variableMap.putAll((Map)map.get(s));
                continue;
            }
            if (map.get(s) instanceof List) {
                Map listOne = (Map)((List)map.get(s)).get(0);
                for (String key : listOne.keySet()) {
                    variableMap.put(s + "_" + key, listOne.get(key));
                }
                variableMap.put(s, map.get(s));
                variableMap.put("sub_" + s, map.get(s));
                continue;
            }
            variableMap.put(s, map.get(s));
        }
        ObjectNode objectNode = JsonUtil.createObjectNode();
        objectNode.set("mailTemplate", JsonUtil.toJsonNode(variableMap));
        wordPrintParam.setBoData(JsonUtil.toJson((Object)objectNode));
        String wordPrintId = this.fileManager.wordPrint(wordPrintParam);
        return (DefaultFile)this.fileManager.get((Serializable)((Object)wordPrintId));
    }

    public static List<JmsActor> parseJmsActor(List<IUser> users) {
        ArrayList<JmsActor> actors = new ArrayList<JmsActor>();
        for (IUser user : users) {
            JmsActor actor = new JmsActor();
            actor.setId(user.getUserId());
            actor.setAccount(user.getAccount());
            actor.setName(user.getFullname());
            actor.setEmail(user.getEmail());
            actor.setMobile(user.getMobile());
            actor.setWeixin(user.getWeixin());
            actor.setClientId(user.getClientId());
            actor.setClientToken(user.getClientToken());
            actors.add(actor);
        }
        return actors;
    }

    public static NoticeMessageType[] parseNotifyType(String notifyType) {
        if (notifyType == null) {
            notifyType = "";
        }
        String[] arys = notifyType.split(",");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arys));
        return MailTemplateManagerImpl.parseNotifyType(list);
    }

    public static NoticeMessageType[] parseNotifyType(List<String> notifyType) {
        ArrayList<NoticeMessageType> messageTypeArrays = new ArrayList<NoticeMessageType>();
        EnumSet<NoticeMessageType> it = EnumSet.allOf(NoticeMessageType.class);
        for (NoticeMessageType type : it) {
            if (!notifyType.contains(type.key())) continue;
            messageTypeArrays.add(type);
        }
        NoticeMessageType[] messageTypes = new NoticeMessageType[messageTypeArrays.size()];
        messageTypeArrays.toArray(messageTypes);
        return messageTypes;
    }

    public static void sendMsgNoTemplate(String notifyType, List<IUser> receiver, String content, IUser sender) throws Exception {
        NoticeMessageType[] messageTypes = MailTemplateManagerImpl.parseNotifyType(notifyType);
        List<JmsActor> receiverAccounts = MailTemplateManagerImpl.parseJmsActor(receiver);
        Notice notice = new Notice();
        notice.setUseTemplate(false);
        notice.setVars(new HashMap());
        notice.setSubject(content);
        notice.setContent(content);
        notice.setMessageTypes(messageTypes);
        notice.setSender(sender.getAccount());
        notice.setReceiver(receiverAccounts);
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue((Object)notice);
    }

    private static String getStrByRule(String titleRule, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)titleRule)) {
            return "";
        }
        Pattern regex = Pattern.compile("\\{\\{(.*?)\\}\\}", 98);
        Matcher matcher = regex.matcher(titleRule);
        while (matcher.find()) {
            String tag = matcher.group(0);
            String rule = matcher.group(1);
            String[] aryRule = rule.split("\\.");
            String name = "";
            if (aryRule.length == 1) {
                name = rule;
            } else {
                if (map.get(aryRule[0]) instanceof Map) {
                    map = (Map)map.get(aryRule[0]);
                }
                if (map.get(aryRule[0]) instanceof List) {
                    map = (Map)((List)map.get(aryRule[0])).get(0);
                }
                name = aryRule[1];
            }
            if (map.containsKey(name)) {
                Object obj = map.get(name);
                if (obj != null) {
                    try {
                        if (obj instanceof Double) {
                            titleRule = titleRule.replace(tag, BigDecimal.valueOf((Double)obj).toPlainString());
                            continue;
                        }
                        titleRule = titleRule.replace(tag, obj.toString());
                    }
                    catch (Exception e) {
                        titleRule = titleRule.replace(tag, "");
                    }
                    continue;
                }
                titleRule = titleRule.replace(tag, "");
                continue;
            }
            String defaultValue = "";
            try {
                if (aryRule.length > 1) {
                    GroovyScriptEngine scriptEngine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
                    String script = rule.replace(aryRule[0] + ":", "");
                    defaultValue = scriptEngine.executeString(script, map);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            titleRule = titleRule.replace(tag, defaultValue);
        }
        return titleRule;
    }

    @Override
    public CommonResult<Map<String, Object>> preview(String account, String id) throws Exception {
        MailTemplate mailTemplate = (MailTemplate)this.get((Serializable)((Object)id));
        Assert.notNull((Object)((Object)mailTemplate), (String)"\u5f53\u524d\u90ae\u4ef6\u6a21\u677f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        IUser user = ContextUtil.getUserByAccount((String)account);
        Assert.notNull((Object)user, (String)"\u5f53\u524d\u8d26\u53f7\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Map<String, Object> sourceResult = this.getSourceResult(mailTemplate.getSource(), this.getSourceVariable(mailTemplate, user), null);
        String handleEmailContentTemplate = this.handleEmailContentTemplate(mailTemplate.getEmailContentTemplate(), sourceResult);
        DefaultFile defaultFile = this.wordPrint(mailTemplate, sourceResult);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("content", handleEmailContentTemplate);
        result.put("file", (String)defaultFile);
        return CommonResult.success(result);
    }
}

