/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.portal.model.MenuBookmark;
import com.hotent.portal.persistence.dao.MenuBookmarkDao;
import com.hotent.portal.persistence.manager.MenuBookmarkManager;
import com.hotent.sys.persistence.manager.SysMenuManager;
import com.hotent.sys.persistence.model.SysMenu;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MenuBookmarkManagerImpl
extends BaseManagerImpl<MenuBookmarkDao, MenuBookmark>
implements MenuBookmarkManager {
    @Resource
    SysMenuManager sysMenuManager;

    @Override
    public String handleBookmarkChange(String menuId, String currentUserId) {
        String message = null;
        List<MenuBookmark> bmk = this.getByMenuIdAndUserId(menuId, currentUserId);
        if (BeanUtils.isNotEmpty(bmk)) {
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"USER_ID_", (Object)currentUserId);
            qw.eq((Object)"MENU_ID_", (Object)menuId);
            this.remove((Wrapper)qw);
            message = "\u53d6\u6d88\u6536\u85cf\u6210\u529f";
        } else {
            SysMenu menu = this.sysMenuManager.getByIdAndTenant(menuId, "-1");
            if (BeanUtils.isEmpty((Object)menu)) {
                throw new BaseException("\u83dc\u5355\u4e0d\u5b58\u5728");
            }
            MenuBookmark mb = new MenuBookmark();
            mb.setAlias(menu.getAlias());
            mb.setMenuId(menuId);
            mb.setParentMenuId(menu.getParentId());
            mb.setHref(menu.getHref());
            mb.setUserId(currentUserId);
            mb.setName(menu.getName());
            this.create((Model)mb);
            message = "\u6536\u85cf\u6210\u529f";
        }
        return message;
    }

    @Override
    public void removeBookmarkByMenuIds(List<String> menuIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"USER_ID_", (Object)ContextUtil.getCurrentUserId())).in((Object)"MENU_ID_", menuIds);
        this.remove((Wrapper)queryWrapper);
    }

    private List<MenuBookmark> getByMenuIdAndUserId(String menuId, String userId) {
        QueryWrapper qw = new QueryWrapper();
        ((QueryWrapper)qw.eq((Object)"MENU_ID_", (Object)menuId)).eq((Object)"USER_ID_", (Object)userId);
        return this.list((Wrapper)qw);
    }
}

