/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.JmsMessage;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.portal.jms.impl.InnerHandler;
import com.hotent.portal.jms.impl.MailHandler;
import com.hotent.portal.jms.impl.SmsHandler;
import com.hotent.portal.jms.impl.VoiceHandler;
import com.hotent.portal.jms.impl.WxEnterpriseHandler;
import com.hotent.portal.model.MessageLog;
import com.hotent.portal.persistence.dao.MessageLogDao;
import com.hotent.portal.persistence.manager.MessageLogManager;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="messageLogManager")
public class MessageLogManagerImpl
extends BaseManagerImpl<MessageLogDao, MessageLog>
implements MessageLogManager {
    private static Logger log = LoggerFactory.getLogger(MessageLogManagerImpl.class);
    @Resource
    MailHandler mailHandler;
    @Resource
    InnerHandler innerHandler;
    @Resource
    WxEnterpriseHandler wxEnterpriseHandler;
    @Resource
    SmsHandler smsHandler;
    @Resource
    VoiceHandler voiceHandler;

    @Override
    public void reinvoke(String id) throws Exception {
        MessageLog messageLog = (MessageLog)this.get((Serializable)((Object)id));
        try {
            this.reinvokeByLog(messageLog);
        }
        catch (Exception e) {
            int time = BeanUtils.isEmpty((Object)messageLog.getRetryCount()) ? 0 : messageLog.getRetryCount();
            messageLog.setRetryCount(time + 1);
            String errorMsg = e.getMessage();
            if (StringUtil.isNotEmpty((String)errorMsg) && errorMsg.length() > 2000) {
                messageLog.setException(errorMsg.substring(0, 1999));
            } else {
                messageLog.setException(errorMsg);
            }
            this.update((Model)messageLog);
            throw new WorkFlowException("\u91cd\u8c03\u5931\u8d25\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    @Override
    public void signSuccess(String id) {
        MessageLog messageLog = (MessageLog)this.get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)((Object)messageLog))) {
            messageLog.setIsSuccess(MessageLog.SUCCESS_YES);
            this.update((Model)messageLog);
        }
    }

    private void reinvokeByLog(MessageLog messageLog) throws Exception {
        JmsMessage jmsMessage = (JmsMessage)JsonUtil.toBean((String)messageLog.getMsgVo(), JmsMessage.class);
        Object jmsHandler = null;
        if (NoticeMessageType.WXENTERPRISE.key().equals(jmsMessage.getType())) {
            jmsHandler = this.wxEnterpriseHandler;
        } else if (NoticeMessageType.MAIL.key().equals(jmsMessage.getType())) {
            jmsHandler = this.mailHandler;
        } else if (NoticeMessageType.SMS.key().equals(jmsMessage.getType())) {
            jmsHandler = this.smsHandler;
        } else if (NoticeMessageType.VOICE.key().equals(jmsMessage.getType())) {
            jmsHandler = this.voiceHandler;
        }
        if (jmsHandler != null) {
            jmsHandler.send(jmsMessage);
        }
        messageLog.setRetryCount(messageLog.getRetryCount() + 1);
        this.update((Model)messageLog);
    }

    @Override
    public void handLogByMsgHander(JmsMessage jmsMessage, boolean state, String errorMsg) {
        try {
            MessageLog msgLog = null;
            if (StringUtil.isNotEmpty((String)jmsMessage.getLogId())) {
                msgLog = (MessageLog)this.get((Serializable)((Object)jmsMessage.getLogId()));
            }
            if (BeanUtils.isEmpty(msgLog)) {
                msgLog = new MessageLog();
                msgLog.setId(UniqueIdUtil.getSuid());
                msgLog.setType(jmsMessage.getType());
                jmsMessage.setLogId(msgLog.getId());
                msgLog.setRetryCount(0);
            } else {
                int time = BeanUtils.isEmpty((Object)msgLog.getRetryCount()) ? 0 : msgLog.getRetryCount();
                msgLog.setRetryCount(time + 1);
            }
            JmsActor sender = jmsMessage.getSender();
            if (BeanUtils.isNotEmpty((Object)sender)) {
                msgLog.setSenderId(sender.getId());
                msgLog.setSenderName(sender.getName());
            }
            if (BeanUtils.isNotEmpty((Object)jmsMessage.getReceivers())) {
                msgLog.setReceivers(JsonUtil.toJson((Object)jmsMessage.getReceivers()));
            }
            msgLog.setSubject(jmsMessage.getSubject());
            msgLog.setContent(jmsMessage.getContent());
            msgLog.setMsgVo(JsonUtil.toJson((Object)jmsMessage));
            msgLog.setCreateTime(LocalDateTime.now());
            msgLog.setIsSuccess(state ? MessageLog.SUCCESS_YES : MessageLog.SUCCESS_NO);
            if (!state) {
                if (StringUtil.isNotEmpty((String)errorMsg) && errorMsg.length() > 2000) {
                    msgLog.setException(errorMsg.substring(0, 1999));
                } else {
                    msgLog.setException(errorMsg);
                }
            }
            if (BeanUtils.isNotEmpty((Object)msgLog.getRetryCount()) && msgLog.getRetryCount() > 0) {
                this.update((Model)msgLog);
            } else {
                this.create((Model)msgLog);
            }
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u6d88\u606f\u65e5\u5fd7\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

