/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.portal.model.Permission;
import com.hotent.portal.params.EipAuthVo;
import com.hotent.portal.persistence.dao.PermissionMapper;
import com.hotent.portal.persistence.manager.IPermissionService;
import com.hotent.sys.persistence.manager.CurrentUserService;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionServiceImpl
extends BaseManagerImpl<PermissionMapper, Permission>
implements IPermissionService {
    @Resource
    CurrentUserService currentUserService;
    @Resource
    IUserService userService;

    @Override
    public boolean removeByAuthorizeId(String authorizeId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Permission::getAuthorizeId, (Object)authorizeId);
        return ((PermissionMapper)this.baseMapper).delete((Wrapper)wrapper) > 0;
    }

    @Override
    public boolean removeByAuthorizeId(String objType, String authorizeId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Permission::getAuthorizeId, (Object)authorizeId);
        wrapper.eq(Permission::getObjType, (Object)objType);
        return ((PermissionMapper)this.baseMapper).delete((Wrapper)wrapper) > 0;
    }

    @Override
    public Map<String, Object> getRightMap() {
        return this.getRightMap(null);
    }

    @Override
    public Map<String, Object> getRightMap(String postCode) {
        String userId = ContextUtil.getCurrentUserId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("user", "'" + userId + "'");
        IUser user = this.userService.getUserById(userId);
        if (BeanUtils.isEmpty((Object)user)) {
            return map;
        }
        Map userRightMap = this.currentUserService.getUserRightMapString();
        if (BeanUtils.isNotEmpty((Object)userRightMap)) {
            for (String key : userRightMap.keySet()) {
                map.put(key, userRightMap.get(key));
            }
        }
        return map;
    }

    @Override
    public List<String> getAuthorizeId(Map<String, Object> rights, String objType) {
        return ((PermissionMapper)this.baseMapper).getAuthorizeId(rights, objType);
    }

    @Override
    @Transactional
    public CommonResult<String> createOrUpdate(Permission permission) {
        String[] ownerIdArray = permission.getOwnerId().split(",");
        String[] objNameArray = permission.getObjName().split(",");
        for (int i = 0; i < ownerIdArray.length; ++i) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(Permission::getAuthorizeId, (Object)permission.getAuthorizeId());
            wrapper.eq(Permission::getOwnerId, (Object)ownerIdArray[i]);
            wrapper.eq(Permission::getPermissionType, (Object)permission.getPermissionType());
            wrapper.eq(Permission::getObjType, (Object)permission.getObjType());
            Permission one = (Permission)((Object)super.getOne((Wrapper)wrapper));
            if (BeanUtils.isNotEmpty((Object)objNameArray) && ownerIdArray.length == objNameArray.length) {
                permission.setObjName(objNameArray[i]);
            }
            permission.setOwnerId(ownerIdArray[i]);
            if (BeanUtils.isEmpty((Object)((Object)one))) {
                permission.setId(UniqueIdUtil.getSuid());
                super.save((Object)permission);
                continue;
            }
            permission.setId(one.getId());
            super.update((Model)permission);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public List<String> getAuthorizeSingleType(String objType, String type, String typeValue) {
        return ((PermissionMapper)this.baseMapper).getAuthorizeSingleType(objType, type, typeValue);
    }

    @Override
    @Transactional
    public CommonResult<String> savePermissions(List<Permission> permissions) {
        if (BeanUtils.isNotEmpty(permissions)) {
            this.removeByAuthorizeId(permissions.get(0).getObjType(), permissions.get(0).getAuthorizeId());
            ArrayList<Permission> savePermissionList = new ArrayList<Permission>();
            for (Permission permission : permissions) {
                this.getUpdateList(savePermissionList, permission);
            }
            this.saveOrUpdateBatch(savePermissionList);
        }
        return CommonResult.ok();
    }

    @Override
    public List<EipAuthVo> getPermissionByAuthId(String objType, String authorizeId) {
        ArrayList<EipAuthVo> authVos = new ArrayList<EipAuthVo>();
        List permissions = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Permission::getObjType, (Object)objType)).eq(Permission::getAuthorizeId, (Object)authorizeId)).orderByDesc(Permission::getPermissionType));
        if (BeanUtils.isNotEmpty((Object)permissions)) {
            Map<String, List<Permission>> map = permissions.stream().collect(Collectors.groupingBy(Permission::getPermissionType));
            for (String key : map.keySet()) {
                EipAuthVo authVo = new EipAuthVo();
                authVo.setType(key);
                if (!"everyone".equals(key)) {
                    List<Permission> typePermissions = map.get(key);
                    List onwwnerIds = typePermissions.stream().map(Permission::getOwnerId).collect(Collectors.toList());
                    List objNames = typePermissions.stream().map(Permission::getObjName).collect(Collectors.toList());
                    authVo.setId(onwwnerIds.stream().collect(Collectors.joining(",")));
                    authVo.setName(objNames.stream().collect(Collectors.joining(",")));
                }
                authVos.add(authVo);
            }
        }
        return authVos;
    }

    private void getUpdateList(List<Permission> updateList, Permission permission) {
        if ("everyone".equals(permission.getPermissionType())) {
            updateList.add(permission);
        } else {
            String[] ownerIdArray = permission.getOwnerId().split(",");
            String[] objNameArray = permission.getObjName().split(",");
            for (int i = 0; i < ownerIdArray.length; ++i) {
                Permission item = new Permission();
                item.setPermissionType(permission.getPermissionType());
                item.setAuthorizeId(permission.getAuthorizeId());
                item.setObjType(permission.getObjType());
                item.setOwnerId(ownerIdArray[i]);
                item.setObjName(objNameArray[i]);
                updateList.add(item);
            }
        }
    }
}

