/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gexin.fastjson.JSON;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.jms.Notice;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.StringUtil;
import com.hotent.portal.jms.impl.ExternalHandler;
import com.hotent.portal.model.PortalBizSystem;
import com.hotent.portal.model.PortalMsgSendLog;
import com.hotent.portal.persistence.dao.PortalBizSystemDao;
import com.hotent.portal.persistence.dao.PortalMsgSendLogDao;
import com.hotent.portal.persistence.manager.PortalMsgSendLogManager;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalMsgSendLogManagerImpl
extends BaseManagerImpl<PortalMsgSendLogDao, PortalMsgSendLog>
implements PortalMsgSendLogManager {
    private final String flowKey = "flowKey_";
    private final String actionType = "ACTION_TYPE_";
    private final String sysCode = "sysCode";
    private final String title = "subject_";
    private final String trigNodeId = "TRIG_NODE_ID_";
    private final Logger logger = LoggerFactory.getLogger(PortalMsgSendLogManagerImpl.class);
    @Autowired
    PortalMsgSendLogDao portalMsgSendLogDao;
    @Autowired
    PortalBizSystemDao portalBizSystemDao;
    @Autowired
    ExternalHandler externalHandler;
    @Autowired
    PortalMsgSendLogManager portalMsgSendLogManager;

    @Override
    public PortalMsgSendLog getDetail(String id) {
        PortalMsgSendLog portalMsgSendLog = (PortalMsgSendLog)this.get((Serializable)((Object)id));
        return portalMsgSendLog;
    }

    @Override
    @Transactional
    public void createOrUpdate(PortalMsgSendLog portalMsgSendLog) {
        this.saveOrUpdate((Object)portalMsgSendLog);
    }

    public CommonResult saveExternalMsg(Notice notice) {
        Map vars = notice.getVars();
        PortalMsgSendLog log = new PortalMsgSendLog();
        log.setFlowKey((String)vars.get("flowKey_"));
        log.setActionType((String)vars.get("ACTION_TYPE_"));
        log.setSysCode((String)vars.get("sysCode"));
        log.setTrigUserId(notice.getSenderId());
        log.setSendTime(LocalDateTime.now());
        log.setTitle((String)vars.get("subject_"));
        log.setContent(JSON.toJSONString((Object)notice));
        log.setStatus("1");
        log.setTrigNodeId((String)vars.get("TRIG_NODE_ID_"));
        int res = this.portalMsgSendLogDao.insert((Object)log);
        if (res == 1) {
            return new CommonResult(true, ResponseErrorEnums.SUCCESS_OPTION.getMessage(), (Object)log.getId());
        }
        return new CommonResult(false, ResponseErrorEnums.FAIL_OPTION.getMessage(), null);
    }

    @Override
    @Transactional
    public CommonResult sendMsgToExternalQueue(Notice notice, String sysCode) {
        PortalBizSystem bizSystem = (PortalBizSystem)((Object)this.portalBizSystemDao.selectOne((Wrapper)new QueryWrapper().eq((Object)"SYS_CODE_", (Object)sysCode)));
        if (bizSystem == null) {
            return new CommonResult(false, ResponseErrorEnums.FAIL_OPTION.getMessage(), null);
        }
        if (StringUtil.isNotEmpty((String)bizSystem.getBpmMsgQueue())) {
            CommonResult result = this.saveExternalMsg(notice);
            boolean res = this.externalHandler.send(notice, bizSystem.getBpmMsgQueue());
            if (!res) {
                String portalMsgSendLogId = (String)result.getValue();
                PortalMsgSendLog portalMsgSendLog = (PortalMsgSendLog)((Object)this.portalMsgSendLogDao.selectById((Serializable)((Object)portalMsgSendLogId)));
                portalMsgSendLog.setStatus("0");
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"ID_", (Object)portalMsgSendLogId);
                this.portalMsgSendLogDao.update((Object)portalMsgSendLog, (Wrapper)wrapper);
            }
        }
        return new CommonResult(true, ResponseErrorEnums.SUCCESS_OPTION.getMessage(), null);
    }

    @Override
    public CommonResult retrySendMsgById(String id) {
        PortalMsgSendLog portalMsgSendLog = (PortalMsgSendLog)((Object)this.portalMsgSendLogDao.selectById((Serializable)((Object)id)));
        if (portalMsgSendLog == null) {
            return new CommonResult(false, ResponseErrorEnums.NO_RECORD.getMessage(), null);
        }
        if (portalMsgSendLog.getStatus().equals("1")) {
            return new CommonResult(false, "\u8be5\u6761\u6d88\u606f\u5df2\u6210\u529f\u53d1\u9001\u5230\u961f\u5217\uff0c\u8bf7\u95ee\u91cd\u590d\u53d1\u9001", null);
        }
        QueryWrapper portalBizSystemQueryWrapper = new QueryWrapper();
        portalBizSystemQueryWrapper.eq((Object)"SYS_CODE_", (Object)portalMsgSendLog.getSysCode());
        PortalBizSystem portalBizSystem = (PortalBizSystem)((Object)this.portalBizSystemDao.selectOne((Wrapper)portalBizSystemQueryWrapper));
        String noticeJson = portalMsgSendLog.getContent();
        Notice notice = (Notice)JSON.parseObject((String)noticeJson, Notice.class);
        this.logger.debug("noticeJson\u8f6c\u6362\u540e\u7684\u683c\u5f0f\uff1a{}", (Object)noticeJson);
        boolean send = this.externalHandler.send(notice, portalBizSystem.getBpmMsgQueue());
        if (send) {
            portalMsgSendLog.setStatus("1");
            this.portalMsgSendLogDao.updateById((Object)portalMsgSendLog);
            return new CommonResult(true, ResponseErrorEnums.SUCCESS_OPTION.getMessage(), null);
        }
        return new CommonResult(false, "\u91cd\u8bd5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u8bf7\u67e5\u770b\u76f8\u5173\u65e5\u5fd7", null);
    }
}

