/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.column.index.IndexTabList;
import com.hotent.column.model.SysIndexColumn;
import com.hotent.portal.model.SysIndexTools;
import com.hotent.portal.persistence.dao.SysIndexToolsDao;
import com.hotent.portal.persistence.manager.SysIndexToolsManager;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Service;

@Service(value="sysIndexToolsManager")
public class SysIndexToolsManagerImpl
extends BaseManagerImpl<SysIndexToolsDao, SysIndexTools>
implements SysIndexToolsManager {
    @Resource
    SysIndexToolsManager sysIndexToolsManager;
    private GroovyScriptEngine groovyScriptEngine = new GroovyScriptEngine();

    @Override
    public List<SysIndexTools> getToolsByIds(List<String> toolsIds) {
        return ((SysIndexToolsDao)this.baseMapper).selectBatchIds(toolsIds);
    }

    public ObjectNode parseTemplateJSON(SysIndexTools sysIndexTools, Map<String, Object> params) throws Exception {
        String dataFrom = sysIndexTools.getCounting();
        String html = "";
        Short colType = 0;
        short dataMode = sysIndexTools.getCountMode();
        String ctxPath = params.get("__ctx").toString();
        String dataParam = sysIndexTools.getCountParam();
        Object data = null;
        try {
            Class<?>[] parameterTypes = this.getParameterTypes(dataParam, params);
            Object[] param = this.getDataParam(dataParam, params);
            if (1 == dataMode) {
                data = this.getModelByHandler(dataFrom, param, parameterTypes);
            } else if (2 == dataMode) {
                String string = dataFrom;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("title", sysIndexTools.getName());
        model.put("url", sysIndexTools.getUrl());
        map.put("model", model);
        map.put("data", data);
        map.put("ctx", ctxPath);
        Object pageBean = null;
        html = "<#setting number_format=\"#\">" + html;
        try {
            html = this.parseByStringTemplate(map, html);
        }
        catch (Exception e) {
            System.out.println("\u89e3\u6790\u6a21\u677f\u51fa\u9519\uff1a" + e.getMessage());
        }
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        if (SysIndexColumn.COLUMN_TYPE_CHART == colType || SysIndexColumn.COLUMN_TYPE_CALENDAR == colType) {
            json.set("option", JsonUtil.toJsonNode((Object)data));
        }
        return json;
    }

    @Override
    public Class<?>[] getParameterTypes(String dataParam, Map<String, Object> params) throws Exception {
        if (JsonUtil.isEmpty((Object)dataParam) || StringUtil.isEmpty((String)dataParam)) {
            return new Class[0];
        }
        JsonNode jary = JsonUtil.toJsonNode((String)dataParam);
        Class[] parameterTypes = new Class[jary.size()];
        for (int i = 0; i < jary.size(); ++i) {
            JsonNode json = jary.get(i);
            String type = json.get("type").asText();
            parameterTypes[i] = this.getParameterTypes(type);
        }
        return parameterTypes;
    }

    @Override
    public CommonResult<String> saveSysIndexTools(SysIndexTools sysIndexTools) {
        String resultMsg = null;
        String id = sysIndexTools.getId();
        try {
            if (StringUtil.isEmpty((String)id)) {
                sysIndexTools.setId(UniqueIdUtil.getSuid());
                this.sysIndexToolsManager.create((Model)sysIndexTools);
                resultMsg = "\u6dfb\u52a0\u9996\u9875\u5de5\u5177\u6210\u529f";
            } else {
                this.sysIndexToolsManager.update((Model)sysIndexTools);
                resultMsg = "\u66f4\u65b0\u9996\u9875\u5de5\u5177\u6210\u529f";
            }
            return new CommonResult(true, resultMsg);
        }
        catch (Exception e) {
            resultMsg = "\u5bf9\u9996\u9875\u5de5\u5177\u64cd\u4f5c\u5931\u8d25";
            return new CommonResult(false, resultMsg + e.getMessage());
        }
    }

    @Override
    public Object[] getDataParam(String dataParam, Map<String, Object> params) throws Exception {
        if (JsonUtil.isEmpty((Object)dataParam) || StringUtil.isEmpty((String)dataParam)) {
            return null;
        }
        JsonNode jary = JsonUtil.toJsonNode((String)dataParam);
        Object[] args = new Object[jary.size()];
        for (int i = 0; i < jary.size(); ++i) {
            Object val;
            JsonNode json = jary.get(i);
            String name = json.get("name").asText();
            String type = json.get("type").asText();
            String mode = json.get("mode").asText();
            String value = json.get("value").asText();
            Object o = value;
            if (mode.equalsIgnoreCase("1")) {
                o = params.get(name);
                if (JsonUtil.isEmpty((Object)o) && BeanUtils.isNotEmpty((Object)value)) {
                    o = value;
                }
            } else if (mode.equalsIgnoreCase("2")) {
                o = this.groovyScriptEngine.executeString(value, params);
            }
            args[i] = val = StringUtil.parserObject((Object)o, (String)type);
        }
        return args;
    }

    @Override
    public Object getModelByHandler(String handler, Object[] args, Class<?>[] parameterTypes) throws Exception {
        Method invokeMethod;
        Object model = null;
        if (StringUtil.isEmpty((String)handler)) {
            return model;
        }
        String[] aryHandler = handler.split("[.]");
        if (aryHandler == null) {
            return model;
        }
        String beanId = aryHandler[0];
        String method = aryHandler[1];
        Object serviceBean = AppUtil.getBean((String)beanId);
        if (serviceBean == null) {
            return model;
        }
        if (args == null || args.length <= 0) {
            parameterTypes = new Class[]{};
        }
        if (BeanUtils.isEmpty((Object)(model = (invokeMethod = serviceBean.getClass().getDeclaredMethod(method, parameterTypes)).invoke(serviceBean, args)))) {
            model = null;
        }
        return model;
    }

    private ArrayNode getArrayParams(String dataParam, Object[] param, Class<?>[] parameterTypes) {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        if (StringUtil.isNotEmpty((String)dataParam)) {
            try {
                ArrayNode paramArray = (ArrayNode)JsonUtil.toJsonNode((String)dataParam);
                for (int i = 0; i < paramArray.size(); ++i) {
                    ObjectNode obj = (ObjectNode)paramArray.get(i);
                    obj.put("value", param[i].toString());
                    obj.put("type", parameterTypes[i].getCanonicalName());
                    array.add((JsonNode)obj);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return array;
    }

    private PageBean handerPageBean(Object data) {
        PageBean pageBean = null;
        try {
            if (data instanceof PageList) {
                PageList pageList = (PageList)data;
                int page = (int)pageList.getPage();
                int pageSize = (int)pageList.getPageSize();
                long total = pageList.getTotal();
                pageBean.setPage(page);
                pageBean.setPageSize(pageSize);
            } else if (data instanceof IndexTabList) {
                IndexTabList indexTablist = (IndexTabList)data;
                pageBean = this.getIndexTabPageBean(indexTablist);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pageBean;
    }

    private String parseByStringTemplate(Object obj, String templateSource) throws TemplateException, IOException {
        Configuration cfg = new Configuration();
        StringTemplateLoader loader = new StringTemplateLoader();
        cfg.setTemplateLoader((TemplateLoader)loader);
        cfg.setClassicCompatible(true);
        loader.putTemplate("freemaker", templateSource);
        Template template = cfg.getTemplate("freemaker");
        StringWriter writer = new StringWriter();
        template.process(obj, (Writer)writer);
        return writer.toString();
    }

    private String parserHtml(String html, SysIndexColumn sysIndexColumn, PageBean pageBean, Map<String, Object> params) throws Exception {
        if (StringUtil.isEmpty((String)html)) {
            return "";
        }
        Document doc = Jsoup.parseBodyFragment((String)html);
        Elements els = doc.body().children();
        if (BeanUtils.isEmpty((Object)els)) {
            return doc.body().html();
        }
        Element el = els.get(0);
        el.attr("template-alias", sysIndexColumn.getAlias());
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        for (String key : params.keySet()) {
            json.put(key, JsonUtil.toJsonNode((Object)params.get(key)));
        }
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            json.put("currentPage", pageBean.getPage());
            json.put("pageSize", pageBean.getPageSize());
        }
        el.attr("template-params", json.toString());
        html = doc.body().html();
        return html;
    }

    private Class<?> getParameterTypes(String type) {
        Class claz = null;
        try {
            claz = type.equalsIgnoreCase("string") ? String.class : (type.equalsIgnoreCase("int") ? Integer.class : (type.equalsIgnoreCase("float") ? Float.class : (type.equalsIgnoreCase("double") ? Double.class : (type.equalsIgnoreCase("byte") ? Byte.class : (type.equalsIgnoreCase("short") ? Short.class : (type.equalsIgnoreCase("long") ? Long.class : (type.equalsIgnoreCase("boolean") ? Boolean.class : (type.equalsIgnoreCase("date") ? Date.class : String.class))))))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return claz;
    }

    private PageBean getIndexTabPageBean(IndexTabList indexTablist) {
        if (BeanUtils.isEmpty((Object)indexTablist)) {
            return null;
        }
        return indexTablist.getPageBean();
    }
}

