/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.portal.model.SysLayoutTools;
import com.hotent.portal.persistence.dao.SysLayoutToolsDao;
import com.hotent.portal.persistence.manager.SysLayoutToolsManager;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="sysLayoutToolsManager")
public class SysLayoutToolsManagerImpl
extends BaseManagerImpl<SysLayoutToolsDao, SysLayoutTools>
implements SysLayoutToolsManager {
    @Resource
    SysLayoutToolsManager sysLayoutToolsManager;

    @Override
    public SysLayoutTools getByLayoutID(String layoutId, String toolsType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("layoutId", layoutId);
        params.put("toolsType", toolsType);
        return ((SysLayoutToolsDao)this.baseMapper).getByLayoutID(params);
    }

    @Override
    public CommonResult<String> moveTool(String layoutId, String toolsType, String toolId, boolean isMove) {
        try {
            SysLayoutTools sysLayoutTools = this.getByLayoutID(layoutId, toolsType);
            Object[] toolsArray = sysLayoutTools.getToolsIds().split(",");
            for (int i = 0; i < toolsArray.length; ++i) {
                if (!toolsArray[i].equals(toolId)) continue;
                if (isMove) {
                    String pre = toolsArray[i - 1];
                    toolsArray[i - 1] = toolsArray[i];
                    toolsArray[i] = pre;
                } else {
                    String later = toolsArray[i + 1];
                    toolsArray[i + 1] = toolsArray[i];
                    toolsArray[i] = later;
                }
                sysLayoutTools.setToolsIds(StringUtils.join((Object[])toolsArray, (String)","));
                this.update((Model)sysLayoutTools);
                break;
            }
            return new CommonResult(true, "\u79fb\u52a8\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u79fb\u52a8\u5931\u8d25", (Object)e.getMessage());
        }
    }

    @Override
    public CommonResult<String> saveSysLayoutTools(SysLayoutTools sysLayoutTools) {
        String resultMsg = null;
        try {
            SysLayoutTools layoutTools = this.sysLayoutToolsManager.getByLayoutID(sysLayoutTools.getLayoutId(), sysLayoutTools.getToolsType());
            if (layoutTools == null) {
                sysLayoutTools.setId(UniqueIdUtil.getSuid());
                this.sysLayoutToolsManager.create((Model)sysLayoutTools);
                resultMsg = "\u6dfb\u52a0\u5e03\u5c40\u5de5\u5177\u8bbe\u7f6e\u6210\u529f";
            } else {
                layoutTools.setToolsIds(sysLayoutTools.getToolsIds());
                this.sysLayoutToolsManager.update((Model)layoutTools);
                resultMsg = "\u66f4\u65b0\u5e03\u5c40\u5de5\u5177\u8bbe\u7f6e\u6210\u529f";
            }
            return new CommonResult(true, resultMsg);
        }
        catch (Exception e) {
            resultMsg = "\u5bf9\u5e03\u5c40\u5de5\u5177\u8bbe\u7f6e\u64cd\u4f5c\u5931\u8d25";
            return new CommonResult(false, resultMsg);
        }
    }

    @Override
    public CommonResult<String> deleteTool(String layoutId, String toolsType, String toolId) {
        try {
            SysLayoutTools sysLayoutTools = this.sysLayoutToolsManager.getByLayoutID(layoutId, toolsType);
            Object[] toolsArray = sysLayoutTools.getToolsIds().split(",");
            toolsArray = (String[])ArrayUtils.removeElement((Object[])toolsArray, (Object)toolId);
            sysLayoutTools.setToolsIds(StringUtils.join((Object[])toolsArray, (String)","));
            this.sysLayoutToolsManager.update((Model)sysLayoutTools);
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25", (Object)e.getMessage());
        }
    }
}

