/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.service.appio.impl;

import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantSwitchResult;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.portal.service.appio.AppMenuIOServiceFactory;
import com.hotent.portal.service.appio.IAppIOService;
import com.hotent.portal.service.appio.IAppMenuIOService;
import com.hotent.sys.persistence.manager.AppTagsRelationManager;
import com.hotent.sys.persistence.manager.PortalAppParamManager;
import com.hotent.sys.persistence.manager.SysAppManager;
import com.hotent.sys.persistence.manager.SysAppMenuManager;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.sys.persistence.manager.SysMenuManager;
import com.hotent.sys.persistence.manager.SysTagManager;
import com.hotent.sys.persistence.model.SysApp;
import com.hotent.sys.persistence.model.SysAppMenu;
import com.hotent.sys.persistence.model.SysAuthUser;
import com.hotent.sys.persistence.model.SysMenu;
import com.hotent.sys.persistence.param.AppTenantPublishDTO;
import com.hotent.sys.persistence.param.SysAppExport;
import com.hotent.sys.persistence.param.SysAppExportList;
import com.hotent.sys.persistence.param.SysAppMenuExport;
import com.hotent.table.operator.ITableOperator;
import com.hotent.uc.api.impl.model.UserFacade;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import io.seata.spring.annotation.GlobalTransactional;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class AppIOService
implements IAppIOService {
    Logger logger = LoggerFactory.getLogger(AppIOService.class);
    @Resource
    SysAppManager sysAppManager;
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    SysAppMenuManager sysAppMenuManager;
    @Resource
    PortalAppParamManager appParamManager;
    @Resource
    SysTagManager sysTagManager;
    @Resource
    SysMenuManager sysMenuManager;
    @Resource
    AppTagsRelationManager appTagsRelationManager;
    @Resource
    AppMenuIOServiceFactory menuIOServiceFactory;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    ITableOperator tableOperator;

    @Override
    public void exportApp(HttpServletResponse response, List<String> ids, String status) throws Exception {
        if (BeanUtils.isNotEmpty(ids)) {
            Map<String, Object> map = this.exportApp(ids, status);
            HttpUtil.downLoadFile((HttpServletResponse)response, map, (String)this.getFileName(ids));
        }
    }

    @Override
    public Map<String, Object> exportApp(List<String> ids, String status) {
        SysAppExportList exportList = new SysAppExportList();
        ArrayList<String> errors = new ArrayList<String>();
        HashMap snapshotMap = new HashMap();
        for (String id : ids) {
            SysMenu sysMenu;
            List sysAppMenuList = this.sysAppMenuManager.getByAppId(id);
            List sysAppMenuExports = sysAppMenuList.stream().map(menu -> {
                SysAppMenuExport sysAppMenuExport = new SysAppMenuExport();
                sysAppMenuExport.setMenu(menu);
                try {
                    Map<String, Object> exportContent = this.getMenuExportContent((SysAppMenu)menu);
                    exportContent.forEach((key, value) -> {
                        if (key.endsWith(".jpg")) {
                            snapshotMap.put(key, value);
                        }
                    });
                    snapshotMap.forEach((key, value) -> exportContent.remove(key));
                    sysAppMenuExport.setSetting(exportContent);
                }
                catch (Exception e) {
                    this.logger.error("\u5bfc\u51fa\u9519\u8bef\u539f\u56e0\uff1a", (Throwable)e);
                    throw new BaseException("\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u5185\u5bb9");
                }
                return sysAppMenuExport;
            }).collect(Collectors.toList());
            SysApp sysApp = (SysApp)this.sysAppManager.get((Serializable)((Object)id));
            String error = this.validMenuContent(sysApp, sysAppMenuList, status);
            if (BeanUtils.isNotEmpty((Object)error)) {
                errors.add(error);
            }
            List portalAppParamList = this.appParamManager.getByAppId(id);
            List sysTagList = this.sysTagManager.getByAppId(id);
            List sysAuthUserList = this.sysAuthUserManager.getByAuthorizeId(id);
            SysAppExport sysAppExport = new SysAppExport();
            String sysMenuId = sysApp.getMenuId();
            if (StringUtil.isNotEmpty((String)sysMenuId) && (sysMenu = (SysMenu)this.sysMenuManager.get((Serializable)((Object)sysApp.getMenuId()))) != null) {
                sysApp.setMenuAlias(sysMenu.getAlias());
            }
            sysAppExport.setApp(sysApp);
            sysAppExport.setMenus(sysAppMenuExports);
            sysAppExport.setParams(portalAppParamList);
            sysAppExport.setTags(sysTagList);
            sysAppExport.setAuthUsers(sysAuthUserList);
            exportList.addApps(sysAppExport);
        }
        if (BeanUtils.isNotEmpty(errors)) {
            throw new BaseException(String.join((CharSequence)";", errors) + "\u914d\u7f6e\u5185\u5bb9\u4e0d\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u5bfc\u51fa?");
        }
        String json = JsonUtil.toJsonString((Object)exportList);
        HashMap<String, Object> map = new HashMap<String, Object>(snapshotMap);
        map.put("sysApps.json", json);
        return map;
    }

    private String validMenuContent(SysApp sysApp, List<SysAppMenu> menus, String status) {
        String message = menus.stream().filter(menu -> menu.getContent() == null && "page".equals(menu.getMenuType())).map(menu -> "(" + menu.getName() + ")").collect(Collectors.joining(","));
        if (BeanUtils.isNotEmpty((Object)message) && "check".equals(status)) {
            return "\u5e94\u7528[" + sysApp.getName() + "]\u7684\u5e94\u7528\u83dc\u5355" + message;
        }
        return null;
    }

    private String getFileName(List<String> ids) {
        String tempName = "\u5e94\u7528\u6279\u91cf\u5bfc\u51fa\u5305_";
        if (ids.size() == 1) {
            SysApp sysApp = (SysApp)this.sysAppManager.get((Serializable)((Object)ids.get(0)));
            Assert.notNull((Object)sysApp);
            tempName = sysApp.getName() + "_";
        }
        return tempName + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMdd_HHmmss");
    }

    private Map<String, Object> getMenuExportContent(SysAppMenu sysAppMenu) throws Exception {
        block3: {
            String content = sysAppMenu.getContent();
            if (BeanUtils.isNotEmpty((Object)content) && content.startsWith("{") && content.endsWith("}")) {
                JsonNode setting = JsonUtil.toJsonNode((String)content);
                String id = JsonUtil.getString((JsonNode)setting, (String)"id");
                IAppMenuIOService appMenuIOService = this.menuIOServiceFactory.getBean(sysAppMenu.getType());
                try {
                    return appMenuIOService.getExportContent(id);
                }
                catch (Exception e) {
                    if (!e.getMessage().contains("\u4e0d\u5b58\u5728")) break block3;
                    sysAppMenu.setContent(null);
                    this.sysAppMenuManager.update((Model)sysAppMenu);
                }
            }
        }
        return new HashMap<String, Object>();
    }

    @Override
    @GlobalTransactional(rollbackFor={Exception.class})
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> importApp(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("\u5bfc\u5165\u5f00\u59cb");
        CommonResult message = new CommonResult("\u5bfc\u5165\u6210\u529f");
        try {
            String menu = request.getParameter("menu");
            String isCover = request.getParameter("cover");
            String json = this.readJsonFromFile(request.getFile("file"));
            if (StringUtil.isEmpty((String)json)) {
                throw new BaseException("\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9\uff01");
            }
            SysAppExportList sysAppExportList = (SysAppExportList)JsonUtil.toBean((String)json, SysAppExportList.class);
            this.importApp(sysAppExportList, StringUtil.isNotEmpty((String)menu) ? JsonUtil.toJsonNode((String)menu) : null, "true".equals(isCover));
            this.logger.info("\u5bfc\u5165\u7ed3\u675f");
            return message;
        }
        catch (Exception e) {
            LinkedHashSet createTables = ThreadMsgUtil.getMapMsg2((String)"createTables", (boolean)true);
            if (BeanUtils.isNotEmpty((Object)createTables)) {
                for (String tableName : createTables) {
                    try {
                        this.tableOperator.dropTable(tableName);
                    }
                    catch (SQLException e1) {
                        throw new BaseException("\u521b\u5efa\u8868\u5931\u8d25,\u8868" + tableName + "\u5df2\u5b58\u5728", (Throwable)e1);
                    }
                }
            }
            throw new BaseException((Throwable)e);
        }
    }

    @Override
    public void importApp(SysAppExportList sysAppExportList, JsonNode menu, boolean isCover) {
        sysAppExportList.getApps().forEach(sysAppExport -> {
            if (BeanUtils.isNotEmpty((Object)menu)) {
                sysAppExport.getApp().setMenuId(JsonUtil.getString((JsonNode)menu, (String)"menuId"));
                sysAppExport.getApp().setMenuAlias(JsonUtil.getString((JsonNode)menu, (String)"menuAlias"));
                sysAppExport.getApp().setMenuName(JsonUtil.getString((JsonNode)menu, (String)"menuName"));
            }
            this.importData((SysAppExport)sysAppExport, isCover);
        });
    }

    @Override
    public CommonResult<String> importCheck(MultipartHttpServletRequest request) throws Exception {
        List<ImportCheckResult> checkResults = this.importCheck(request.getFile("file"));
        if (!checkResults.isEmpty()) {
            StringBuilder sb = new StringBuilder("<div style='font-weight:bold;'>");
            String list = checkResults.parallelStream().map(result -> result.getType() + "\u3010" + result.getName() + "\u3011").collect(Collectors.joining("<br>"));
            sb.append(list);
            sb.append("<div>\u5df2\u5b58\u5728,\u662f\u5426\u6267\u884c\u4ee5\u4e0b\u64cd\u4f5c\uff1a</div>");
            return new CommonResult(true, sb.toString());
        }
        return new CommonResult(true, "\u9a8c\u8bc1\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @GlobalTransactional(rollbackFor={Exception.class})
    public void tenantPublish(AppTenantPublishDTO appTenantPublish) throws Exception {
        IUser oldUser = ContextUtil.getCurrentUser();
        for (String tenantId : appTenantPublish.getTenantIds()) {
            Map<String, Object> map = this.exportApp(appTenantPublish.getAppIds(), "none");
            String json = map.get("sysApps.json").toString();
            SysAppExportList sysAppExportList = (SysAppExportList)JsonUtil.toBean((String)json, SysAppExportList.class);
            try (MultiTenantSwitchResult ignored = MultiTenantHandler.switchTempTenant((String)tenantId);){
                ArrayNode admins = this.ucFeignService.getUserByIdsOrAccounts("admin");
                if (BeanUtils.isEmpty((Object)admins)) {
                    throw new BaseException("\u8be5\u79df\u6237\u4e0d\u5b58\u5728admin\u8d26\u53f7\uff0c\u8bf7\u68c0\u67e5\u79df\u6237\u521b\u5efa\u662f\u5426\u6b63\u786e");
                }
                IUser currentUser = (IUser)JsonUtil.toBean((JsonNode)admins.get(0), UserFacade.class);
                ContextUtil.switchCurrentUser((IUser)currentUser);
                this.importApp(sysAppExportList, null, appTenantPublish.getCover());
            }
            ContextUtil.switchCurrentUser((IUser)oldUser);
        }
    }

    @Override
    public CommonResult<String> tenantPublishCheck(AppTenantPublishDTO appTenantPublish) throws Exception {
        IUser oldUser = ContextUtil.getCurrentUser();
        ArrayList<ImportCheckResult> checkResults = new ArrayList<ImportCheckResult>();
        ArrayList<String> tenantNames = new ArrayList<String>();
        for (String tenantId : appTenantPublish.getTenantIds()) {
            Map<String, Object> map = this.exportApp(appTenantPublish.getAppIds(), "none");
            String json = map.get("sysApps.json").toString();
            MultiTenantSwitchResult ignored = MultiTenantHandler.switchTempTenant((String)tenantId);
            Throwable throwable = null;
            try {
                ArrayNode admins = this.ucFeignService.getUserByIdsOrAccounts("admin");
                if (BeanUtils.isEmpty((Object)admins)) {
                    throw new BaseException("\u8be5\u79df\u6237\u4e0d\u5b58\u5728admin\u8d26\u53f7\uff0c\u8bf7\u68c0\u67e5\u79df\u6237\u521b\u5efa\u662f\u5426\u6b63\u786e");
                }
                IUser currentUser = (IUser)JsonUtil.toBean((JsonNode)admins.get(0), UserFacade.class);
                ContextUtil.switchCurrentUser((IUser)currentUser);
                List<ImportCheckResult> results = this.importCheck(json);
                if (results.isEmpty()) continue;
                JsonNode tenant = this.ucFeignService.getTenantById(tenantId);
                tenantNames.add(JsonUtil.getString((JsonNode)tenant, (String)"name"));
                checkResults.addAll(this.importCheck(json));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
                continue;
            }
            ContextUtil.switchCurrentUser((IUser)oldUser);
        }
        if (!checkResults.isEmpty()) {
            StringBuilder sb = new StringBuilder("<div style='font-weight:bold;'>");
            sb.append("\u79df\u6237\uff1a</br>");
            sb.append(String.join((CharSequence)",", tenantNames));
            sb.append("</br>");
            sb.append("\u7ec4\u4ef6\uff1a</br>");
            String list = checkResults.parallelStream().map(result -> result.getType() + "\u3010" + result.getName() + "\u3011").distinct().collect(Collectors.joining("<br>"));
            sb.append(list);
            sb.append("<div>\u5df2\u5b58\u5728,\u662f\u5426\u6267\u884c\u4ee5\u4e0b\u64cd\u4f5c\uff1a</div>");
            return new CommonResult(true, sb.toString());
        }
        return new CommonResult(true, "\u9a8c\u8bc1\u6210\u529f");
    }

    private List<ImportCheckResult> importCheck(MultipartFile file) throws Exception {
        String json = this.readJsonFromFile(file);
        if (StringUtil.isEmpty((String)json)) {
            throw new BaseException("\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9\uff01");
        }
        return this.importCheck(json);
    }

    private List<ImportCheckResult> importCheck(String json) throws Exception {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        SysAppExportList sysAppExportList = (SysAppExportList)JsonUtil.toBean((String)json, SysAppExportList.class);
        for (SysAppExport sysAppExport : sysAppExportList.getApps()) {
            List<ImportCheckResult> checkResults = this.importCheck(sysAppExport);
            results.addAll(checkResults);
        }
        return results;
    }

    private List<ImportCheckResult> importCheck(SysAppExport sysAppExport) throws Exception {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        String alias = sysAppExport.getApp().getAlias();
        if (this.sysAppManager.count((Wrapper)Wrappers.lambdaQuery().eq(SysApp::getAlias, (Object)alias)) > 0) {
            results.add(new ImportCheckResult(true, "\u5e94\u7528", sysAppExport.getApp().getName()));
        }
        for (SysAppMenuExport menu : sysAppExport.getMenus()) {
            SysAppMenu sysAppMenu = menu.getMenu();
            Map param = menu.getSetting();
            IAppMenuIOService service = this.menuIOServiceFactory.getBean(sysAppMenu.getType());
            results.addAll(service.importCheck(param));
        }
        return results;
    }

    private String readJsonFromFile(MultipartFile file) {
        File formDir;
        String string;
        String unZipFilePath = null;
        try {
            String rootRealPath = Paths.get(FileUtil.getIoTmpdir(), "/attachFiles/unZip").toString();
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            unZipFilePath = Paths.get(rootRealPath, fileDir).toString();
            string = cn.hutool.core.io.FileUtil.readString((String)Paths.get(unZipFilePath, "sysApps.json").toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            try {
                throw new BaseException("\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u4e3a\u5e94\u7528\u5bfc\u5165\u6587\u4ef6!");
            }
            catch (Throwable throwable) {
                File formDir2;
                if (StringUtil.isNotEmpty(unZipFilePath) && (formDir2 = new File(unZipFilePath)).exists()) {
                    FileUtil.deleteDir((File)formDir2);
                }
                throw throwable;
            }
        }
        if (StringUtil.isNotEmpty((String)unZipFilePath) && (formDir = new File(unZipFilePath)).exists()) {
            FileUtil.deleteDir((File)formDir);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importData(SysAppExport sysAppExport, boolean isCover) {
        SysApp sysApp = sysAppExport.getApp();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysApp::getAlias, (Object)sysApp.getAlias());
        SysApp existApp = (SysApp)this.sysAppManager.getOne((Wrapper)wrapper);
        if (BeanUtils.isNotEmpty((Object)existApp)) {
            if (!isCover) return;
            sysApp.setId(existApp.getId());
            existApp.setName(sysApp.getName());
            existApp.setDesc(sysApp.getDesc());
            existApp.setFileInfo(sysApp.getFileInfo());
            existApp.setIcon(sysApp.getIcon());
            existApp.setIconColor(sysApp.getIconColor());
            this.sysAppManager.update((Model)existApp);
            LambdaQueryWrapper w1 = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAppMenu::getAppId, (Object)existApp.getId());
            this.sysAppMenuManager.remove((Wrapper)w1);
            LambdaQueryWrapper w2 = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAuthUser::getAuthorizeId, (Object)existApp.getId())).eq(SysAuthUser::getObjType, (Object)"app");
            this.sysAuthUserManager.remove((Wrapper)w2);
        } else {
            SysMenu sysMenu;
            sysApp.setId(UniqueIdUtil.getSuid());
            String sysMenuAlias = sysApp.getMenuAlias();
            if (StringUtil.isNotEmpty((String)sysMenuAlias) && BeanUtils.isNotEmpty((Object)(sysMenu = this.sysMenuManager.getByAlias(sysMenuAlias)))) {
                sysApp.setMenuId(sysMenu.getId());
            }
            this.sysAppManager.save((Object)sysApp);
        }
        List sysAppMenuExports = sysAppExport.getMenus();
        if (BeanUtils.isNotEmpty((Object)sysAppMenuExports)) {
            HashMap oldAndNewIdMap = new HashMap();
            sysAppMenuExports.forEach(item -> oldAndNewIdMap.put(item.getMenu().getId(), UniqueIdUtil.getSuid()));
            sysAppMenuExports.forEach(sysAppMenuExport -> {
                SysAppMenu sysAppMenu = sysAppMenuExport.getMenu();
                try {
                    Map setting = sysAppMenuExport.getSetting();
                    IAppMenuIOService service = this.menuIOServiceFactory.getBean(sysAppMenu.getType());
                    if (BeanUtils.isEmpty((Object)setting) && !"category".equals(sysAppMenu.getMenuType()) && sysAppMenu.getType() != 5) {
                        throw new BaseException(String.format("\u83dc\u5355[%s]\u7684\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664!", sysAppMenu.getName()));
                    }
                    Map<String, String> map = service.importData(setting, isCover);
                    sysAppMenu.setId(oldAndNewIdMap.getOrDefault(sysAppMenu.getId(), UniqueIdUtil.getSuid()));
                    sysAppMenu.setParentId(oldAndNewIdMap.getOrDefault(sysAppMenu.getParentId(), "0"));
                    sysAppMenu.setAppId(sysApp.getId());
                    sysAppMenu.setTenantId(null);
                    this.setAppContent(sysAppMenu, map);
                    this.sysAppMenuManager.save((Object)sysAppMenu);
                }
                catch (Exception e) {
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
            });
        }
        this.appParamManager.saveAppParams(sysApp.getId(), sysAppExport.getParams());
        this.appTagsRelationManager.saveAppTagRelations(sysApp.getId(), sysAppExport.getTags());
        this.sysAuthUserManager.saveAppAuthUsers(sysApp.getId(), sysAppExport.getAuthUsers());
    }

    private void setAppContent(SysAppMenu sysAppMenu, Map<String, String> map) throws IOException {
        String content = sysAppMenu.getContent();
        if (BeanUtils.isNotEmpty((Object)content) && content.startsWith("{") && content.endsWith("}")) {
            ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)content);
            String alias = JsonUtil.getString((JsonNode)node, (String)"alias", (String)JsonUtil.getString((JsonNode)node, (String)"key", (String)""));
            if (BeanUtils.isEmpty((Object)alias)) {
                map.forEach((key, value) -> node.put("id", value));
            } else {
                node.put("id", map.get(alias));
            }
            sysAppMenu.setContent(JsonUtil.toJsonString((Object)node));
        }
    }
}

