/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.portal.model.AppModel;
import com.hotent.portal.params.AppTree;
import com.hotent.portal.persistence.manager.AppModelManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portal/appModel/v1"})
@Api(tags={"appModelController"})
public class AppModelController
extends BaseController<AppModelManager, AppModel> {
    @Resource
    AppModelManager appModelManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u79fb\u52a8\u7aef\u5e94\u7528\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u79fb\u52a8\u7aef\u5e94\u7528\u5217\u8868")
    public PageList<AppModel> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<AppModel> queryFilter) throws Exception {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("SN_", Direction.ASC));
        queryFilter.setSorter(sorter);
        for (QueryField oneQuery : queryFilter.getQuerys()) {
            if (!oneQuery.getProperty().equals("content")) continue;
            oneQuery.setValue((Object)("name\":\"%" + oneQuery.getValue().toString() + "%\""));
        }
        return this.appModelManager.query(queryFilter);
    }

    @RequestMapping(value={"getApp"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6App", httpMethod="GET", notes="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6App")
    public List<AppTree> getApp(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        return this.appModelManager.getApp(typeKey);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u79fb\u52a8\u7aef\u5e94\u7528\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79fb\u52a8\u7aef\u5e94\u7528\u6570\u636e\u8be6\u60c5")
    public AppModel get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (AppModel)this.appModelManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79fb\u52a8\u7aef\u5e94\u7528\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79fb\u52a8\u7aef\u5e94\u7528\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="appModel", value="\u79fb\u52a8\u7aef\u5e94\u7528\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody AppModel appModel) throws Exception {
        return this.appModelManager.createOrUpdate(appModel);
    }

    @GetMapping(value={"updateEnable/{id}"})
    @ApiOperation(value="\u66f4\u6539\u5e94\u7528\u4e2d\u5fc3\u72b6\u6001", httpMethod="POST", notes="\u66f4\u6539\u5e94\u7528\u4e2d\u5fc3\u72b6\u6001")
    public CommonResult<String> updateEnable(@PathVariable(value="id") String id) {
        AppModel appModel = (AppModel)this.appModelManager.get((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)((Object)appModel))) {
            return new CommonResult(false, "\u6839\u636eID\u65e0\u6cd5\u67e5\u8be2\u5230\u5e94\u7528\u4e2d\u5fc3");
        }
        if (appModel.getEnable().equals(0)) {
            appModel.setEnable(1);
        } else {
            appModel.setEnable(0);
        }
        this.appModelManager.update((Model)appModel);
        return new CommonResult(true, "\u72b6\u6001\u4fee\u6539\u6210\u529f");
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u79fb\u52a8\u7aef\u5e94\u7528\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u79fb\u52a8\u7aef\u5e94\u7528\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.appModelManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u79fb\u52a8\u7aef\u5e94\u7528xml", httpMethod="GET", notes="\u5bfc\u51fa\u79fb\u52a8\u7aef\u5e94\u7528xml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="ids", value="\u79fb\u52a8\u7aef\u5e94\u7528id", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            String[] stringsIds = ids.split(",");
            List<String> list = Arrays.asList(stringsIds);
            String zipName = "ht_appModel_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map<String, String> strXml = ((AppModelManager)this.baseService).exportData(list);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, strXml, (String)zipName);
        }
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u79fb\u52a8\u7aef\u5e94\u7528\u5bfc\u5165", httpMethod="POST", notes="\u79fb\u52a8\u7aef\u5e94\u7528\u5bfc\u5165")
    public CommonResult<String> importData(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.appModelManager.importData(request, response);
    }

    @RequestMapping(value={"getRecentlyApps"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6700\u8fd1\u4f7f\u7528\u5e94\u7528", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6700\u8fd1\u4f7f\u7528\u5e94\u7528")
    public List<AppModel> getRecentlyApps() throws Exception {
        return this.appModelManager.getRecentlyApps();
    }

    @RequestMapping(value={"addRecentlyAppsCount"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u70b9\u51fb\u5e94\u7528\u589e\u52a0\u5e94\u7528\u70b9\u51fb\u6b21\u6570", httpMethod="GET", notes="\u6839\u636e\u7528\u6237\u70b9\u51fb\u5e94\u7528\u589e\u52a0\u5e94\u7528\u70b9\u51fb\u6b21\u6570")
    public CommonResult<Boolean> addRecentlyAppsCount(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=false) String account, @ApiParam(name="appId", value="appId") @RequestParam(required=true) String appId) throws Exception {
        return this.appModelManager.addRecentlyAppsCount(account, appId);
    }
}

