/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.controller.BaseController;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.portal.annotation.ColumnAuth;
import com.hotent.portal.model.CommonFlow;
import com.hotent.portal.model.Type;
import com.hotent.portal.persistence.manager.ICommonFlowService;
import com.hotent.portal.persistence.manager.IPermissionService;
import com.hotent.portal.util.RedisCachUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal/common-flow/v1"})
public class CommonFlowController
extends BaseController<ICommonFlowService, CommonFlow> {
    @Resource
    IPermissionService permissionService;

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u6dfb\u52a0\u6743\u9650\u7684\u63a5\u53e3")
    public CommonResult<String> createOrUpdate(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody CommonFlow CommonFlow2) {
        if (BeanUtils.isEmpty((Object)CommonFlow2.getId())) {
            CommonFlow byCode = ((ICommonFlowService)this.baseService).getByCode(CommonFlow2.getFlowCode());
            if (BeanUtils.isNotEmpty((Object)((Object)byCode))) {
                return new CommonResult(false, String.format("\u6d41\u7a0b\u7f16\u7801\u3010%s\u3011\u5df2\u5b58\u5728\uff01", CommonFlow2.getFlowCode()));
            }
            try {
                ((ICommonFlowService)this.baseService).save((Object)CommonFlow2);
            }
            catch (DuplicateKeyException e) {
                return new CommonResult(false, "\u6d41\u7a0b\u7f16\u7801\u5df2\u5b58\u5728\uff01");
            }
        } else {
            ((ICommonFlowService)this.baseService).update((Model)CommonFlow2);
        }
        RedisCachUtil bean = (RedisCachUtil)AppUtil.getBean(RedisCachUtil.class);
        bean.delFlowState(CommonFlow2.getFlowCode());
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/moreFlows"})
    @ApiOperation(value="\u83b7\u53d6\u66f4\u591a\u7cfb\u7edf")
    @ColumnAuth(value="COMMON-FLOW", returnType="list")
    public List<Type> getMoreFlows(@RequestParam String flowName, @ApiParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801", required=false) @RequestParam(required=false) Optional<String> postCode) {
        return ((ICommonFlowService)this.baseService).getMoreFlows(flowName, postCode.orElse(null));
    }

    @GetMapping(value={"/homeFlows"})
    @ApiOperation(value="\u83b7\u53d6\u9996\u9875\u7cfb\u7edf")
    @ColumnAuth(value="COMMON-FLOW", returnType="list")
    public List<CommonFlow> getHomeFlows() {
        return ((ICommonFlowService)this.baseService).getHomeFlows();
    }

    @GetMapping(value={"/homeFlowsV1"})
    @ApiOperation(value="\u83b7\u53d6\u9996\u9875\u7cfb\u7edf")
    @ColumnAuth(value="COMMON-FLOW", returnType="list")
    public List<CommonFlow> getHomeFlowsV1(@ApiParam(name="count", value="\u6570\u91cf", required=false) @RequestParam(required=false) Optional<Integer> count) {
        return ((ICommonFlowService)this.baseService).getHomeFlowsV1(count.orElse(10));
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        List commonFlowList = ((ICommonFlowService)this.baseService).listByIds(Arrays.asList(ids));
        RedisCachUtil redisCachUtil = (RedisCachUtil)AppUtil.getBean(RedisCachUtil.class);
        if (!commonFlowList.isEmpty()) {
            commonFlowList.forEach(t -> redisCachUtil.delFlowState(t.getFlowCode()));
        }
        boolean result = ((ICommonFlowService)this.baseService).removeByIds(Arrays.asList(ids));
        Stream.of(ids).forEach(id -> this.permissionService.removeByAuthorizeId((String)id));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }
}

