/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.controller.BaseController;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.portal.annotation.ColumnAuth;
import com.hotent.portal.model.CommonSystem;
import com.hotent.portal.model.Type;
import com.hotent.portal.persistence.manager.ICommonSystemService;
import com.hotent.portal.persistence.manager.IPermissionService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portal/common-system/v1"})
public class CommonSystemController
extends BaseController<ICommonSystemService, CommonSystem> {
    @Resource
    IPermissionService permissionService;

    @PostMapping(value={"/queryPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<CommonSystem> queryPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<CommonSystem> queryFilter, @ApiParam(name="form", value="\u7c7b\u522b\uff1aSYSTEM\uff08\u5e38\u7528\u7cfb\u7edf\uff09\u3001BI\uff08BI\u62a5\u8868\uff09", required=false) Optional<String> form) {
        queryFilter.addFilter("form", (Object)form.orElse("SYSTEM"), QueryOP.EQUAL, FieldRelation.AND, "FORM");
        return ((ICommonSystemService)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u6dfb\u52a0\u6743\u9650\u7684\u63a5\u53e3")
    public CommonResult<String> createOrUpdate(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody CommonSystem commonSystem) {
        if (BeanUtils.isEmpty((Object)commonSystem.getId())) {
            CommonSystem dbCommonSystem = ((ICommonSystemService)this.baseService).getByCode(commonSystem.getSystemCode(), commonSystem.getForm());
            if (BeanUtils.isNotEmpty((Object)((Object)dbCommonSystem))) {
                return new CommonResult(false, String.format("\u7f16\u7801\u3010%s\u3011\u5df2\u5b58\u5728\uff01", commonSystem.getSystemCode()));
            }
            try {
                ((ICommonSystemService)this.baseService).save((Object)commonSystem);
            }
            catch (DuplicateKeyException e) {
                return new CommonResult(false, "\u7cfb\u7edf\u7f16\u7801\u5df2\u5b58\u5728\uff01");
            }
        } else {
            ((ICommonSystemService)this.baseService).update((Model)commonSystem);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveWithFile"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\uff08\u5305\u542b\u6587\u4ef6\uff09")
    public CommonResult<String> saveWithFile(MultipartHttpServletRequest request) throws IOException {
        MultipartFile file = request.getFile("file");
        String json = request.getParameter("json");
        CommonSystem commonSystem = (CommonSystem)((Object)JsonUtil.toBean((String)json, CommonSystem.class));
        if ("SYSTEM".equals(commonSystem.getForm())) {
            if (BeanUtils.isEmpty((Object)file) && BeanUtils.isEmpty((Object)commonSystem.getIconUrl())) {
                throw new BaseException("\u8bf7\u4e0a\u4f20\u7cfb\u7edf\u56fe\u6807");
            }
            if (BeanUtils.isNotEmpty((Object)file)) {
                commonSystem.setIconUrl(file.getBytes());
            }
        }
        if (BeanUtils.isEmpty((Object)commonSystem.getId())) {
            CommonSystem dbCommonSystem = ((ICommonSystemService)this.baseService).getByCode(commonSystem.getSystemCode(), commonSystem.getForm());
            if (BeanUtils.isNotEmpty((Object)((Object)dbCommonSystem))) {
                return new CommonResult(false, String.format("\u7f16\u7801\u3010%s\u3011\u5df2\u5b58\u5728\uff01", commonSystem.getSystemCode()));
            }
            ((ICommonSystemService)this.baseService).save((Object)commonSystem);
        } else {
            ((ICommonSystemService)this.baseService).update((Model)commonSystem);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/iconPreview"})
    @ApiOperation(value="\u9884\u89c8\u6587\u4ef6")
    public void previewIcon(@RequestParam String id, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        response.setContentType("image/jpeg");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{CommonSystem::getIconUrl}).eq(CommonSystem::getId, (Object)id);
        CommonSystem commonSystem = (CommonSystem)((Object)((ICommonSystemService)this.baseService).getOne((Wrapper)wrapper));
        if (BeanUtils.isEmpty((Object)((Object)commonSystem))) {
            return;
        }
        String agent = request.getHeader("USER-AGENT");
        String filedisplay = UniqueIdUtil.getSuid() + ".jpg";
        filedisplay = agent != null && !agent.contains("MSIE") && !agent.contains("Trident") ? "=?UTF-8?B?" + Base64.getBase64((String)filedisplay) + "?=" : URLEncoder.encode(filedisplay, "utf-8");
        response.addHeader("filename", filedisplay);
        response.setHeader("Access-Control-Allow-Origin", "*");
        byte[] fileBlob = commonSystem.getIconUrl();
        try {
            response.getOutputStream().write(fileBlob);
            response.getOutputStream().flush();
        }
        finally {
            if (response.getOutputStream() != null) {
                response.getOutputStream().close();
            }
        }
    }

    @GetMapping(value={"/iconUrl"})
    @ApiOperation(value="\u83b7\u53d6\u56fe\u7247")
    public CommonResult<byte[]> getIconUrl(@RequestParam String id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{CommonSystem::getIconUrl}).eq(CommonSystem::getId, (Object)id);
        CommonSystem commonSystem = (CommonSystem)((Object)((ICommonSystemService)this.baseService).getOne((Wrapper)wrapper));
        if (BeanUtils.isEmpty((Object)((Object)commonSystem))) {
            return new CommonResult(true, "\u5931\u8d25", null);
        }
        return new CommonResult(true, "\u6210\u529f", (Object)commonSystem.getIconUrl());
    }

    @GetMapping(value={"/moreSystems"})
    @ApiOperation(value="\u83b7\u53d6\u66f4\u591a\u7cfb\u7edf")
    @ColumnAuth(value="COMMON-SYSTEM", returnType="list")
    public List<Type> getSystems(@RequestParam String type, @RequestParam(required=false) String systemName, @RequestParam(required=false) String operation, @ApiParam(name="form", value="\u7c7b\u522b\uff1aSYSTEM\uff08\u5e38\u7528\u7cfb\u7edf\uff09\u3001BI\uff08BI\u62a5\u8868\uff09", required=false) Optional<String> form) {
        return ((ICommonSystemService)this.baseService).getSystems(type, systemName, operation, form.orElse("SYSTEM"));
    }

    @GetMapping(value={"/homeSystems"})
    @ApiOperation(value="\u83b7\u53d6\u9996\u9875\u7cfb\u7edf")
    @ColumnAuth(value="COMMON-SYSTEM", returnType="list")
    public List<CommonSystem> getHomeSystems(@ApiParam(name="terminalType", value="\u7ec8\u7aef\u7c7b\u578b", required=false) @RequestParam(required=false) Optional<String> terminalType, @ApiParam(name="count", value="\u6570\u91cf", required=false) @RequestParam(required=false) Optional<Integer> count, @ApiParam(name="form", value="\u7c7b\u522b\uff1aSYSTEM\uff08\u5e38\u7528\u7cfb\u7edf\uff09\u3001BI\uff08BI\u62a5\u8868\uff09", required=false) Optional<String> form) {
        return ((ICommonSystemService)this.baseService).getHomeSystems(terminalType.orElse("pc"), count.orElse(10), form.orElse("SYSTEM"));
    }

    @GetMapping(value={"/homeSystemsV1"})
    @ApiOperation(value="\u83b7\u53d6\u9996\u9875\u7cfb\u7edf")
    @ColumnAuth(value="COMMON-SYSTEM", returnType="list")
    public List<CommonSystem> getHomeSystemsV1(@ApiParam(name="terminalType", value="\u7ec8\u7aef\u7c7b\u578b", required=false) @RequestParam(required=false) Optional<String> terminalType, @ApiParam(name="count", value="\u6570\u91cf", required=false) @RequestParam(required=false) Optional<Integer> count, @ApiParam(name="form", value="\u7c7b\u522b\uff1aSYSTEM\uff08\u5e38\u7528\u7cfb\u7edf\uff09\u3001BI\uff08BI\u62a5\u8868\uff09", required=false) Optional<String> form) {
        return ((ICommonSystemService)this.baseService).getHomeSystemsV1(terminalType.orElse("pc"), count.orElse(10), form.orElse("SYSTEM"));
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((ICommonSystemService)this.baseService).removeByIds(Arrays.asList(ids));
        Stream.of(ids).forEach(id -> this.permissionService.removeByAuthorizeId((String)id));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/addedSystems"})
    @ApiOperation(value="\u83b7\u53d6\u5df2\u6dfb\u52a0\u7cfb\u7edf")
    public List<CommonSystem> getAddedSystems(@ApiParam(name="form", value="\u7c7b\u522b\uff1aSYSTEM\uff08\u5e38\u7528\u7cfb\u7edf\uff09\u3001BI\uff08BI\u62a5\u8868\uff09", required=false) Optional<String> form) {
        return ((ICommonSystemService)this.baseService).getAddedSystems("pc", form.orElse("SYSTEM"));
    }
}

