/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.i18n.persistence.manager.I18nMessageManager;
import com.hotent.i18n.persistence.manager.I18nMessageTypeManager;
import com.hotent.i18n.persistence.model.I18nMessage;
import com.hotent.i18n.persistence.model.I18nMessageType;
import com.hotent.i18n.support.service.MessageService;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.portal.params.I18nMessageExportParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import poi.util.ExcelUtil;

@RestController
@RequestMapping(value={"/i18n/custom/i18nMessage/v1/"})
@Api(tags={"\u56fd\u9645\u5316\u8d44\u6e90"})
@ApiGroup(group={"group_portal"})
public class I18nMessageController
extends BaseController<I18nMessageManager, I18nMessage> {
    @Resource
    I18nMessageManager i18nMessageManager;
    @Resource
    MessageService messageService;
    @Resource
    I18nMessageTypeManager i18nMessageTypeManager;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u56fd\u9645\u5316\u8d44\u6e90\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u56fd\u9645\u5316\u8d44\u6e90\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<Map<String, String>> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<I18nMessage> queryFilter) throws Exception {
        return this.i18nMessageManager.getList(queryFilter);
    }

    @RequestMapping(value={"getAll"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u56fd\u9645\u5316\u8d44\u6e90\u5217\u8868(\u4e0d\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u4e0d\u56fd\u9645\u5316\u8d44\u6e90\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public List<I18nMessage> getAllI18nSourceKeys() throws Exception {
        return this.i18nMessageManager.list();
    }

    @RequestMapping(value={"init"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u521d\u59cb\u5316\u56fd\u9645\u5316\u8d44\u6e90\u5230Cache\u4e2d", httpMethod="POST", notes="\u521d\u59cb\u5316\u56fd\u9645\u5316\u8d44\u6e90\u5230Cache\u4e2d")
    public CommonResult<String> init() throws Exception {
        this.messageService.initMessage();
        return new CommonResult("\u521d\u59cb\u5316\u8d44\u6e90\u6210\u529f");
    }

    public static void main(String[] args) throws Exception {
        String userIds = "11,12,123,132";
        System.out.println(userIds.split(","));
    }

    @RequestMapping(value={"clearCache"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6e05\u7a7aCache\u4e2d\u7684\u6240\u6709\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="POST", notes="\u6e05\u7a7aCache\u4e2d\u7684\u6240\u6709\u56fd\u9645\u5316\u8d44\u6e90")
    public void clearCache() throws Exception {
        this.messageService.clearAllMessage();
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u56fd\u9645\u5316\u8d44\u6e90\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u56fd\u9645\u5316\u8d44\u6e90\u660e\u7ec6\u9875\u9762")
    public Object getJson(@ApiParam(name="id", value="i18n\u5b9a\u4e49id", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new I18nMessage();
        }
        I18nMessage i18nMessage = (I18nMessage)this.i18nMessageManager.get((Serializable)((Object)id));
        return i18nMessage;
    }

    @RequestMapping(value={"getI18nMessageJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ekey\u83b7\u53d6\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="POST", notes="\u6839\u636ekey\u83b7\u53d6\u56fd\u9645\u5316\u8d44\u6e90")
    public Object getI18nMessageJson(@ApiParam(name="key", value="i18n\u5b9a\u4e49\u7684key", required=true) @RequestParam String key) throws Exception {
        Object res = this.i18nMessageManager.getI18nMessageJson(key);
        return res;
    }

    @RequestMapping(value={"getByMessKey"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ekey\u83b7\u53d6\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="POST", notes="\u6839\u636ekey\u83b7\u53d6\u56fd\u9645\u5316\u8d44\u6e90")
    public Object getByMessKey(@ApiParam(name="key", value="i18n\u5b9a\u4e49\u7684key", required=true) @RequestParam String key) throws Exception {
        Map map = null;
        String dbType = SQLUtil.getDbType();
        map = this.i18nMessageManager.getByMesKey(key, dbType);
        return map;
    }

    @RequestMapping(value={"delByKey"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8d44\u6e90key\u5220\u9664\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="DELETE", notes="\u6839\u636e\u8d44\u6e90key\u5220\u9664\u56fd\u9645\u5316\u8d44\u6e90")
    public Object delByKey(@ApiParam(name="key", value="i18n\u5b9a\u4e49\u7684key", required=true) @RequestParam String key) throws Exception {
        try {
            String[] keys = StringUtil.getStringAryByStr((String)key);
            this.i18nMessageManager.delByKeys(keys);
            return new CommonResult(true, I18nUtil.getMessage((String)"\u5220\u9664\u6210\u529f", (Locale)LocaleContextHolder.getLocale()), null);
        }
        catch (Exception e) {
            return new CommonResult(false, I18nUtil.getMessage((String)"\u5220\u9664\u5931\u8d25", (Locale)LocaleContextHolder.getLocale()), null);
        }
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u56fd\u9645\u5316\u8d44\u6e90\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u56fd\u9645\u5316\u8d44\u6e90\u4fe1\u606f")
    public Object save(@ApiParam(name="i18nMessage", value="i18n\u5b9a\u4e49\u7684\u5b9e\u4f53", required=true) @RequestBody I18nMessage i18nMessage, @ApiParam(name="oldKey", value="i18n\u5b9a\u4e49\u7684oldKey", required=true) @RequestParam String oldKey) throws Exception {
        try {
            this.i18nMessageManager.saveI18nMessage(i18nMessage.getKey(), i18nMessage.getMesTypeInfo(), oldKey);
            return new CommonResult(true, I18nUtil.getMessage((String)"i18nMessage.operationSuccess", (Locale)LocaleContextHolder.getLocale()), null);
        }
        catch (Exception e) {
            return new CommonResult(false, I18nUtil.getMessage((String)"i18nMessage.operationFail", (Locale)LocaleContextHolder.getLocale()), null);
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u56fd\u9645\u5316\u8d44\u6e90\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u56fd\u9645\u5316\u8d44\u6e90\u8bb0\u5f55")
    public Object remove(@ApiParam(name="ids", value="i18n\u5b9a\u4e49ids", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.i18nMessageManager.removeByIds(aryIds);
            return new CommonResult(true, I18nUtil.getMessage((String)"\u6279\u91cf\u5220\u9664\u6210\u529f", (Locale)LocaleContextHolder.getLocale()), null);
        }
        catch (Exception e) {
            return new CommonResult(false, I18nUtil.getMessage((String)"\u6279\u91cf\u5220\u9664\u5931\u8d25", (Locale)LocaleContextHolder.getLocale()), null);
        }
    }

    @RequestMapping(value={"jsResource/{jsAlias}"})
    public void getJsResource(@PathVariable(value="jsAlias") String jsAlias, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.i18nMessageManager.getJsResource(jsAlias, request, response);
    }

    @RequestMapping(value={"importMessage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4eceexcel\u5bfc\u5165\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="POST", notes="\u4eceexcel\u5bfc\u5165\u56fd\u9645\u5316\u8d44\u6e90")
    public Object importMessage(@ApiParam(name="file", value="i18n\u5b9a\u4e49file", required=true) @RequestParam MultipartFile file) throws Exception {
        String resultMsg = "";
        try {
            this.i18nMessageManager.importMessage(file);
            resultMsg = "\u5bfc\u5165\u56fd\u9645\u5316\u8d44\u6e90\u6210\u529f\uff01";
            return new CommonResult(true, resultMsg, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"exportMessage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u56fd\u9645\u5316\u8d44\u6e90", httpMethod="POST", notes="\u5bfc\u51fa\u56fd\u9645\u5316\u8d44\u6e90")
    public void exportMessage(HttpServletResponse response, @ApiParam(name="body", value="\u56fd\u9645\u5316\u8d44\u6e90keys json\u683c\u5f0f\u6570\u636e", required=false) @RequestBody(required=false) I18nMessageExportParam body) throws Exception {
        try {
            List<String> keyList = null;
            if (BeanUtils.isNotEmpty((Object)body) && BeanUtils.isNotEmpty(body.getKeys())) {
                keyList = body.getKeys();
            }
            HSSFWorkbook book = this.i18nMessageManager.exportExcel(keyList);
            ExcelUtil.downloadExcel((Workbook)book, (String)"\u56fd\u9645\u5316\u8d44\u6e90\u5217\u8868", (HttpServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"getListJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eval\u83b7\u53d6\u6240\u6709\u6570\u636e", httpMethod="POST", notes="\u6839\u636eval\u83b7\u53d6\u6240\u6709\u6570\u636e")
    public Object getListJson(@ApiParam(name="val", value="i18n\u5b9a\u4e49val", required=true) @RequestParam String val) throws Exception {
        Object res = this.i18nMessageManager.getListJson(val);
        return res;
    }

    @GetMapping(value={"getLangPackage"})
    @ApiOperation(value="\u83b7\u53d6\u8bed\u8a00\u5305", httpMethod="GET")
    public Map<String, String> getLangPackage(@ApiParam(name="type", value="\u8bed\u79cd\u7684type", required=true) @RequestParam(value="type") String type) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"type_", (Object)type)).orderByAsc((Object)"key_");
        List list = ((I18nMessageManager)this.baseService).list((Wrapper)queryWrapper);
        HashMap<String, String> map = new HashMap<String, String>();
        for (I18nMessage message : list) {
            map.put(message.getKey(), message.getValue());
        }
        return map;
    }

    @GetMapping(value={"downloadTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f", httpMethod="GET", notes="\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f")
    public void downloadTemplate(HttpServletResponse response) throws Exception {
        List allType = this.i18nMessageTypeManager.getAllType();
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("key", "\u8d44\u6e90KEY");
        for (I18nMessageType type : allType) {
            exportMaps.put(type.getType(), type.getDesc() + "[" + type.getType() + "]");
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)"\u56fd\u9645\u5316\u8bed\u8a00\u5bfc\u5165\u6a21\u677f", (int)24, exportMaps, new ArrayList());
        ExcelUtil.downloadExcel((Workbook)book, (String)"\u56fd\u9645\u5316\u8bed\u8a00_\u5bfc\u5165\u6a21\u677f", (HttpServletResponse)response);
    }

    @RequestMapping(value={"hasI18nSourceKey"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636ekey\u548c\u4e1a\u52a1\u7cfb\u7edfkey\u5224\u65ad\u56fd\u9645\u5316\u8d44\u6e90\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="POST", notes="\u6839\u636ekey\u548c\u4e1a\u52a1\u7cfb\u7edfkey\u5224\u65ad\u56fd\u9645\u5316\u8d44\u6e90\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    public CommonResult<Boolean> hasI18nSourceKey(@ApiParam(name="key", value="i18n\u5b9a\u4e49\u7684key", required=true) @RequestParam String key) throws Exception {
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)this.i18nMessageManager.hasI18nSourceKey(key));
    }

    @RequestMapping(value={"getZhCNByOtherLanguages"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u56fd\u9645\u5316\u540e\u7684\u6570\u636e\u627e\u5230\u5bf9\u5e94\u7684\u4e2d\u6587", httpMethod="GET", notes="\u901a\u8fc7\u56fd\u9645\u5316\u540e\u7684\u6570\u636e\u627e\u5230\u5bf9\u5e94\u7684\u4e2d\u6587")
    public CommonResult<I18nMessage> getZhCNByOtherLanguages(@ApiParam(name="key", value="i18n\u5b9a\u4e49\u7684key", required=true) @RequestParam String i18nLanguage) {
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)this.i18nMessageManager.getZhCNByOtherLanguage(i18nLanguage));
    }
}

