/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.portal.model.PortalBizSystem;
import com.hotent.portal.service.PortalBizSystemManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portalBizSystem/v1/"})
@Api(tags={"\u5916\u90e8\u7cfb\u7edf\u7ba1\u7406"})
@ApiGroup(group={"group_portal"})
public class PortalBizSystemController
extends BaseController<PortalBizSystemManager, PortalBizSystem> {
    @Autowired
    PortalBizSystemManager portalBizSystemManager;

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> createPortalBizSystem(@ApiParam(name="PortalBizSystem", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody PortalBizSystem portalBizSystem) {
        return this.portalBizSystemManager.savePortalBizSystem(portalBizSystem);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> updatePortalBizSystem(@ApiParam(name="PortalBizSystem", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody PortalBizSystem portalBizSystem) {
        return this.portalBizSystemManager.updatePortalBizSystem(portalBizSystem);
    }

    @RequestMapping(value={"/queryData"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public PageList queryData(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter) {
        return this.portalBizSystemManager.queryData(queryFilter);
    }

    @RequestMapping(value={"/searchById"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636eID\u641c\u7d22\u5916\u90e8\u7cfb\u7edf\u4fe1\u606f")
    public CommonResult searchById(@RequestParam(value="id") String id) {
        return this.portalBizSystemManager.searchById(id);
    }

    @RequestMapping(value={"/getOpenApiList"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u5916\u90e8\u63a5\u53e3\u7684\u5217\u8868")
    public CommonResult getOpenApiList() {
        return this.portalBizSystemManager.getOpenApiList();
    }

    @RequestMapping(value={"/checkSysCode"}, method={RequestMethod.GET})
    @ApiOperation(value="\u9a8c\u8bc1\u7cfb\u7edf\u7f16\u7801\u6216\u7cfb\u7edf\u5bc6\u5319\u662f\u5426\u6b63\u786e")
    public CommonResult checkSysCode(@RequestParam(value="sysCode", required=true) String sysCode, @RequestParam(value="secretKey", required=false) String secretKey) throws Exception {
        return this.portalBizSystemManager.checkSysCode(sysCode, secretKey);
    }

    @RequestMapping(value={"/checkSysCodeAndUri"}, method={RequestMethod.GET})
    @ApiOperation(value="\u9a8c\u8bc1\u7cfb\u7edf\u7f16\u7801\u662f\u5426\u6b63\u786e\u548cURI\u662f\u5426\u5df2\u88ab\u6388\u6743")
    public CommonResult checkSysCode(@RequestParam(value="sysCode", required=true) String sysCode, @RequestParam(value="secretKey", required=false) String secretKey, @RequestParam(value="uri") String uri, @RequestParam(value="tenantId") String tenantId) {
        return this.portalBizSystemManager.checkSysCodeAndUri(sysCode, secretKey, uri, tenantId);
    }

    @RequestMapping(value={"/getPortalBizSystemBySysCode"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u7cfb\u7edf\u7f16\u7801\u83b7\u53d6\u8be5\u5916\u90e8\u7cfb\u7edf\u5bf9\u5e94\u7684\u961f\u5217\u540d\uff0c\u7528\u4e8e\u8fdc\u7a0b\u8c03\u7528")
    public CommonResult getPortalBizSystemBySysCode(@RequestParam(value="sysCode", required=true) String sysCode) {
        return this.portalBizSystemManager.getPortalBizSystemBySysCode(sysCode);
    }

    @RequestMapping(value={"/getPortalBizSystemByCode"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u7cfb\u7edf\u7f16\u7801\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf")
    public CommonResult getPortalBizSystemByCode(@RequestParam(value="code", required=true) String code) {
        return this.portalBizSystemManager.getPortalBizSystemByCode(code);
    }

    @RequestMapping(value={"getList"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u5217\u8868\u6570\u636e")
    public List<PortalBizSystem> getList() throws Exception {
        return this.portalBizSystemManager.getList();
    }

    @GetMapping(value={"getDetail"})
    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf\u4fe1\u606f")
    public PortalBizSystem getDetail(@ApiParam(name="id", value="ID") @RequestParam String id) throws Exception {
        return (PortalBizSystem)this.portalBizSystemManager.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getServiceList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u6570\u636e\uff08\u5305\u542b\u5fae\u670d\u52a1\u53ca\u5916\u90e8\u670d\u52a1\u6570\u636e")
    public List<PortalBizSystem> getServiceList() throws Exception {
        return this.portalBizSystemManager.getServiceList();
    }

    @RequestMapping(value={"getAuthUserBySystemCode"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6839\u636e\u5916\u90e8\u7cfb\u7edf\u7684\u7f16\u7801\u83b7\u53d6\u7ba1\u7406\u4eba\u5458", httpMethod="POST", notes="\u6839\u636e\u5916\u90e8\u7cfb\u7edf\u7684\u7f16\u7801\u83b7\u53d6\u7ba1\u7406\u4eba\u5458")
    public CommonResult getAuthUserBySystemId(@RequestBody QueryFilter queryFilter) {
        return this.portalBizSystemManager.getAuthUserBySystemCode(queryFilter);
    }

    @RequestMapping(value={"deleteAuthByIds"}, method={RequestMethod.DELETE})
    @ApiOperation(value="\u6839\u636e\u7ba1\u7406\u5458id\u548c\u7cfb\u7edf\u7f16\u7801\u6765\u5220\u9664\u7ba1\u7406\u5458\u7684\u6743\u9650", httpMethod="GET", notes="\u6839\u636e\u7ba1\u7406\u5458id\u548c\u7cfb\u7edf\u7f16\u7801\u6765\u5220\u9664\u7ba1\u7406\u5458\u7684\u6743\u9650")
    public CommonResult deleteAuthByIds(@RequestParam(value="ids") String ids) {
        return this.portalBizSystemManager.deleteAuthByIds(ids);
    }

    @RequestMapping(value={"addAuthByUserIdAndSysCode"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u7ba1\u7406\u5458id\u548c\u7cfb\u7edf\u7f16\u7801\u6765\u6dfb\u52a0\u7ba1\u7406\u5458\u7684\u6743\u9650", httpMethod="GET", notes="\u6839\u636e\u7ba1\u7406\u5458id\u548c\u7cfb\u7edf\u7f16\u7801\u6765\u6dfb\u52a0\u7ba1\u7406\u5458\u7684\u6743\u9650")
    public CommonResult addAuthByUserIdAndSysCode(@RequestParam(value="userIds") String userIds, @RequestParam(value="sysCode") String sysCode) {
        return this.portalBizSystemManager.addAuthByUserIdAndSysCode(userIds, sysCode);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    @ApiOperation(value="\u6839\u636e\u7cfb\u7edf\u7f16\u7801\u7684id\u6765\u5220\u9664", httpMethod="DELETE", notes="\u6839\u636e\u7cfb\u7edf\u7f16\u7801\u7684id\u6765\u5220\u9664")
    public CommonResult deleteBySystemId(@RequestParam(value="sysCode") String sysCode) {
        return this.portalBizSystemManager.deleteBySysCode(sysCode);
    }

    @RequestMapping(value={"getTodoTopicKeys"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5bf9\u63a5\u7edf\u4e00\u5f85\u529e\u7684\u5f85\u529e\u6d88\u606f\u63a8\u9001mq\u961f\u5217\u540d", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709\u5bf9\u63a5\u7edf\u4e00\u5f85\u529e\u7684\u5f85\u529e\u6d88\u606f\u63a8\u9001mq\u961f\u5217\u540d")
    public Set<String> getTodoTopicKeys() {
        return this.portalBizSystemManager.getTodoTopicKeys();
    }
}

