/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.sys.persistence.manager.SysAppAuthMenuManager;
import com.hotent.sys.persistence.manager.SysAppMenuManager;
import com.hotent.sys.persistence.model.SysAppMenu;
import com.hotent.sys.persistence.param.SysAppAuthMenuDTO;
import com.hotent.sys.vo.SysMenuSortVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/portal/sysAppMenu/v1"})
@Api(tags={"sysAppMenuController"})
public class SysAppMenuController
extends BaseController<SysAppMenuManager, SysAppMenu> {
    @Resource
    SysAppMenuManager sysAppMenuManager;
    @Resource
    SysAppAuthMenuManager sysAppAuthMenuManager;

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u5e94\u7528\u83dc\u5355\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u5e94\u7528\u83dc\u5355\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="sysAppMenu", value="\u5e94\u7528\u83dc\u5355\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody SysAppMenu sysAppMenu) throws Exception {
        ((SysAppMenuManager)this.baseService).createOrUpdate(sysAppMenu);
        return new CommonResult(true, "\u4fdd\u5b58\u5e94\u7528\u83dc\u5355\u6210\u529f");
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5e94\u7528\u83dc\u5355\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5e94\u7528\u83dc\u5355\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.sysAppMenuManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        this.sysAppMenuManager.removeResById(id);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6APP\u83dc\u5355\u6811", httpMethod="GET", notes="\u83b7\u53d6APP\u83dc\u5355\u6811")
    public List<SysAppMenu> getTree(@RequestParam(value="appId") String appId) {
        return ((SysAppMenuManager)this.baseService).getMenuTree(appId);
    }

    @PostMapping(value={"import"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u5bfc\u5165", httpMethod="POST", notes="\u83dc\u5355\u5bfc\u5165")
    public CommonResult<String> importData(@RequestBody MultipartFile file, @ApiParam(name="parentMenuId", value="\u7236\u83dc\u5355ID", required=true) @RequestParam String parentMenuId, @ApiParam(name="appId", value="appId") @RequestParam String appId) throws Exception {
        return ((SysAppMenuManager)this.baseService).importData(file, parentMenuId, appId);
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u5bfc\u51fa", httpMethod="GET", notes="\u83dc\u5355\u5bfc\u51fa")
    public void export(@ApiParam(name="appId", value="\u5e94\u7528ID") @RequestParam(required=false) String appId, @ApiParam(name="parentMenuId", value="\u7236\u83dc\u5355ID") @RequestParam(required=false) String parentMenuId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((SysAppMenuManager)this.baseService).exportData(appId, parentMenuId, request, response);
    }

    @RequestMapping(value={"/single"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u5bfc\u51fa", httpMethod="GET", notes="\u83dc\u5355\u5bfc\u51fa")
    public CommonResult<SysAppMenu> isSinglePage(@ApiParam(name="appId", value="\u5e94\u7528ID") @RequestParam(required=false) String appId) throws Exception {
        return ((SysAppMenuManager)this.baseService).isSinglePage(appId);
    }

    @PostMapping(value={"sort"})
    @ApiOperation(value="\u83dc\u5355\u6392\u5e8f", httpMethod="GET", notes="\u83dc\u5355\u6392\u5e8f")
    public CommonResult<String> sort(@ApiParam(name="appId", value="\u5e94\u7528ID") @RequestBody SysMenuSortVO sortVO) {
        return ((SysAppMenuManager)this.baseService).sort(sortVO);
    }

    @GetMapping(value={"current/menus"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u6388\u6743\u83dc\u5355", httpMethod="GET", notes="\u83b7\u53d6\u5e94\u7528\u6388\u6743\u83dc\u5355")
    public List<SysAppMenu> getAppCurrentMenus(@ApiParam(name="appId", value="\u5e94\u7528ID") @RequestParam String appId) {
        return ((SysAppMenuManager)this.baseService).getAppCurrentMenus(appId);
    }

    @GetMapping(value={"menu/authorization"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u6388\u6743\u83dc\u5355", httpMethod="GET", notes="\u83b7\u53d6\u5e94\u7528\u6388\u6743\u83dc\u5355")
    public List<SysAppMenu> getMenuAuthorization(@ApiParam(name="appId", value="\u5e94\u7528ID") @RequestParam String appId, @RequestParam String roleAlias) {
        return ((SysAppMenuManager)this.baseService).getMenuAuthorization(appId, roleAlias);
    }

    @PostMapping(value={"menu/authorization"})
    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u6388\u6743\u83dc\u5355", httpMethod="GET", notes="\u83b7\u53d6\u5e94\u7528\u6388\u6743\u83dc\u5355")
    public CommonResult<String> saveMenuAuthorization(@ApiParam(name="appId", value="\u5e94\u7528ID") @RequestBody SysAppAuthMenuDTO sysAppAuthMenu) {
        this.sysAppAuthMenuManager.saveMenuAuthorization(sysAppAuthMenu);
        return CommonResult.ok().message("\u4fdd\u5b58\u6210\u529f");
    }
}

