/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.portal.params.SaveRightsVo;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.impl.util.PermissionCalc;
import com.hotent.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/authUser/v1/"})
@Api(tags={"\u901a\u7528\u6743\u9650\u8bbe\u7f6e"})
@ApiGroup(group={"group_portal"})
public class SysAuthUserController
extends BaseController {
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    PermissionCalc permssionCalc;

    @RequestMapping(value={"getRights"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6743\u9650", httpMethod="GET", notes="\u83b7\u53d6\u6743\u9650")
    public ArrayNode getRights(@ApiParam(name="id", value="id") @RequestParam String id, @ApiParam(name="objType", value="objType") @RequestParam String objType) throws Exception {
        try {
            return this.sysAuthUserManager.getRights(id, objType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"getRightsAndDefaultRightType"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6743\u9650\u548c\u7cfb\u7edf\u9ed8\u8ba4\u7684\u6743\u9650\u7c7b\u578b", httpMethod="GET", notes="\u83b7\u53d6\u6743\u9650\u548c\u7cfb\u7edf\u9ed8\u8ba4\u7684\u6743\u9650\u7c7b\u578b")
    public Map<String, Object> getRightsAndDefaultRightType(@ApiParam(name="id", value="id") @RequestParam String id, @ApiParam(name="objType", value="objType") @RequestParam String objType) throws Exception {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("right", this.sysAuthUserManager.getRights(id, objType));
            result.put("type", AppUtil.getBean((String)"defaultObjectRightType"));
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"defaultRight"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u9ed8\u8ba4\u7684\u6743\u9650\u7c7b\u578b", httpMethod="GET", notes="\u83b7\u53d6\u7cfb\u7edf\u9ed8\u8ba4\u7684\u6743\u9650\u7c7b\u578b")
    public Map<String, Object> getDefaultRight() {
        return this.sysAuthUserManager.getDefaultRight();
    }

    @RequestMapping(value={"saveRights"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6743\u9650", httpMethod="POST", notes="\u4fdd\u5b58\u8282\u70b9json \u914d\u7f6e")
    public CommonResult<String> saveRights(@ApiParam(name="vo", value="\u8282\u70b9\u4fdd\u5b58\u5bf9\u8c61") @RequestBody SaveRightsVo rightsVo) throws Exception {
        String[] saveRightsIds = rightsVo.getId().split(",");
        String objType = rightsVo.getObjType();
        String ownerNameJson = rightsVo.getOwnerNameJson();
        try {
            for (int i = 0; i < saveRightsIds.length; ++i) {
                this.sysAuthUserManager.saveRights(saveRightsIds[i], objType, ownerNameJson);
            }
            IUser currentUser = ContextUtil.getCurrentUser();
            this.sysAuthUserManager.delUserMenu();
            this.sysAuthUserManager.delPopupCache();
            return new CommonResult("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u4fdd\u5b58\u6743\u9650\u5931\u8d25" + e.getMessage());
        }
    }

    @PostMapping(value={"batchSaveRights"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u6743\u9650", httpMethod="POST", notes="\u4fdd\u5b58\u8282\u70b9json \u914d\u7f6e")
    public CommonResult<String> batchSaveRights(@ApiParam(name="vo", value="\u8282\u70b9\u4fdd\u5b58\u5bf9\u8c61") @RequestBody SaveRightsVo rightsVos) throws Exception {
        try {
            this.sysAuthUserManager.batchSaveRights(rightsVos.getIds(), rightsVos.getObjType(), rightsVos.getOwnerNameJson());
            IUser currentUser = ContextUtil.getCurrentUser();
            this.sysAuthUserManager.delUserMenu();
            this.sysAuthUserManager.delPopupCache();
            return new CommonResult("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u4fdd\u5b58\u6743\u9650\u5931\u8d25" + e.getMessage());
        }
    }

    @RequestMapping(value={"getAuthorizeIdsByUserMap"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7objType\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6743\u9650", httpMethod="GET", notes="\u901a\u8fc7objType\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6743\u9650")
    public List<String> getAuthorizeIdsByUserMap(@ApiParam(name="objType", value="objType") @RequestParam String objType) throws Exception {
        return this.sysAuthUserManager.getAuthorizeIdsByUserMap(objType);
    }

    @RequestMapping(value={"hasRights"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u5bf9\u67d0\u4e2a\u6a21\u5757\u6570\u636e\u662f\u5426\u6709\u6743\u9650", httpMethod="GET", notes="\u5224\u65ad\u7528\u6237\u5bf9\u67d0\u4e2a\u6a21\u5757\u6570\u636e\u662f\u5426\u6709\u6743\u9650")
    public boolean hasRights(@ApiParam(name="authorizeId", value="authorizeId") @RequestParam String authorizeId) throws Exception {
        return this.sysAuthUserManager.hasRights(authorizeId);
    }

    @RequestMapping(value={"calcPermssion"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6743\u9650\u6570\u636e\u5224\u65ad\u5f53\u524d\u4eba\u662f\u5426\u6709\u6743\u9650", httpMethod="GET", notes="\u6839\u636e\u6743\u9650\u6570\u636e\u5224\u65ad\u5f53\u524d\u4eba\u662f\u5426\u6709\u6743\u9650")
    public boolean calcPermssion(@ApiParam(name="permssionJson", value="\u6743\u9650\u5b9a\u4e49json\u6570\u636e") @RequestParam String permssionJson) throws Exception {
        Map currentMap = this.permssionCalc.getCurrentProfiles();
        return this.permssionCalc.hasRight(permssionJson, currentMap);
    }

    @RequestMapping(value={"calcAllPermssion"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6743\u9650\u6570\u636e\u6279\u91cf\u5224\u65ad\u5f53\u524d\u4eba\u662f\u5426\u6709\u6743\u9650", httpMethod="GET", notes="\u6839\u636e\u6743\u9650\u6570\u636e\u6279\u91cf\u5224\u65ad\u5f53\u524d\u4eba\u662f\u5426\u6709\u6743\u9650")
    public ObjectNode calcAllPermssion(@ApiParam(name="permssionJson", value="\u6743\u9650\u5b9a\u4e49json\u6570\u636e") @RequestParam String permssionJson) throws Exception {
        ObjectNode res = this.sysAuthUserManager.calcAllPermssion(permssionJson);
        return res;
    }

    @RequestMapping(value={"getUserRightMap"}, method={RequestMethod.GET}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6743\u9650", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6743\u9650")
    public Map<String, Set<String>> getUserRightMapStr() throws Exception {
        return this.sysAuthUserManager.getUserRightMap();
    }
}

