/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.id.IdGenerator;
import com.hotent.base.model.CommonResult;
import com.hotent.base.model.ImportCheckResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.sys.persistence.manager.SysIdentityManager;
import com.hotent.sys.persistence.model.SysIdentity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/sys/identity/v1"})
@Api(tags={"\u6d41\u6c34\u53f7"})
@ApiGroup(group={"group_portal"})
public class SysIdentityController
extends BaseController<SysIdentityManager, SysIdentity> {
    @Resource
    SysIdentityManager identityManager;
    @Resource
    protected IdGenerator idGenerator;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u6c34\u53f7\u751f\u6210\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u6c34\u53f7\u751f\u6210\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<SysIdentity> listJson(HttpServletRequest request, HttpServletResponse reponse, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIdentity> queryFilter) throws Exception {
        return this.identityManager.query(queryFilter);
    }

    @RequestMapping(value={"getAll"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6d41\u6c34\u53f7", httpMethod="POST", notes="\u6d41\u6c34\u53f7\u751f\u6210\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public List<SysIdentity> getAll() throws Exception {
        return this.identityManager.list();
    }

    @RequestMapping(value={"getById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u6d41\u6c34\u53f7", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6\u6d41\u6c34\u53f7")
    public Object getById(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="id", value="\u6d41\u6c34\u53f7\u5b9a\u4e49Id", required=true) @RequestParam String id) throws Exception {
        SysIdentity identity = (SysIdentity)this.identityManager.get((Serializable)((Object)id));
        return identity;
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u6c34\u53f7\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u6d41\u6c34\u53f7\u660e\u7ec6\u9875\u9762")
    public Object get(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="id", value="\u6d41\u6c34\u53f7\u5b9a\u4e49Id", required=true) @RequestParam String id) throws Exception {
        SysIdentity identity = null;
        if (StringUtil.isNotEmpty((String)id)) {
            identity = (SysIdentity)this.identityManager.get((Serializable)((Object)id));
        }
        return identity;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u6c34\u53f7", httpMethod="POST", notes="\u4fdd\u5b58\u6d41\u6c34\u53f7")
    public Object save(@ApiParam(name="identity", value="\u6d41\u6c34\u53f7\u5b9a\u4e49", required=true) @RequestBody SysIdentity identity) throws Exception {
        Object res = this.identityManager.saveSysIdentity(identity);
        return res;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d41\u6c34\u53f7", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6d41\u6c34\u53f7")
    public Object remove(@ApiParam(name="ids", value="\u6d41\u6c34\u53f7\u5b9a\u4e49Ids", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.identityManager.removeByIds(Arrays.asList(aryIds));
            return new CommonResult(true, "\u5220\u9664\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"preview"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u6c34\u53f7\u9884\u89c8", httpMethod="GET", notes="\u6d41\u6c34\u53f7\u9884\u89c8")
    public PageList<SysIdentity> preview(@ApiParam(name="alias", value="\u6d41\u6c34\u53f7\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        List identities = this.identityManager.getPreviewIden(alias);
        return new PageList(identities);
    }

    @RequestMapping(value={"getNextIdByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u4e2a\u6d41\u6c34\u53f7", httpMethod="GET", notes="\u83b7\u53d6\u4e0b\u4e00\u4e2a\u6d41\u6c34\u53f7")
    public CommonResult<String> getNextIdByAlias(@ApiParam(name="alias", value="\u6d41\u6c34\u53f7\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", null);
        params.put("alias", alias);
        if (this.identityManager.isAliasExisted(params)) {
            String nextId = this.identityManager.nextId(alias);
            return new CommonResult(true, "\u83b7\u53d6\u6d41\u6c34\u53f7\u6210\u529f\uff01", (Object)nextId);
        }
        return new CommonResult(false, "\u83b7\u53d6\u6d41\u6c34\u53f7\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"getBatchByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u522b\u540d\u6279\u91cf\u83b7\u53d6\u6d41\u6c34\u53f7", httpMethod="GET", notes="\u6279\u91cf\u83b7\u53d6\u6d41\u6c34\u53f7")
    public CommonResult<List<String>> getBatchByAlias(@ApiParam(name="alias", value="\u6d41\u6c34\u53f7\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="offset", value="\u4e2a\u6570", required=true) @RequestParam Integer offset) {
        if (offset < 0) {
            return new CommonResult(false, "\u83b7\u53d6\u6d41\u6c34\u53f7\u5931\u8d25\uff0c \u4e2a\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        if (offset == 0) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", new ArrayList());
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)this.identityManager.nextIds(alias, offset));
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "identity_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String json = this.identityManager.export(idList);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"identity.json", (String)fileName);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u6d41\u6c34\u53f7", httpMethod="POST", notes="\u5bfc\u5165\u6d41\u6c34\u53f7")
    public CommonResult<String> importIdentity(MultipartHttpServletRequest request, HttpServletResponse response, @RequestParam(value="typeId") String typeId) throws Exception {
        CommonResult res = this.identityManager.importIdentity(request, response, typeId);
        return res;
    }

    @RequestMapping(value={"importData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2", httpMethod="POST", notes="\u5bfc\u5165\u81ea\u5b9a\u4e49\u67e5\u8be2")
    public CommonResult<String> importData(@ApiParam(name="unZipFilePath", value="unZipFilePath", required=true) @RequestParam String unZipFilePath, @ApiParam(name="status", value="status", required=true) @RequestParam String status, @RequestParam(value="typeId") String typeId) throws Exception {
        CommonResult res = this.identityManager.importFileData(unZipFilePath, status, typeId);
        return res;
    }

    @RequestMapping(value={"/identities"}, method={RequestMethod.GET})
    public List<SysIdentity> getIdentities(String ... alias) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (BeanUtils.isNotEmpty((Object)alias)) {
            wrapper.in(SysIdentity::getAlias, Arrays.asList(alias));
        }
        return ((SysIdentityManager)this.baseService).list((Wrapper)wrapper);
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u5bfc\u5165\u6d41\u6c34\u53f7", httpMethod="POST", notes="\u5bfc\u5165\u6d41\u6c34\u53f7")
    public List<ImportCheckResult> importCheck(@RequestBody List<SysIdentity> identities) {
        ArrayList<ImportCheckResult> results = new ArrayList<ImportCheckResult>();
        this.identityManager.importCheck(identities, sysIdentity -> results.add(new ImportCheckResult(true, "\u6d41\u6c34\u53f7", sysIdentity.getName())));
        return results;
    }

    @RequestMapping(value={"importData1"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u6d41\u6c34\u53f7", httpMethod="POST", notes="\u5bfc\u5165\u6d41\u6c34\u53f7")
    public CommonResult<String> importData1(@RequestBody List<SysIdentity> identities, @RequestParam(value="status") String status, @RequestParam(value="typeId") String typeId) {
        this.identityManager.importData(identities, status, typeId);
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }
}

