/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.jms.impl;

import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.JmsHandler;
import com.hotent.base.jms.JmsMessage;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.portal.model.MsgTemplate;
import com.hotent.portal.persistence.manager.MessageLogManager;
import com.hotent.portal.persistence.manager.MsgTemplateManager;
import com.hotent.portal.persistence.manager.SysMessageManager;
import com.hotent.portal.service.impl.TemplateServiceImpl;
import com.hotent.portal.util.JmsHandlerUtil;
import com.hotent.portal.util.WeiXinUtil;
import com.hotent.system.model.SysExternalUnite;
import com.hotent.system.model.msg.WXTemplateParam;
import com.hotent.system.model.msg.WxBaseMessage;
import com.hotent.system.model.msg.impl.WxMarkdownMessage;
import com.hotent.system.model.msg.impl.WxTextCardMessage;
import com.hotent.system.persistence.manager.SysExternalUniteManager;
import com.hotent.system.util.ExtUniUtil;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WxEnterpriseHandler
implements JmsHandler {
    private static final Logger logger = LoggerFactory.getLogger(WxEnterpriseHandler.class);
    @Resource
    SysMessageManager sysMessageManager;
    @Resource
    MessageLogManager messageLogManager;
    @Resource
    SysExternalUniteManager sysExternalUniteManager;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    TemplateServiceImpl templateServiceImpl;
    @Resource
    UCFeignService uCFeignService;

    public String getType() {
        return NoticeMessageType.WXENTERPRISE.key();
    }

    public boolean send(JmsMessage jmsMessage) {
        try {
            String msg;
            String description;
            List<String> users;
            SysExternalUnite wechatOffAcc;
            List receivers = jmsMessage.getReceivers();
            String content = jmsMessage.getContent();
            content = content.replace("<p>", "");
            content = content.replace("</p>", "");
            jmsMessage.setContent(content);
            MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(jmsMessage.getTemplateAlias());
            if (BeanUtils.isNotEmpty((Object)((Object)msgTemplate))) {
                jmsMessage.getExtendVars().put("templateType", msgTemplate.getTypeKey());
            }
            if (BeanUtils.isNotEmpty((Object)(wechatOffAcc = this.sysExternalUniteManager.getWeChatOfficialAccounts()))) {
                for (JmsActor receiver : receivers) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String url = WeiXinUtil.renderOffAccUrl(jmsMessage);
                    String openIdsByUserIds = this.uCFeignService.getOpenIdsByUserIds(receiver.getId());
                    if (!BeanUtils.isNotEmpty((Object)openIdsByUserIds)) continue;
                    map.put("touser", openIdsByUserIds);
                    map.put("template_id", wechatOffAcc.getTempMsgId());
                    map.put("url", url);
                    HashMap<String, WXTemplateParam> params = new HashMap<String, WXTemplateParam>();
                    params.put("first", new WXTemplateParam(jmsMessage.getSubject(), "#173177"));
                    params.put("keyword1", new WXTemplateParam(jmsMessage.getExtendVars().get("bpmName").toString()));
                    params.put("keyword2", new WXTemplateParam(jmsMessage.getExtendVars().get("creator").toString()));
                    params.put("keyword3", new WXTemplateParam(jmsMessage.getExtendVars().get("date").toString()));
                    params.put("keyword4", new WXTemplateParam(jmsMessage.getExtendVars().get("instSubject").toString()));
                    params.put("remark", new WXTemplateParam("\u70b9\u51fb\u8be6\u60c5\u8df3\u8f6c\u3002", "#173177"));
                    map.put("data", params);
                    String msg2 = JsonUtil.toJson(map);
                    WeiXinUtil.sendWeiXinMessage(msg2);
                }
            }
            if (CollectionUtils.isEmpty(users = JmsHandlerUtil.jmsActor2UserId(receivers))) {
                this.messageLogManager.handLogByMsgHander(jmsMessage, false, "\u65e0\u6d88\u606f\u63a5\u6536\u4eba");
                return false;
            }
            SysExternalUnite wechatWork = this.sysExternalUniteManager.getWechatWork();
            if (BeanUtils.isEmpty((Object)wechatWork)) {
                this.messageLogManager.handLogByMsgHander(jmsMessage, false, "\u96c6\u6210\u4e2d\u5fc3\u65e0\u76f8\u5173\u914d\u7f6e");
                return false;
            }
            String wxWorkIds = this.uCFeignService.getWxWorkIdsByUserIds(String.join((CharSequence)",", users));
            if (StringUtil.isEmpty((String)wxWorkIds)) {
                this.messageLogManager.handLogByMsgHander(jmsMessage, false, "\u7528\u6237\u6570\u636e\u672a\u7ed1\u5b9a\uff0c\u8bf7\u5148\u540c\u6b65\u901a\u8baf\u5f55");
                return false;
            }
            String descriptionNode = "";
            if (jmsMessage.getExtendVars() != null && BeanUtils.isNotEmpty(jmsMessage.getExtendVars().getOrDefault("nodeName", null))) {
                descriptionNode = "\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u4e3a\uff1a" + jmsMessage.getExtendVars().getOrDefault("nodeName", null);
            }
            if (msgTemplate == null) {
                String title = StringUtil.isEmpty((String)jmsMessage.getSubject()) ? "EIP\u6d88\u606f" : jmsMessage.getSubject();
                description = ExtUniUtil.takeOutHtmlTab((String)jmsMessage.getContent());
                WxMarkdownMessage wxMsg = new WxMarkdownMessage(String.join((CharSequence)"|", wxWorkIds.split(",")), "@all", wechatWork.getAgentId(), title, DateUtil.getCurrentTime((String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"), description, descriptionNode);
                msg = WeiXinUtil.sendTextMessage((WxBaseMessage)wxMsg);
            } else {
                String url = WeiXinUtil.renderMobileUrl(jmsMessage);
                description = this.templateServiceImpl.parsePlainContent(msgTemplate, jmsMessage.getExtendVars());
                description = ExtUniUtil.takeOutHtmlTab((String)description);
                String subject = this.templateServiceImpl.parseSubject(msgTemplate, jmsMessage.getExtendVars());
                if (StringUtil.isEmpty((String)url)) {
                    WxMarkdownMessage wxMsg = new WxMarkdownMessage(String.join((CharSequence)"|", wxWorkIds.split(",")), "@all", wechatWork.getAgentId(), subject, DateUtil.getCurrentTime((String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"), description, descriptionNode);
                    msg = WeiXinUtil.sendTextMessage((WxBaseMessage)wxMsg);
                } else {
                    WxTextCardMessage wxMsg = new WxTextCardMessage(String.join((CharSequence)"|", wxWorkIds.split(",")), "@all", wechatWork.getAgentId(), subject, DateUtil.getCurrentTime((String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"), description, descriptionNode, url, "\u8be6\u60c5");
                    msg = WeiXinUtil.sendTextMessage((WxBaseMessage)wxMsg);
                }
            }
            boolean state = StringUtil.isNotEmpty((String)msg) && msg.contains("\"errcode\":0");
            this.messageLogManager.handLogByMsgHander(jmsMessage, state, msg);
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            this.messageLogManager.handLogByMsgHander(jmsMessage, false, ex.getMessage());
            return false;
        }
    }

    public String getTitle() {
        return "\u5fae\u4fe1\u6d88\u606f";
    }

    public boolean getIsDefault() {
        return true;
    }

    public boolean getSupportHtml() {
        return false;
    }
}

