/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.job;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.SseFeignService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.job.model.BaseJob;
import com.hotent.portal.persistence.manager.PopupManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopJob
extends BaseJob {
    private static final Logger logger = LoggerFactory.getLogger(PopJob.class);
    @Resource
    PopupManager popupManager;

    public void executeJob(JobExecutionContext context) throws Exception {
        List connKeys;
        SseFeignService sseFeignService = (SseFeignService)AppUtil.getBean(SseFeignService.class);
        try {
            connKeys = sseFeignService.getKeys();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6SSE\u5728\u7ebf\u8fde\u63a5\u5f02\u5e38\uff01", (Throwable)e);
            throw new BaseException((Throwable)e);
        }
        if (CollUtil.isEmpty((Collection)connKeys)) {
            return;
        }
        HashMap<String, Boolean> mapHistory = new HashMap<String, Boolean>();
        for (String key : connKeys) {
            if (StringUtil.isEmpty((String)key)) {
                return;
            }
            List<String> arr = Arrays.asList(key.split("_"));
            if (arr.size() < 2) {
                logger.error("\u83b7\u53d6\u7684\u7528\u6237\u4fe1\u606f\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff01" + key);
                return;
            }
            String account = arr.get(0);
            String tenantId = arr.get(1);
            String keyHistory = account + tenantId;
            boolean isEqualCache = false;
            if (mapHistory.containsKey(keyHistory)) {
                isEqualCache = (Boolean)mapHistory.get(keyHistory);
            } else {
                List<String> popDataList = this.popupManager.getPopData(account, tenantId);
                String currData = JsonUtil.toJsonString(popDataList);
                String lastData = this.popupManager.getLastPopDataCache(account, tenantId);
                isEqualCache = currData.equals(lastData);
                mapHistory.put(keyHistory, isEqualCache);
                if (!isEqualCache) {
                    this.popupManager.putPopDataCache(account, tenantId, currData);
                }
            }
            if (isEqualCache) continue;
            ObjectNode messageVo = JsonUtil.createObjectNode();
            messageVo.put("type", 1);
            messageVo.put("account", account);
            try {
                sseFeignService.sendMsg(messageVo);
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u6d88\u606f \u5f02\u5e38\uff01" + key, (Throwable)e);
            }
        }
    }
}

