/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.EncryptUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.portal.model.CommonSystem;
import com.hotent.portal.model.Type;
import com.hotent.portal.persistence.dao.CommonSystemMapper;
import com.hotent.portal.persistence.manager.ICommonSystemService;
import com.hotent.portal.persistence.manager.IPermissionService;
import com.hotent.portal.persistence.manager.ITypeService;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonSystemServiceImpl
extends BaseManagerImpl<CommonSystemMapper, CommonSystem>
implements ICommonSystemService {
    private static final Logger logger = LoggerFactory.getLogger(CommonSystemServiceImpl.class);
    @Resource
    ITypeService iTypeService;
    @Resource
    IPermissionService iPermissionService;

    @Override
    public List<Type> getSystems(String type, String systemName, String operation, String form) {
        List<CommonSystem> addedSystems;
        List<Type> types = this.iTypeService.getValidTypes("SYSTEM".equals(form) ? 2 : 3);
        Map<String, Object> rights = this.iPermissionService.getRightMap();
        List<String> authorizeIds = this.iPermissionService.getAuthorizeId(rights, "common-system");
        String ids = "'" + String.join((CharSequence)"','", authorizeIds) + "'";
        List<CommonSystem> rightSystem = ((CommonSystemMapper)this.baseMapper).getRightSystemByAuthId(ids, systemName, type, form);
        if ("setting".equals(operation) && BeanUtils.isNotEmpty(addedSystems = ((CommonSystemMapper)this.baseMapper).getAddedSystem(ContextUtil.getCurrentUserId(), type, ids, form))) {
            HashMap<String, CommonSystem> addedSystemMap = new HashMap<String, CommonSystem>();
            for (CommonSystem commonSystem : addedSystems) {
                addedSystemMap.put(commonSystem.getId(), commonSystem);
            }
            rightSystem.parallelStream().forEach(item -> {
                if (addedSystemMap.containsKey(item.getId())) {
                    item.setAdd(true);
                    item.setRelId(((CommonSystem)((Object)((Object)addedSystemMap.get(item.getId())))).getRelId());
                    item.setRelSort(((CommonSystem)((Object)((Object)addedSystemMap.get(item.getId())))).getRelSort());
                }
            });
        }
        HashMap map = new HashMap();
        rightSystem.forEach(item -> {
            if (!map.containsKey(item.getTypeCode())) {
                this.addUrlTokenForBpm(type, (CommonSystem)((Object)item));
                map.put(item.getTypeCode(), new ArrayList());
            }
            ((List)map.get(item.getTypeCode())).add(item);
        });
        types.forEach(item -> {
            if (map.containsKey(item.getCode())) {
                item.setSystems((List)map.get(item.getCode()));
            }
        });
        return types.parallelStream().filter(item -> BeanUtils.isNotEmpty(item.getSystems())).collect(Collectors.toList());
    }

    @Override
    public List<CommonSystem> getAddedSystem(String userId, String type, String id, String form) {
        return ((CommonSystemMapper)this.baseMapper).getAddedSystem(userId, type, id, form);
    }

    @Override
    public List<CommonSystem> getCommonSystem(String account, String authorizeId, String createTime, String terminalType, String form) {
        return ((CommonSystemMapper)this.baseMapper).getCommonSystem(account, authorizeId, createTime, terminalType, form);
    }

    @Override
    public List<CommonSystem> getHomeSystems(String terminalType, Integer count, String form) {
        String userId = ContextUtil.getCurrentUserId();
        List<String> authorizeId = this.iPermissionService.getAuthorizeId(this.iPermissionService.getRightMap(), "common-system");
        String ids = String.join((CharSequence)"','", authorizeId);
        List<CommonSystem> addedSystem = this.getAddedSystem(userId, terminalType, "'" + ids + "'", form);
        Set addIds = addedSystem.stream().map(CommonSystem::getId).collect(Collectors.toSet());
        LocalDateTime before2Month = LocalDateTime.now().minusDays(60L);
        List<CommonSystem> commonSystem = this.getCommonSystem(userId, "'" + ids + "'", DateFormatUtil.formaDateTime((LocalDateTime)before2Month), terminalType, form);
        for (CommonSystem system : commonSystem) {
            if (!addIds.contains(system.getId())) {
                this.addUrlTokenForBpm(terminalType, system);
                addedSystem.add(system);
            }
            if (addedSystem.size() != count.intValue()) continue;
            break;
        }
        return addedSystem;
    }

    private void addUrlTokenForBpm(String terminalType, CommonSystem system) {
        try {
            if ("mobile".equalsIgnoreCase(terminalType)) {
                IUser cuser = ContextUtil.getCurrentUser();
                String tokenUrl = system.getUrl();
                if (tokenUrl.contains("bpmdev.liando.cn") || tokenUrl.contains("bpm.liando.cn")) {
                    tokenUrl = tokenUrl.indexOf("?") > -1 ? tokenUrl + "&token=" + EncryptUtil.encrypt((String)cuser.getAccount()) : tokenUrl + "?token=" + EncryptUtil.encrypt((String)cuser.getAccount());
                    system.setUrl(tokenUrl);
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u7ed9BPM\u79fb\u52a8\u7aef\u5730\u5740\u4e2d\u8ffd\u52a0token\u5931\u8d25\uff1a%s", e.getMessage()));
        }
    }

    @Override
    public List<CommonSystem> getHomeSystemsV1(String terminalType, Integer count, String form) {
        List<CommonSystem> addedSystem;
        block2: {
            LocalDateTime before2Month;
            String ids;
            String userId;
            block3: {
                userId = ContextUtil.getCurrentUserId();
                List<String> authorizeId = this.iPermissionService.getAuthorizeId(this.iPermissionService.getRightMap(), "common-system");
                addedSystem = new ArrayList<CommonSystem>();
                if (!BeanUtils.isNotEmpty(authorizeId)) break block2;
                ids = String.join((CharSequence)"','", authorizeId);
                addedSystem = ((CommonSystemMapper)this.baseMapper).getAddedSystemOwn(userId, terminalType, "'" + ids + "'", form);
                if (BeanUtils.isNotEmpty(addedSystem) && addedSystem.size() >= count) break block2;
                before2Month = LocalDateTime.now().minusDays(60L);
                if (!BeanUtils.isNotEmpty(addedSystem)) break block3;
                List addIdList = addedSystem.stream().map(CommonSystem::getId).collect(Collectors.toList());
                String addIds = String.join((CharSequence)"','", addIdList);
                List<CommonSystem> commonSystems = ((CommonSystemMapper)this.baseMapper).getCommonSystemNoAdd(userId, "'" + ids + "'", "'" + addIds + "'", DateFormatUtil.formaDateTime((LocalDateTime)before2Month), terminalType, form);
                int difCount = count - addedSystem.size();
                if (!BeanUtils.isNotEmpty(commonSystems)) break block2;
                for (CommonSystem commonSystem : commonSystems) {
                    addedSystem.add(commonSystem);
                    if (--difCount != 0) continue;
                    break block2;
                }
                break block2;
            }
            List<CommonSystem> commonSystem = ((CommonSystemMapper)this.baseMapper).getCommonSystemNoAdd(userId, "'" + ids + "'", null, DateFormatUtil.formaDateTime((LocalDateTime)before2Month), terminalType, form);
            for (CommonSystem system : commonSystem) {
                addedSystem.add(system);
                if (addedSystem.size() != count.intValue()) continue;
                break;
            }
        }
        return addedSystem;
    }

    @Override
    public List<CommonSystem> getAddedSystems(String type, String form) {
        String userId = ContextUtil.getCurrentUserId();
        List<String> authorizeId = this.iPermissionService.getAuthorizeId(this.iPermissionService.getRightMap(), "common-system");
        String ids = String.join((CharSequence)"','", authorizeId);
        return ((CommonSystemMapper)this.baseMapper).getAddedSystem(userId, type, "'" + ids + "'", form);
    }

    @Override
    public CommonSystem getByCode(String code, String type) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonSystem::getSystemCode, (Object)code)).eq(CommonSystem::getForm, (Object)type));
        if (BeanUtils.isNotEmpty((Object)list)) {
            return (CommonSystem)((Object)list.get(0));
        }
        return null;
    }

    public void remove(Serializable id) {
        this.iPermissionService.removeByAuthorizeId("common-system", id.toString());
        this.removeById(id);
    }

    public void removeByIds(String ... ids) {
        for (String id : ids) {
            this.iPermissionService.removeByAuthorizeId("common-system", id);
        }
        this.removeByIds(Arrays.asList(ids));
    }
}

