/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.portal.persistence.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.portal.model.Popup;
import com.hotent.portal.persistence.dao.PopupDao;
import com.hotent.portal.persistence.manager.PopupManager;
import com.hotent.sys.persistence.dao.SysAuthUserDao;
import com.hotent.sys.persistence.manager.CurrentUserService;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.table.datasource.DataSourceUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class PopupManagerImpl
extends BaseManagerImpl<PopupDao, Popup>
implements PopupManager {
    private static Logger logger = LoggerFactory.getLogger(PopupManagerImpl.class);
    private static final String REPLACEMENT_RESULT = "{result}";
    private static final String REPLACEMENT_CUR_USER_ID = "{curUserId}";
    @Resource
    CurrentUserService currentUserService;
    @Resource
    SysAuthUserDao sysAuthUserDao;
    @Resource
    CommonManager commonManager;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    BpmRuntimeFeignService runtimeFeignService;
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    UCFeignService ucFeignService;

    @Override
    public List<Popup> authList(String userId) {
        List<Popup> portalSysPopups = this.getValidList();
        return this.filterAuth(portalSysPopups, userId);
    }

    @CacheEvict(value={"eip:portal:popupRemind"}, allEntries=true)
    public boolean save(Popup entity) {
        return super.save((Object)entity);
    }

    @Override
    @Transactional
    @CacheEvict(value={"eip:portal:popupRemind"}, allEntries=true)
    public boolean saveWithAuth(Popup popup) throws Exception {
        Popup byAlias = this.getByAlias(popup.getAlias());
        if (BeanUtils.isNotEmpty((Object)((Object)byAlias))) {
            throw new BaseException("\u522b\u540d\u3010" + popup.getAlias() + "\u3011\u5df2\u5b58\u5728");
        }
        boolean result = this.save(popup);
        if (result) {
            String ownerNameJson = " [{\"type\":\"everyone\",\"title\":\"\u6240\u6709\u4eba\",\"checked\":true}]";
            this.sysAuthUserManager.saveRights(popup.getId(), "popup", ownerNameJson);
            return true;
        }
        return result;
    }

    @CacheEvict(value={"eip:portal:popupRemind"}, allEntries=true)
    public boolean updateById(Popup entity) {
        return super.updateById((Object)entity);
    }

    @CacheEvict(value={"eip:portal:popupRemind"}, allEntries=true)
    public boolean removeById(Serializable id) {
        return super.removeById(id);
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        return ((PopupManagerImpl)AppUtil.getBean(PopupManagerImpl.class)).removeWithAuth(idList);
    }

    @Override
    @CacheEvict(value={"eip:portal:popupRemind"}, allEntries=true)
    public boolean removeWithAuth(Collection<? extends Serializable> idList) {
        QueryWrapper authQw = new QueryWrapper();
        ((QueryWrapper)authQw.eq((Object)"OBJ_TYPE_", (Object)"popup")).in((Object)"AUTHORIZE_ID_", idList);
        this.sysAuthUserManager.remove((Wrapper)authQw);
        return super.removeByIds(idList);
    }

    @Override
    public List<Popup> filterAuth(List<Popup> portalSysPopups, String userId) {
        if (BeanUtils.isEmpty(portalSysPopups)) {
            return new ArrayList<Popup>();
        }
        Map userRightMap = this.currentUserService.getUserRightMap();
        Map userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        ArrayList<Popup> filterResult = new ArrayList<Popup>();
        for (Popup popup : portalSysPopups) {
            if (!BeanUtils.isNotEmpty((Object)this.sysAuthUserDao.getAuthByAuthorizeId(userRightMapStr, popup.getId()))) continue;
            filterResult.add(popup);
        }
        return filterResult;
    }

    @Override
    public List<Popup> filterData(List<Popup> authList, String userId) throws Exception {
        if (BeanUtils.isEmpty(authList)) {
            return new ArrayList<Popup>();
        }
        ArrayList<Popup> filterResult = new ArrayList<Popup>();
        for (Popup popup : authList) {
            if ("sql".equals(popup.getDataType())) {
                this.filterBySql(filterResult, popup, userId);
                continue;
            }
            if (!"script".equals(popup.getDataType())) continue;
            this.filterByScript(filterResult, popup, userId);
        }
        return filterResult;
    }

    private void filterBySql(List<Popup> result, Popup popup, String userId) throws Exception {
        if (StringUtil.isEmpty((String)popup.getSql())) {
            return;
        }
        if (popup.getSql().contains(REPLACEMENT_CUR_USER_ID)) {
            popup.setSql(popup.getSql().replace(REPLACEMENT_CUR_USER_ID, userId));
        }
        this.databaseContext.switchDS(popup.getDataSourceAlias(), () -> {
            List query = this.jdbcTemplate.queryForList(popup.getSql(), String.class);
            if (BeanUtils.isEmpty((Object)query) || 1 != query.size()) {
                return null;
            }
            if (StringUtil.isNotEmpty((String)popup.getDesc()) && popup.getDesc().contains(REPLACEMENT_RESULT)) {
                popup.setDesc(popup.getDesc().replace(REPLACEMENT_RESULT, (CharSequence)query.get(0)));
            }
            result.add(popup);
            return null;
        }, e -> {
            throw new BaseException(e.getMessage(), (Throwable)e);
        });
    }

    private void filterByScript(List<Popup> result, Popup popup, String userId) throws Exception {
        CommonResult executeResult;
        if (StringUtil.isEmpty((String)popup.getScript())) {
            return;
        }
        if (popup.getScript().contains(REPLACEMENT_CUR_USER_ID)) {
            popup.setScript(popup.getScript().replace(REPLACEMENT_CUR_USER_ID, userId));
        }
        if (BeanUtils.isEmpty((Object)(executeResult = this.runtimeFeignService.executeScript(popup.getScript()))) || !executeResult.getState().booleanValue()) {
            return;
        }
        if (StringUtil.isNotEmpty((String)popup.getDesc()) && popup.getDesc().contains(REPLACEMENT_RESULT)) {
            popup.setDesc(popup.getDesc().replace(REPLACEMENT_RESULT, (CharSequence)executeResult.getValue()));
        }
        result.add(popup);
    }

    @Override
    public String exportPopup(List<String> ids) throws Exception {
        if (BeanUtils.isEmpty(ids)) {
            return "";
        }
        List popups = ((PopupDao)this.baseMapper).selectBatchIds(ids);
        if (BeanUtils.isEmpty((Object)popups)) {
            return "";
        }
        return JsonUtil.toJson((Object)popups);
    }

    @Override
    @Transactional
    public void importFile(String fileStr) throws Exception {
        try {
            List list = (List)JsonUtil.toBean((String)fileStr, List.class);
            for (Object o : list) {
                Popup popup = (Popup)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), Popup.class));
                if (StringUtil.isNotEmpty((String)popup.getId()) && BeanUtils.isNotEmpty((Object)this.getById((Serializable)((Object)popup.getId())))) {
                    this.updateById(popup);
                    continue;
                }
                this.saveWithAuth(popup);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }

    @Override
    public Popup getByAlias(String alias) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"ALIAS_", (Object)alias);
        return (Popup)((Object)this.getOne((Wrapper)qw));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> validateSql(String sql, String dsAlias) throws Exception {
        String decodeSql;
        if (StringUtil.isEmpty((String)sql)) {
            return new CommonResult(false, "sql\u4e3a\u7a7a", (Object)"");
        }
        if (StringUtil.isEmpty((String)dsAlias)) {
            return new CommonResult(false, "\u6570\u636e\u6e90\u4e3a\u7a7a", (Object)"");
        }
        if ("LOCAL_".equals(dsAlias)) {
            dsAlias = "master";
        }
        if ((decodeSql = new String(Base64.decodeBase64((String)sql), StandardCharsets.UTF_8)).contains(REPLACEMENT_CUR_USER_ID)) {
            decodeSql = decodeSql.replace(REPLACEMENT_CUR_USER_ID, ContextUtil.getCurrentUserId());
        }
        DataSource dataSourceByAlias = DataSourceUtil.getDataSourceByAlias((String)dsAlias);
        Connection connection = dataSourceByAlias.getConnection();
        Statement statement = connection.createStatement(1005, 1007);
        try {
            statement.setQueryTimeout(30);
            ResultSet resultSet = statement.executeQuery(decodeSql);
            resultSet.last();
            int row = resultSet.getRow();
            if (1 != row) {
                CommonResult commonResult = new CommonResult(false, "\u901a\u8fc7sql\u67e5\u8be2\u7ed3\u679c\u884c\u6570\u4e0d\u4e3a1", (Object)"");
                return commonResult;
            }
            int columnCount = resultSet.getMetaData().getColumnCount();
            if (1 != columnCount) {
                CommonResult commonResult = new CommonResult(false, "\u901a\u8fc7sql\u67e5\u8be2\u7ed3\u679c\u5217\u6570\u4e0d\u4e3a1", (Object)"");
                return commonResult;
            }
            resultSet.beforeFirst();
            resultSet.next();
            String value = resultSet.getString(1);
            CommonResult commonResult = new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)value);
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u67e5\u8be2\u5931\u8d25:" + e.getMessage(), (Object)"");
            return commonResult;
        }
        finally {
            statement.close();
            connection.close();
        }
    }

    @Override
    public CommonResult<String> importPopup(Optional<Boolean> confirmImport, Optional<String> cacheFileId) throws Exception {
        CommonResult message = new CommonResult("\u5bfc\u5165\u6210\u529f");
        if (confirmImport.orElse(false).booleanValue()) {
            String fileStr = ((PopupManagerImpl)AppUtil.getBean(this.getClass())).getImportFileFromCache(cacheFileId.get());
            if (StringUtil.isEmpty((String)fileStr)) {
                return new CommonResult("\u5bfc\u5165\u7684\u6587\u4ef6\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            this.importFile(fileStr);
        }
        this.delImportFileFromCache(cacheFileId.orElse(""));
        return message;
    }

    @Override
    @CachePut(value={"eip:popup:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"eip:popup:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:popup:importFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response) {
        CommonResult message;
        MultipartFile file = request.getFile("file");
        if (BeanUtils.isEmpty((Object)file)) {
            return new CommonResult(false, "\u6587\u4ef6\u4e3a\u7a7a");
        }
        String uzPath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            uzPath = rootRealPath + File.separator + fileDir;
            String fileStr = FileUtil.readFile((String)(uzPath + File.separator + "popup.json"));
            List list = (List)JsonUtil.toBean((String)fileStr, List.class);
            ArrayList<String> names = new ArrayList<String>();
            for (Object o : list) {
                Popup popup = (Popup)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), Popup.class));
                Popup oldPopup = (Popup)((Object)super.getById((Serializable)((Object)popup.getId())));
                if (oldPopup == null) continue;
                names.add(popup.getName());
            }
            if (BeanUtils.isEmpty(names)) {
                this.importFile(fileStr);
                message = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            } else {
                String cacheFileId = UniqueIdUtil.getSuid();
                ((PopupManagerImpl)AppUtil.getBean(this.getClass())).putImportFileInCache(cacheFileId, fileStr);
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u5f39\u7a97\u3010" + String.join((CharSequence)"\uff0c", names) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u4e3a\u5176\u65b0\u589e\u7248\u672c\uff1f", (Object)cacheFileId);
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            File file1;
            if (StringUtil.isNotEmpty((String)uzPath) && (file1 = new File(uzPath)).exists()) {
                file1.delete();
            }
        }
        return message;
    }

    @Override
    public CommonResult<String> getPopupStyle() {
        CommonResult ok = new CommonResult(true, "\u67e5\u8be2\u6210\u529f!", (Object)"");
        List popups = this.getAll();
        if (BeanUtils.isNotEmpty((Object)popups)) {
            String styleContent = ((Popup)((Object)popups.get(0))).getStyleContent();
            ok.setValue((Object)styleContent);
        }
        return ok;
    }

    @Override
    @CacheEvict(value={"eip:portal:popupRemind"}, allEntries=true)
    public CommonResult<Object> updatePopupStyle(String styleContent) {
        List popups = this.getAll();
        popups.forEach(popup -> popup.setStyleContent(styleContent));
        boolean result = this.updateBatchById(popups);
        return new CommonResult(result, result ? "\u66f4\u65b0\u6210\u529f\uff01" : "\u66f4\u65b0\u5931\u8d25");
    }

    private List<Popup> getValidList() {
        LocalDateTime curDate = LocalDateTime.now();
        QueryWrapper qw = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)qw.eq((Object)"is_enable_", (Object)1)).lt((Object)"VALIDITY_START_", (Object)curDate)).gt((Object)"VALIDITY_END_", (Object)curDate)).orderByAsc((Object)"ORDER_");
        return ((PopupDao)this.baseMapper).selectList((Wrapper)qw);
    }

    @Override
    public List<String> getPopData(String account, String tenantId) {
        List<String> result = new ArrayList<String>();
        JsonNode userNode = null;
        try {
            userNode = this.ucFeignService.getByAccountAndTenant(account, tenantId);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7528\u6237\u8d26\u53f7\u548c\u4f01\u4e1aID\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        String userId = JsonUtil.getString((JsonNode)userNode, (String)"id");
        if (StringUtil.isNotEmpty((String)userId)) {
            List<Popup> popups = this.getValidList();
            try {
                popups = this.filterData(popups, userId);
            }
            catch (Exception e) {
                logger.error("\u6267\u884cSQL\u6216\u8005\u811a\u672c\u5f02\u5e38\uff01", (Throwable)e);
            }
            if (CollUtil.isNotEmpty(popups)) {
                result = popups.stream().map(Popup::getDesc).collect(Collectors.toList());
            }
        }
        return result;
    }

    @Override
    @Cacheable(value={"eip:portal:lastPopData"}, key="#account + '-' + #tenantId", ignoreException=false)
    public String getLastPopDataCache(String account, String tenantId) {
        return null;
    }

    @Override
    @CachePut(value={"eip:portal:lastPopData"}, key="#account + '-' + #tenantId")
    public String putPopDataCache(String account, String tenantId, String popData) {
        return popData;
    }
}

